/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XMLTraceDataProcessor
extends XMLLoader
implements DataServerListener {
    private boolean newFile;
    private static final String NEW_LINE = "\n";
    private static final int BUFFER_SIZE = 65536;
    private boolean firstEvent = true;
    private OutputStream fileWriter = null;
    private String profileFileName = null;
    private TRCMonitor _monitor;
    private boolean _changed = false;
    private int timeout = 0;
    private String bufStr;
    private final String START_TAG = "<TRACE>";
    private final String END_TAG = "</TRACE>";
    private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    private final String START_TRACE = "<TRACE>\n";
    private final String END_TRACE = "</TRACE>\n";
    private final String XML_VERSION = "<?xml version=\"1.0\"?>\n";

    public XMLTraceDataProcessor(TRCAgentProxy agent) {
        super(agent);
        this.setCollectionMode(agent.getCollectionMode().getValue());
        new RefreshUI().start();
    }

    public XMLTraceDataProcessor(TRCMonitor monitor) {
        super(monitor);
    }

    public void setWriter(OutputStream fw) {
        this.fileWriter = fw;
    }

    public OutputStream getWriter() {
        return this.fileWriter;
    }

    public void setProfileFileName(String profileFileName) {
        this.profileFileName = profileFileName;
    }

    public String getProfileFileName() {
        return this.profileFileName;
    }

    public void createWriter() {
        try {
            if (this.profileFileName != null) {
                this.fileWriter = this.makeWriter();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private OutputStream makeWriter() throws IOException {
        File f = new File(this.profileFileName);
        if (f.exists()) {
            if (!PDCoreUtil.isZipFile(this.profileFileName)) {
                this.newFile = false;
                return new BufferedOutputStream(new FileOutputStream(this.profileFileName, true), 65536);
            }
            File newFileName = new File(f.getParentFile().getAbsolutePath() + "\\Temp-" + new Date().getTime());
            this.renameFile(f, newFileName);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f), 65536));
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(newFileName), 65536));
            this.copyZip(zipInputStream, zipOutputStream);
            zipInputStream.close();
            newFileName.delete();
            ZipEntry traceEntry = new ZipEntry("TraceContents-" + this.getTimeStamp() + ".xml");
            zipOutputStream.putNextEntry(traceEntry);
            this.newFile = true;
            return zipOutputStream;
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.profileFileName));
        ZipOutputStream zipStream = new ZipOutputStream(fos);
        ZipEntry traceEntry = new ZipEntry("TraceContents-" + this.getTimeStamp() + ".xml");
        zipStream.putNextEntry(traceEntry);
        this.newFile = true;
        return zipStream;
    }

    private boolean renameFile(File f, File newFileName) {
        boolean ret = f.renameTo(newFileName);
        if (!ret) {
            ret = this.copyFile(f, newFileName);
            f.delete();
        }
        return ret;
    }

    private boolean copyFile(File f, File newFileName) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(f), 65536);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(newFileName), 65536);
            byte[] buffer = new byte[65536];
            while (bufferedInputStream.available() > 0) {
                int bytesRead = bufferedInputStream.read(buffer);
                bufferedOutputStream.write(buffer);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void copyZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry;
        byte[] data = new byte[65536];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int byteCount;
            void var3_4;
            zipOutputStream.putNextEntry((ZipEntry)var3_4);
            while ((byteCount = zipInputStream.read(data, 0, 65536)) != -1) {
                void var4_5;
                zipOutputStream.write(data, 0, (int)var4_5);
            }
            zipOutputStream.closeEntry();
        }
    }

    private String getTimeStamp() {
        return DateFormat.getDateTimeInstance(0, 0).format(new Date()).replace(' ', '_').replace(':', '_').replace(',', '_');
    }

    public void dataServerExited() {
        try {
            if (this.getAgentProxy() != null) {
                this.getAgentProxy().setCollectionData(false);
                this.endTrace(this.getWriter());
                this.setProfileFileName(null);
                this.setWriter(null);
                this.cleanUp();
                Display d = Display.getDefault();
                d.asyncExec(new Runnable(){

                    public void run() {
                        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                        event.setSource(XMLTraceDataProcessor.this.getAgentProxy());
                        event.setType(1024);
                        UIPlugin.getDefault().notifyProfileEventListener(event);
                    }
                });
            }
        }
        catch (Exception exc) {}
    }

    public void dispose() {
        super.cleanUp();
        this.fileWriter = null;
    }

    public void endTrace(OutputStream randomFile) {
        try {
            if (randomFile != null) {
                randomFile.close();
                randomFile = null;
            }
        }
        catch (IOException e) {}
    }

    private boolean isValidTag(byte[] buf) {
        return !this.startsWith(buf, "<TRACE>".getBytes()) && !this.startsWith(buf, "<?xml version=\"1.0\"?>".getBytes());
    }

    private boolean startsWith(byte[] container, byte[] bytes) {
        if (container.length < bytes.length) {
            return false;
        }
        int i = 0;
        while (i < bytes.length) {
            if (container[i] != bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void incommingData(byte[] buffer, int length, InetAddress peer) {
        this._changed = true;
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                if (this.isValidTag(buffer)) {
                    this.writeByte(buffer, length);
                }
            } else {
                if (this.firstEvent) {
                    if (length > 1 && (buffer[0] != 60 || buffer[1] != 63)) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(buffer, length);
            }
        }
        catch (InvalidXMLException e) {
        }
        catch (OutOfMemoryError e) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            throw e;
        }
    }

    public void incommingData(char[] buffer, int length, InetAddress peer) {
        byte[] newBuffer = new byte[length];
        int i = 0;
        while (i < length) {
            newBuffer[i] = (byte)buffer[i];
            ++i;
        }
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                if (this.isValidTag(newBuffer)) {
                    this.writeByte(newBuffer, length);
                }
            } else {
                if (this.firstEvent) {
                    if (length > 1 && (buffer[0] != '<' || buffer[1] != '?')) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(newBuffer, length);
            }
        }
        catch (InvalidXMLException e) {
        }
        catch (OutOfMemoryError e) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            throw e;
        }
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
    }

    public void waitingForData() {
    }

    public void startTrace(OutputStream randomFile) {
        try {
            if (this.getAgentProxy() != null) {
                randomFile.write("<TRACE>\n".getBytes());
                randomFile.flush();
            }
        }
        catch (IOException e) {}
    }

    public void writeHeader(Writer randomFile) {
    }

    public void writeXMLVersion(OutputStream randomFile) {
        try {
            randomFile.write("<?xml version=\"1.0\"?>\n".getBytes());
            randomFile.flush();
        }
        catch (IOException e) {}
    }

    private TRCAgentProxy getAgentProxy() {
        return this.getContext().getAgentProxy();
    }

    private String getApplicationExecutableString(TRCProcessProxy process) {
        String exeStr = "";
        if (process.getName() == null) {
            return "";
        }
        if (!process.getName().equals("")) {
            exeStr = "java.exe -XrunpiAgent:server=controlled ";
            if (process.getClasspath() != null && !process.getClasspath().equals("")) {
                exeStr = exeStr + "-cp ";
                exeStr = exeStr + process.getClasspath().trim();
                exeStr = exeStr + " ";
            }
            if (process.getVmArguments() != null && !process.getVmArguments().equals("")) {
                exeStr = exeStr + process.getVmArguments().trim();
                exeStr = exeStr + " ";
            }
            exeStr = exeStr + process.getName();
            if (process.getParameters() != null && !process.getParameters().equals("")) {
                exeStr = exeStr + process.getParameters();
            }
        }
        return exeStr;
    }

    private void handleOutOfMemoryError() {
        String text = UIPlugin.getResourceString("PROFILE_OUT_OF_MEMORY_ERROR_");
        final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)new Shell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("OUT_OF_MEMORY_ERROR_TITLE"), (IStatus)err);
            }
        });
    }

    private synchronized void notifyListener(Agent a, TRCAgentProxy agent) {
        final TRCAgentProxy ag = agent;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(ag);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    private void stopAgent() {
        if (this.getAgentProxy() != null) {
            try {
                Agent ai = (Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy());
                if (ai != null) {
                    ai.stopMonitoring();
                }
            }
            catch (InactiveAgentException e) {
                e.printStackTrace();
            }
            this.getAgentProxy().setMonitored(false);
            this.getAgentProxy().setAttached(false);
            this.getAgentProxy().setActive(false);
            LoadersUtils.deregisterDataProcessor((TRCAgentProxy)this.getAgentProxy());
            if (this.fileWriter != null) {
                this.endTrace(this.fileWriter);
            }
            this.notifyListener((Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy()), this.getAgentProxy());
        }
    }

    private void writeByte(byte[] data, int length) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(data, 0, length);
                this.fileWriter.write(NEW_LINE.getBytes());
                this.fileWriter.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isNewProfileFile() {
        return this.newFile;
    }

    class RefreshUI
    extends Thread {
        public RefreshUI() {
            super("Profile UI");
        }

        public void run() {
            while (XMLTraceDataProcessor.this.getAgentProxy() != null && XMLTraceDataProcessor.this.getAgentProxy().isActive()) {
                try {
                    Display d;
                    if (XMLTraceDataProcessor.this._changed) {
                        XMLTraceDataProcessor.this._changed = false;
                        if (!XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                            XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(true);
                            d = Display.getDefault();
                            d.asyncExec(new Runnable(this){
                                private final /* synthetic */ RefreshUI this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                                    event.setSource(XMLTraceDataProcessor.access$000(RefreshUI.access$200(this.this$1)));
                                    event.setType(512);
                                    UIPlugin.getDefault().notifyProfileEventListener(event);
                                }
                            });
                        }
                    } else if (XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                        XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(false);
                        d = Display.getDefault();
                        d.asyncExec(new Runnable(this){
                            private final /* synthetic */ RefreshUI this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                                event.setSource(XMLTraceDataProcessor.access$000(RefreshUI.access$200(this.this$1)));
                                event.setType(1024);
                                UIPlugin.getDefault().notifyProfileEventListener(event);
                            }
                        });
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ XMLTraceDataProcessor access$200(RefreshUI x0) {
            return x0.XMLTraceDataProcessor.this;
        }
    }
}

