/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.FilterList;

public class FilterTableElement {
    public static final String P_VISIBILITY = "combo";
    public static final String P_TEXT = "string";
    public static final String P_METHOD = "method";
    private String fText;
    private String fMethod = "*";
    private String fVisibility;
    protected static final String[] fVisibilityState = new String[]{UIPlugin.getResourceString("STR_EXCLUDE"), UIPlugin.getResourceString("STR_INCLUDE")};
    private FilterList fParent;

    public FilterTableElement(String text, String method, String visibility) {
        this.fMethod = method;
        this.fText = text;
        this.fVisibility = visibility;
    }

    public void setParent(FilterList parent) {
        this.fParent = parent;
    }

    public String getMethod() {
        return this.fMethod;
    }

    public String getText() {
        return this.fText;
    }

    public String getVisibility() {
        return this.fVisibility;
    }

    public int getVisibilityState() {
        int idx = 0;
        while (idx < fVisibilityState.length) {
            if (fVisibilityState[idx].equals(this.fVisibility)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static String[] getVisibilityStates() {
        return fVisibilityState;
    }

    public void setMethod(String value) {
        this.fMethod = value;
        this.fParent.fireElementChanged(this, P_METHOD);
    }

    public void setText(String value) {
        this.fText = value;
        this.fParent.fireElementChanged(this, P_TEXT);
    }

    public void setVisibility(int value) {
        this.fVisibility = fVisibilityState[value];
        this.fParent.fireElementChanged(this, P_VISIBILITY);
    }

    public void setVisibility(String value) {
        this.fVisibility = value;
        if (this.fParent != null) {
            this.fParent.fireElementChanged(this, P_VISIBILITY);
        }
    }

    public String toString() {
        return this.fText + "," + this.fVisibility;
    }
}

