/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;

public class ProfilingProcessList {
    private Vector items = new Vector();

    public void initializeFromProcesses(Object[] p_items) {
        this.items.clear();
        int i = 0;
        while (i < p_items.length) {
            this.items.addElement(p_items[i]);
            ++i;
        }
    }

    public void addProcess(Object item) {
        this.items.addElement(item);
    }

    public void removeProcess(Object item) {
        this.items.removeElement(item);
    }

    public Object[] getProcesses() {
        return this.items.toArray();
    }

    public int getProcessCount() {
        return this.items.size();
    }

    public Object getProcessForPID(String PID) {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.elementAt(i) instanceof ProcessTreeItem) {
                Process process = (Process)((ProcessTreeItem)this.items.elementAt(i)).getData();
                try {
                    if (PID != null && PID.equals(process.getProcessId())) {
                        return this.items.elementAt(i);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    public Object[] getPIDs() {
        Vector<String> PIDs = new Vector<String>();
        int i = 0;
        while (i < this.items.size()) {
            Process process = (Process)((ProcessTreeItem)this.items.elementAt(i)).getData();
            try {
                PIDs.addElement(process.getProcessId());
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return PIDs.toArray();
    }

    public Object[] getAllAgents() {
        Vector agentsV = new Vector();
        int i = 0;
        while (i < this.items.size()) {
            Process process = (Process)((ProcessTreeItem)this.items.elementAt(i)).getData();
            Enumeration agents = process.listAgents();
            while (agents.hasMoreElements()) {
                agentsV.addElement(agents.nextElement());
            }
            ++i;
        }
        return agentsV.toArray();
    }
}

