/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileTypeGroupUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProfilingTypesPageContent
extends Composite {
    private StackLayout detailsLayout;
    private Control[] controls;
    private IProfilingSetType[] profilingTypes;
    private Control currentControl = null;
    private TraceProfileTypeGroupUI _traceProfileTypeGroupUI;
    private Map groupControls = new HashMap();

    public ProfilingTypesPageContent(Composite composite, int style) {
        super(composite, style);
    }

    public Composite createContent(IProfilingSetType[] types, ProfilingSetsManagerCopy copy) {
        this.detailsLayout = new StackLayout();
        this.setLayout((Layout)this.detailsLayout);
        this.setLayoutData(new GridData(1808));
        this.controls = new Control[types.length + 1];
        this.profilingTypes = types;
        int i = 0;
        while (i < types.length) {
            this.controls[i] = types[i].getProfilingType().createControl(this, copy);
            this.controls[i].setVisible(false);
            ++i;
        }
        this.controls[this.controls.length - 1] = new Composite((Composite)this, 0);
        this.controls[this.controls.length - 1].setVisible(false);
        Map groups = copy.getProfilingTypesGroups();
        Object[] keySet = groups.keySet().toArray();
        this._traceProfileTypeGroupUI = new TraceProfileTypeGroupUI();
        int j = 0;
        while (j < keySet.length) {
            IProfilingSetTypeGroup pTypeGroup = (IProfilingSetTypeGroup)groups.get(keySet[j]);
            this.groupControls.put(pTypeGroup.getId(), this._traceProfileTypeGroupUI.createControl(this, pTypeGroup.getName(), pTypeGroup.getDescription()));
            ++j;
        }
        return null;
    }

    public boolean performApply(ProfilingSetsManagerCopy copy) {
        IProfilingSet set = copy.getDefaultSet();
        if (set == null) {
            return true;
        }
        StringBuffer errorMsg = new StringBuffer();
        List types = set.getProfilingTypes();
        int i = 0;
        while (i < this.profilingTypes.length) {
            IProfilingType type;
            String msg;
            if (types.contains(this.profilingTypes[i].getId()) && (msg = (type = this.profilingTypes[i].getProfilingType()).validateConfiguration(copy)) != null) {
                errorMsg.append(msg).append("\n");
            }
            ++i;
        }
        if (errorMsg.length() > 0) {
            String msg = UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_MSG");
            if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), (String)(msg + errorMsg.toString()))) {
                return false;
            }
        }
        List optionsList = ProfilingSetsManager.getDefaultProfilingOptions();
        int i2 = 0;
        while (i2 < this.profilingTypes.length) {
            if (types.contains(this.profilingTypes[i2].getId())) {
                IProfilingType type = this.profilingTypes[i2].getProfilingType();
                ProfilingAttribute[] options = type.getAttributes();
                int idx = 0;
                while (idx < options.length) {
                    optionsList.add(options[idx]);
                    ++idx;
                }
            }
            ++i2;
        }
        optionsList = ProfilingSetsManager.filterDuplicateOptions(optionsList);
        set.getAttributes().clear();
        Map attrs = set.getAttributes();
        int idx = 0;
        while (idx < optionsList.size()) {
            ProfilingAttribute option = (ProfilingAttribute)optionsList.get(idx);
            attrs.put(option.getName(), option);
            ++idx;
        }
        return true;
    }

    public void showDetailsFor(Control detail) {
        this.detailsLayout.topControl = detail;
        this.currentControl = detail;
        detail.setVisible(true);
        this.layout();
    }

    public void showGroupDetails(IProfilingSetTypeGroup pTypeGroup) {
        Control currentControl;
        Control newControl = (Control)this.groupControls.get(pTypeGroup.getId());
        if (!newControl.equals(currentControl = this.getCurrentlyDisplayingControl())) {
            this.showDetailsFor(newControl);
        }
        this.layout();
    }

    public void showEmptyDetails() {
        this.detailsLayout.topControl = this.controls[this.controls.length - 1];
        this.currentControl = this.controls[this.controls.length - 1];
        this.controls[this.controls.length - 1].setVisible(true);
        this.layout();
    }

    public void dispose() {
        this.currentControl = null;
        this.profilingTypes = null;
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null) {
                this.controls[i].dispose();
            }
            ++i;
        }
        Object[] groupControlsArray = this.groupControls.values().toArray();
        int j = 0;
        while (j < groupControlsArray.length) {
            if ((Control)groupControlsArray[j] != null) {
                ((Control)groupControlsArray[j]).dispose();
            }
            ++j;
        }
        this.groupControls.clear();
        this.groupControls = null;
        this.controls = null;
    }

    public Control getCurrentlyDisplayingControl() {
        return this.currentControl;
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }
}

