/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.wizard.IProfileSetWizardPage;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileSetWizard;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProfileSetWizardPage1
extends WizardPage
implements IProfileSetWizardPage,
ModifyListener {
    private String _name;
    private Text _nameText;
    private String _description;
    private Text _descText;

    public ProfileSetWizardPage1(String pageId, String name, String description, ProfilingSetsManagerCopy managerCopy) {
        super(pageId);
        this._name = name;
        this._description = description;
        this.setImageDescriptor(PDPluginImages.getImageDescriptor("profset_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.widthHint = 400;
        result.setLayoutData((Object)data);
        Label label1 = new Label(result, 0);
        label1.setText(UIPlugin.getResourceString("STR_PROFILING_SET_NAME"));
        this._nameText = new Text(result, 2048);
        this._nameText.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label2 = new Label(result, 0);
        label2.setText(UIPlugin.getResourceString("STR_PROFILING_SET_DESCRIPTION"));
        label2.setLayoutData((Object)new GridData(2));
        data = GridUtil.createHorizontalFill();
        data.heightHint = 80;
        data.widthHint = 400;
        this._descText = new Text(result, 2624);
        this._descText.setLayoutData((Object)data);
        this._nameText.addModifyListener((ModifyListener)this);
        this._descText.addModifyListener((ModifyListener)this);
        if (this._name == null) {
            this._name = UIPlugin.getResourceString("FILTER_SET_DEFAULT_NAME");
        }
        this._nameText.setText(this._name);
        if (this._description == null) {
            this._description = UIPlugin.getResourceString("FILTER_SET_DEFAULT_DESCRIPTION");
        }
        this._descText.setText(this._description);
        this.setControl((Control)result);
    }

    public boolean performApply(ProfilingSetsManagerCopy copy) {
        this._name = this._nameText.getText().trim();
        this._description = this._descText.getText();
        ((ProfileSetWizard)this.getWizard()).setProfileSetName(this._name);
        ((ProfileSetWizard)this.getWizard()).setProfileSetDescription(this._description);
        ((ProfileSetWizard)this.getWizard()).setNameToPages();
        return true;
    }

    public void modifyText(ModifyEvent e) {
        if (this.isCurrentPage()) {
            this.updatePage();
        }
    }

    private void updatePage() {
        if (this.nameExists()) {
            this.setErrorMessage(UIPlugin.getResourceString("STR_ADD_PROFILINGSET_NAME_EXISTS"));
        } else if (this.nameOrDescriptionBlank()) {
            this.setErrorMessage(UIPlugin.getResourceString("STR_ADD_PROFILINGSET_NAME_BLANK"));
        } else {
            this.setErrorMessage(null);
        }
        this.getWizard().getContainer().updateButtons();
    }

    public void initializeFrom(ProfilingSetsManagerCopy copy) {
    }

    private boolean nameExists() {
        return ((ProfileSetWizard)this.getWizard()).profileNameExists(this._nameText.getText().trim());
    }

    private boolean nameOrDescriptionBlank() {
        return this._nameText.getText().trim().length() == 0 || this._descText.getText().trim().length() == 0;
    }

    private boolean textFieldsOK() {
        return !this.nameExists() && !this.nameOrDescriptionBlank();
    }

    public boolean canFlipToNextPage() {
        return this.textFieldsOK();
    }

    public boolean isPageComplete() {
        return this.textFieldsOK();
    }
}

