/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Comparator;
import java.util.List;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingTypesPageContent;
import org.eclipse.hyades.trace.ui.internal.util.Sorter;
import org.eclipse.hyades.trace.ui.internal.util.TreeContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.TreeLabelProvider;
import org.eclipse.hyades.trace.ui.internal.wizard.IProfileSetWizardPage;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ProfileSetWizardPage2
extends WizardPage
implements IProfileSetWizardPage,
ICheckStateListener,
ISelectionChangedListener {
    private boolean pageComplete;
    private ProfilingTypesPageContent dc;
    private String profilingSetName;
    private CheckboxTreeViewer treeViewer;
    private TreeContentProvider provider;
    private ProfilingSetsManagerCopy copy;
    private TraceProfileOverviewUI _overviewUI;

    public ProfileSetWizardPage2(String pageId, String psName, ProfilingSetsManagerCopy managerCopy, TraceProfileOverviewUI overviewUI) {
        super(pageId);
        this.profilingSetName = psName;
        this.copy = managerCopy;
        this.setImageDescriptor(PDPluginImages.getImageDescriptor("profset_wiz.gif"));
        this._overviewUI = overviewUI;
    }

    public boolean isPageComplete() {
        return this.pageComplete;
    }

    public boolean canFlipToNextPage() {
        return this.pageComplete;
    }

    public void dispose() {
        this.dc.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        data = GridUtil.createFill();
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        this.provider = new TreeContentProvider(this._overviewUI);
        this.treeViewer = new CheckboxTreeViewer(result);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setSorter(new ViewerSorter(){
            private Comparator c = new Sorter();

            public int compare(Viewer viewer, Object e1, Object e2) {
                return this.c.compare(e1, e2);
            }
        });
        Object[] profileTypeGroups = this._overviewUI.getManagerCopy().getProfilingTypesGroups().values().toArray();
        Object[] profilingTypes = this._overviewUI.getManagerCopy().getProfilingTypes().values().toArray();
        ImageDescriptor[] descriptorList = new ImageDescriptor[profileTypeGroups.length + profilingTypes.length];
        int i = 0;
        while (i < profileTypeGroups.length) {
            descriptorList[i] = ((IProfilingSetTypeGroup)profileTypeGroups[i]).getIcon();
            ++i;
        }
        int j = 0;
        while (j < profilingTypes.length) {
            IProfilingSetType pType = (IProfilingSetType)profilingTypes[j];
            descriptorList[j + profileTypeGroups.length] = pType.getImage();
            ++j;
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider(descriptorList));
        this.treeViewer.setInput((Object)"");
        this.treeViewer.getTree().setLayout((Layout)layout2);
        this.treeViewer.getTree().setLayoutData((Object)GridUtil.createVerticalFill());
        ProfilingSetType[] array = new ProfilingSetType[this._overviewUI.getManagerCopy().getProfilingTypes().size()];
        this.dc = new ProfilingTypesPageContent(result, 0);
        this.dc.createContent(this._overviewUI.getManagerCopy().getProfilingTypes().values().toArray(array), this.copy);
        this.dc.setVisible(true);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setControl((Control)result);
        this.setPageComplete(this.isPageComplete());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateWizardPageMsgsBtns();
        }
    }

    private void setChecked(IProfilingSetType ptype) {
        if (ptype == null) {
            return;
        }
        this.treeViewer.expandToLevel((Object)ptype, 0);
        this.treeViewer.setChecked((Object)ptype, true);
        Object parent = this.provider.getParent(ptype);
        Object[] siblings = this.provider.getChildren(parent);
        boolean foundUnchecked = false;
        int i = 0;
        while (i < siblings.length) {
            if (!this.treeViewer.getChecked(siblings[i])) {
                foundUnchecked = true;
            }
            ++i;
        }
        this.treeViewer.setChecked(parent, true);
        this.treeViewer.setGrayed(parent, foundUnchecked);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object checkedElement = event.getElement();
        if (checkedElement instanceof IProfilingSetType) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(checkedElement));
            Object parent = this.provider.getParent(checkedElement);
            Object[] siblings = this.provider.getChildren(parent);
            boolean foundChecked = false;
            boolean foundUnchecked = false;
            int i = 0;
            while (i < siblings.length) {
                if (this.treeViewer.getChecked(siblings[i])) {
                    foundChecked = true;
                } else {
                    foundUnchecked = true;
                }
                ++i;
            }
            this.treeViewer.setChecked(parent, foundChecked);
            this.treeViewer.setGrayed(parent, foundChecked && foundUnchecked);
        } else if (checkedElement instanceof IProfilingSetTypeGroup) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(checkedElement));
            this.treeViewer.setGrayed(checkedElement, false);
            this.treeViewer.setSubtreeChecked(checkedElement, event.getChecked());
        }
        this.updateWizardPage();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateWizardPage();
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof IProfilingSetType) {
            this.updateGui((IProfilingSetType)selection.getFirstElement());
        } else if (selection.getFirstElement() instanceof IProfilingSetTypeGroup) {
            this.dc.showGroupDetails((IProfilingSetTypeGroup)selection.getFirstElement());
        } else {
            this.dc.showEmptyDetails();
        }
    }

    private void updateGui(IProfilingSetType newProfileType) {
        Control currentControl;
        Control newControl = newProfileType.getProfilingType().getControl(this.profilingSetName);
        if (!newControl.equals(currentControl = this.dc.getCurrentlyDisplayingControl())) {
            this.dc.showDetailsFor(newControl);
        }
    }

    private void updateWizardPageMsgsBtns() {
        if (!this.pageComplete) {
            this.setErrorMessage(UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_DESC_NOT_SELECTED"));
        } else {
            this.setErrorMessage(null);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void updateWizardPage() {
        Object[] checkedElementList = this.treeViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElementList.length) {
            IProfilingSetType nextProfile;
            if (checkedElementList[i] instanceof IProfilingSetType && (nextProfile = (IProfilingSetType)checkedElementList[i]).isUseFilters()) {
                this.pageComplete = nextProfile.isUseFilters();
                this.updateWizardPageMsgsBtns();
                return;
            }
            ++i;
        }
        this.pageComplete = false;
        this.updateWizardPageMsgsBtns();
    }

    public void initializeFrom(ProfilingSetsManagerCopy copy) {
        IProfilingType type;
        Object obj;
        IStructuredSelection sel;
        IProfilingSet set = copy.getDefaultSet();
        if (set == null) {
            return;
        }
        List types = set.getProfilingTypes();
        int idx = 0;
        while (idx < types.size()) {
            String type2 = types.get(idx).toString();
            Object ptype = copy.getProfilingTypes().get(type2);
            if (type2 != null) {
                this.setChecked((IProfilingSetType)ptype);
            }
            ++idx;
        }
        Object[] checked = this.treeViewer.getCheckedElements();
        if (checked != null) {
            int i = 0;
            while (i < checked.length) {
                if (checked[i] instanceof IProfilingSetType) {
                    StructuredSelection selection = new StructuredSelection(checked[i]);
                    this.treeViewer.setSelection((ISelection)selection, true);
                    break;
                }
                ++i;
            }
        }
        if ((sel = (IStructuredSelection)this.treeViewer.getSelection()) != null && !sel.isEmpty() && (obj = sel.getFirstElement()) != null && obj instanceof IProfilingSetType && (type = ((IProfilingSetType)obj).getProfilingType()) != null) {
            type.getControl(this.profilingSetName);
        }
    }

    public void setProfilingSetName(String name) {
        this.profilingSetName = name;
    }

    public boolean performApply(ProfilingSetsManagerCopy copy) {
        IProfilingSet set = copy.getDefaultSet();
        set.getProfilingTypes().clear();
        Object[] selections = this.treeViewer.getCheckedElements();
        int idx = 0;
        while (idx < selections.length) {
            Object type = selections[idx];
            if (type != null && type instanceof IProfilingSetType) {
                set.getProfilingTypes().add(((IProfilingSetType)type).getId());
            }
            ++idx;
        }
        return this.dc.performApply(copy);
    }
}

