/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.CoverageStatisticPage;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticViewer;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticMethodView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.util.internal.CoverageFolder;
import org.eclipse.hyades.trace.views.util.internal.IColumnExtension;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class CoverageStatisticView
extends MultiLevelStatisticMethodView {
    public static final String CALLS_NOT_COMPUTED = "COVERAGE_STATISTICS.CALLS_NOT_COMPUTED";
    private int _numberOfColumns = 7;
    private static int _level = 1;
    private boolean _isCallsMeaningfull = true;

    public CoverageStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
    }

    public boolean isEmpty() {
        CoverageAnalysis covAnalysis = ((CoverageStatisticPage)this._page).getCovAnalysis();
        return covAnalysis.getRoot() == null || covAnalysis.getRoot().getMethods() == 0;
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":221," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:0" + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:0" + ":100," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:120," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:120";
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:0" + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:" + String.valueOf(1) + ":150," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:60," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:100";
    }

    protected String getDefaultColumnsTemplateMethodLevel() {
        return TraceUIPlugin.getString("STR_COL_ITEM_NAMES") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_COL_CLASS_NAME") + ":1:" + String.valueOf(1) + ":100," + TraceUIPlugin.getString("STR_COL_PACKAGE") + ":2:" + String.valueOf(1) + ":100," + TraceUIPlugin.getString("STR_COL_CALLS") + ":3:" + String.valueOf(1) + ":right:45," + TraceUIPlugin.getString("STR_COL_METHOD_MISSED") + ":4:" + String.valueOf(1) + ":right:90," + TraceUIPlugin.getString("STR_COL_METHOD_HIT") + ":5:" + String.valueOf(1) + ":right:90," + TraceUIPlugin.getString("STR_COL_RATE") + ":6:" + String.valueOf(1) + ":right:90";
    }

    public String getDefaultColumnsTemplate() {
        String columns = super.getDefaultColumnsTemplate();
        if (columns == null) {
            columns = "";
        }
        return columns + this.getColumnsTemplateExtensions();
    }

    public String getColumnsTemplateExtensions() {
        IConfigurationElement[] members;
        String columnName = "";
        String pos = "";
        String style = "";
        String width = "";
        String align = "";
        int colNumber = this._numberOfColumns;
        this._templateOfColumExtension = "";
        this._listOfColumExtension.clear();
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.trace.views.columnExtension");
        if (extPoint != null && (members = extPoint.getConfigurationElements()).length != 0) {
            int i = 0;
            while (i < members.length) {
                columnName = members[i].getAttribute("name");
                pos = members[i].getAttribute("pos");
                style = members[i].getAttribute("style");
                width = members[i].getAttribute("width");
                align = members[i].getAttribute("align");
                this._templateOfColumExtension = this._templateOfColumExtension + "," + columnName + ":" + colNumber + ":" + style + ":" + align + ":" + width;
                ++colNumber;
                try {
                    ColumnExtensionValue columnVal = new ColumnExtensionValue();
                    columnVal.setClassOfColumnExtension((IColumnExtension)members[i].createExecutableExtension("class"));
                    columnVal.setInitialColumnPos(new Integer(pos));
                    this._listOfColumExtension.add(columnVal);
                }
                catch (CoreException e) {
                    System.err.println((Object)e);
                }
                ++i;
            }
        }
        return this._templateOfColumExtension;
    }

    public String getColumnsPreferencesKey() {
        this.setLevel(this.getLevel());
        if (this.getLevel() == 1) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "CovStatsPack60";
        }
        if (this.getLevel() == 2) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "CovStatsClass60";
        }
        if (this.getLevel() == 3) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "CovStatsMethod60";
        }
        return "";
    }

    private boolean isCallsMeaningful() {
        CoverageAnalysis covAnalysis = ((CoverageStatisticPage)this._page).getCovAnalysis();
        CoverageFolder root = covAnalysis.getRoot();
        if (root == null) {
            return true;
        }
        ArrayList traceObjects = root.getTraceObjects();
        Iterator i = traceObjects.iterator();
        while (i.hasNext()) {
            TRCMonitor monitor;
            TRCNode node;
            TRCAgentProxy agentProxy;
            Object o = i.next();
            if (!(o instanceof TRCAgentProxy ? !this.isCallsMeaningful(agentProxy = (TRCAgentProxy)o) : (o instanceof TRCNode ? !this.isCallsMeaningful(node = (TRCNode)o) : o instanceof TRCMonitor && !this.isCallsMeaningful(monitor = (TRCMonitor)o)))) continue;
            return false;
        }
        return true;
    }

    private boolean isCallsMeaningful(TRCMonitor monitor) {
        EList nodes = monitor.getNodes();
        Iterator j = nodes.iterator();
        while (j.hasNext()) {
            TRCNode node = (TRCNode)j.next();
            if (this.isCallsMeaningful(node)) continue;
            return false;
        }
        return true;
    }

    private boolean isCallsMeaningful(TRCNode node) {
        EList processProxies = node.getProcessProxies();
        Iterator j = processProxies.iterator();
        while (j.hasNext()) {
            TRCProcessProxy processProxy = (TRCProcessProxy)j.next();
            EList agentProxies = processProxy.getAgentProxies();
            Iterator k = agentProxies.iterator();
            while (k.hasNext()) {
                TRCAgentProxy agentProxy = (TRCAgentProxy)k.next();
                if (this.isCallsMeaningful(agentProxy)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isCallsMeaningful(TRCAgentProxy agentProxy) {
        EList configs = agentProxy.getConfigurations();
        Iterator j = configs.iterator();
        while (j.hasNext()) {
            TRCConfiguration config = (TRCConfiguration)j.next();
            EList options = config.getOptions();
            Iterator k = options.iterator();
            while (k.hasNext()) {
                TRCOption option = (TRCOption)k.next();
                if (!CALLS_NOT_COMPUTED.equals(option.getKey()) || !option.getValue().equalsIgnoreCase("true")) continue;
                return false;
            }
        }
        return true;
    }

    public IContentProvider getContentProvider() {
        return new CoverageStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new CoverageStatisticLabelProvider((StatisticView)this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new CoverageStatisticSorter();
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new CoverageStatisticFilter();
    }

    protected String getViewTypeStr() {
        return "viewoption.coverage";
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            EObject obj = ((Coverage)sel).getTraceObj();
            this.notifyViewSelectionChanged(this, obj);
        }
    }

    protected void expandFirstElement() {
        TableTree table = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] items = table.getItems();
        if (items.length != 0) {
            ((MultiLevelStatisticView.MultiLevelStatisticTreeViewer)this.getTableViewer()).expandItem(items[0]);
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)((MultiLevelStatisticViewer)this.getTraceViewerPage().getTraceViewer()).openSource());
    }

    public void setLevel(int i) {
        _level = i;
    }

    public int getLevel() {
        return _level;
    }

    protected Object getItemModelData(TableTreeItem item) {
        if (item.getData() != null) {
            return ((Coverage)item.getData()).getTraceObj();
        }
        return null;
    }

    protected TableTreeItem getItemsRoot(TableTree table) {
        if (table.getItemCount() > 0) {
            return table.getItems()[0];
        }
        return null;
    }

    public class CoverageStatisticFilter
    extends StatisticView.StatisticFilter {
        public CoverageStatisticFilter() {
            super(CoverageStatisticView.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            Coverage cov = (Coverage)element;
            boolean flag = true;
            String compareText = "";
            switch (CoverageStatisticView.this.getLevel()) {
                case 1: {
                    if (!(cov.getTraceObj() instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)cov.getTraceObj()).getName().equals("")) {
                        compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        break;
                    }
                    compareText = ((TRCPackage)cov.getTraceObj()).getName();
                    break;
                }
                case 2: {
                    if (!(cov.getTraceObj() instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)cov.getTraceObj()).getName();
                    break;
                }
                case 3: {
                    if (!(cov.getTraceObj() instanceof TRCMethod)) {
                        return true;
                    }
                    compareText = ((TRCMethod)cov.getTraceObj()).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class CoverageStatisticSorter
    extends MultiLevelStatisticView.MultiLevelStatisticSorter {
        public CoverageStatisticSorter() {
            super(CoverageStatisticView.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Coverage cov1 = (Coverage)e1;
            Coverage cov2 = (Coverage)e2;
            String name1 = null;
            String name2 = null;
            switch (this._pos) {
                case 0: {
                    if (cov1.getTraceObj() instanceof TRCPackage) {
                        name1 = ((TRCPackage)cov1.getTraceObj()).getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCPackage)cov1.getTraceObj()).getName();
                    } else if (cov1.getTraceObj() instanceof TRCClass) {
                        name1 = ((TRCClass)cov1.getTraceObj()).getName();
                    } else if (cov1.getTraceObj() instanceof TRCMethod) {
                        name1 = ((TRCMethod)cov1.getTraceObj()).getName();
                    }
                    if (cov2.getTraceObj() instanceof TRCPackage) {
                        name2 = ((TRCPackage)cov2.getTraceObj()).getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCPackage)cov2.getTraceObj()).getName();
                    } else if (cov2.getTraceObj() instanceof TRCClass) {
                        name2 = ((TRCClass)cov2.getTraceObj()).getName();
                    } else if (cov2.getTraceObj() instanceof TRCMethod) {
                        name2 = ((TRCMethod)cov2.getTraceObj()).getName();
                    }
                    return this._sortSequence * name1.compareToIgnoreCase(name2);
                }
                case 1: {
                    if (cov1.getTraceObj() instanceof TRCMethod && cov2.getTraceObj() instanceof TRCMethod) {
                        TRCMethod m1 = (TRCMethod)cov1.getTraceObj();
                        TRCMethod m2 = (TRCMethod)cov2.getTraceObj();
                        return this._sortSequence * m1.getDefiningClass().getName().compareToIgnoreCase(m2.getDefiningClass().getName());
                    }
                    return 0;
                }
                case 2: {
                    if (cov1.getTraceObj() instanceof TRCMethod && cov2.getTraceObj() instanceof TRCMethod && CoverageStatisticView.this.getLevel() == 3) {
                        TRCMethod m1 = (TRCMethod)cov1.getTraceObj();
                        TRCMethod m2 = (TRCMethod)cov2.getTraceObj();
                        name1 = m1.getDefiningClass().getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : m1.getDefiningClass().getPackage().getName();
                        name2 = m2.getDefiningClass().getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : m2.getDefiningClass().getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    if (cov1.getTraceObj() instanceof TRCClass && cov2.getTraceObj() instanceof TRCClass) {
                        name1 = ((TRCClass)cov1.getTraceObj()).getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCClass)cov1.getTraceObj()).getPackage().getName();
                        name2 = ((TRCClass)cov2.getTraceObj()).getPackage().getName().equals("") ? TraceUIPlugin.getString("DEFAULT_PACKAGE") : ((TRCClass)cov2.getTraceObj()).getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    return 0;
                }
                case 3: {
                    if (CoverageStatisticView.this._isCallsMeaningfull) {
                        return this._sortSequence * (cov1.getCalls() - cov2.getCalls());
                    }
                    return 0;
                }
                case 4: {
                    return this._sortSequence * (cov1.getMethodsMissed() - cov2.getMethodsMissed());
                }
                case 5: {
                    return this._sortSequence * (cov1.getMethodsHit() - cov2.getMethodsHit());
                }
                case 6: {
                    return this._sortSequence * (int)((cov1.getPercentage() - cov2.getPercentage()) * 10000.0);
                }
            }
            if (CoverageStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)CoverageStatisticView.this._listOfColumExtension.get(this._pos - CoverageStatisticView.this._numberOfColumns);
                return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
            }
            return 0;
        }
    }

    public class CoverageStatisticLabelProvider
    extends MultiLevelStatisticView.MultiLevelStatisticLabelProvider {
        public CoverageStatisticLabelProvider(StatisticView viewer) {
            super(CoverageStatisticView.this, viewer);
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            Coverage cov = (Coverage)obj;
            switch (pos) {
                case 1: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return TracePluginImages.getImage("class_col.gif");
                    }
                    return null;
                }
                case 2: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (CoverageStatisticView.this.getLevel() == 1 || CoverageStatisticView.this.getLevel() == 2) {
                            return null;
                        }
                        return TracePluginImages.getImage("package_obj_col.gif");
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return TracePluginImages.getImage("package_obj_col.gif");
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            Coverage cov = (Coverage)obj;
            switch (pos) {
                case 0: {
                    if (cov.getTraceObj() instanceof TRCPackage) {
                        if (((TRCPackage)cov.getTraceObj()).getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCPackage)cov.getTraceObj()).getName();
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return ((TRCClass)cov.getTraceObj()).getName();
                    }
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        TRCMethod m = (TRCMethod)cov.getTraceObj();
                        return m.getName() + m.getSignature();
                    }
                    return TraceUIPlugin.getString("ST_SUMMARY");
                }
                case 1: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return ((TRCMethod)cov.getTraceObj()).getDefiningClass().getName();
                    }
                    return "";
                }
                case 2: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (CoverageStatisticView.this.getLevel() == 1 || CoverageStatisticView.this.getLevel() == 2) {
                            return "";
                        }
                        if (((TRCMethod)cov.getTraceObj()).getDefiningClass().getPackage().getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCMethod)cov.getTraceObj()).getDefiningClass().getPackage().getName();
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        if (((TRCClass)cov.getTraceObj()).getPackage().getName().equals("")) {
                            return TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        }
                        return ((TRCClass)cov.getTraceObj()).getPackage().getName();
                    }
                    return "";
                }
                case 3: {
                    if (CoverageStatisticView.this._isCallsMeaningfull) {
                        return String.valueOf(cov.getCalls());
                    }
                    return "";
                }
                case 4: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (cov.getCalls() == 0) {
                            return TraceUIPlugin.getString("ST_MISSED");
                        }
                        return "";
                    }
                    return String.valueOf(cov.getMethodsMissed());
                }
                case 5: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        if (cov.getCalls() != 0) {
                            return TraceUIPlugin.getString("ST_HIT");
                        }
                        return "";
                    }
                    return String.valueOf(cov.getMethodsHit());
                }
                case 6: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return "";
                    }
                    return TString.formatAsPercentage((double)cov.getPercentage());
                }
            }
            if (CoverageStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)CoverageStatisticView.this._listOfColumExtension.get(pos - CoverageStatisticView.this._numberOfColumns);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }
    }

    public class CoverageStatisticContentProvider
    extends MultiLevelStatisticView.MultiLevelStatisticContentProvider {
        public CoverageStatisticContentProvider() {
            super(CoverageStatisticView.this);
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            CoverageStatisticView.this._isCallsMeaningfull = CoverageStatisticView.this.isCallsMeaningful();
        }

        public Object[] getChildren(Object element) {
            ArrayList childs = ((Coverage)element).getChilds();
            if (childs == null) {
                return null;
            }
            return childs.toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Coverage> tmpList = new ArrayList<Coverage>();
            tmpList.clear();
            CoverageAnalysis covAnalysis = ((CoverageStatisticPage)CoverageStatisticView.this._page).getCovAnalysis();
            if (covAnalysis.getRoot() != null) {
                switch (CoverageStatisticView.this.getLevel()) {
                    case 1: {
                        tmpList.add(covAnalysis.getRoot());
                        return tmpList.toArray();
                    }
                    case 2: {
                        tmpList.add(covAnalysis.getClassLevel());
                        return tmpList.toArray();
                    }
                    case 3: {
                        tmpList.add(covAnalysis.getMethodLevel());
                        return tmpList.toArray();
                    }
                }
                return tmpList.toArray();
            }
            return tmpList.toArray();
        }
    }
}

