/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticPage;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticViewer;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public abstract class MultiLevelStatisticView
extends StatisticView {
    public static final int PACKAGE_LEVEL = 1;
    public static final int CLASS_LEVEL = 2;
    public static final int DEFAULT_LEVEL = 1;
    public static String PREFERENCE_KEY_PREFIX = "org.eclipse.hyades.trace.views.multilevel.";

    public MultiLevelStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = this.getFilterInstance();
    }

    public abstract boolean isEmpty();

    public abstract String getColumnsPreferencesKey();

    protected abstract String getDefaultColumnsTemplatePackageLevel();

    protected abstract String getDefaultColumnsTemplateClassLevel();

    protected abstract StatisticView.StatisticFilter getFilterInstance();

    public abstract IContentProvider getContentProvider();

    public abstract LabelProvider getTableLabelProvider();

    protected abstract StatisticView.StatisticSorter getViewerSorterInstance();

    public abstract int getLevel();

    public abstract void setLevel(int var1);

    protected abstract String getViewTypeStr();

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    protected TableTreeViewer getTableTreeViewer(TableTree table) {
        return new MultiLevelStatisticTreeViewer(table);
    }

    protected void openSourceForSelection(ISelection selection) {
        MultiLevelStatisticViewer viewer;
        TraceViewerPage page;
        if (selection != null && (page = this.getTraceViewerPage()) != null && (viewer = (MultiLevelStatisticViewer)page.getTraceViewer()) != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    viewer.openSource().run();
                }
            });
        }
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected boolean canOpenSourceOnThisObject() {
        ITraceSelection _model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (_model.size() == 0 || _model.getFirstElement() == null) {
            return false;
        }
        Object firstElement = _model.getFirstElement();
        if (firstElement instanceof TRCClass && ((TRCClass)firstElement).getSourceInfo() != null && ((TRCClass)firstElement).getSourceInfo().getLocation().length() > 0) {
            return true;
        }
        return firstElement instanceof TRCMethod;
    }

    public String getDefaultColumnsTemplate() {
        String columns = null;
        if (this.getLevel() == 0 || this.getLevel() == 1) {
            columns = this.getDefaultColumnsTemplatePackageLevel();
        } else if (this.getLevel() == 2) {
            columns = this.getDefaultColumnsTemplateClassLevel();
        }
        return columns;
    }

    protected void handleSelectionEvent() {
        Object sel;
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0 && (sel = model.getFirstElement()) != null) {
            this.select(sel);
        }
    }

    private void select(Object obj) {
        TRCClass cls = null;
        TRCPackage pack = null;
        TRCMethod meth = null;
        String parentClsName = null;
        TableTree table = (TableTree)this.getTableViewer().getControl();
        TableTreeItem[] items = table.getItems();
        if (items.length != 0) {
            if (obj instanceof TRCPackage) {
                pack = (TRCPackage)obj;
            } else if (obj instanceof TRCClass) {
                cls = (TRCClass)obj;
                pack = cls.getPackage();
            } else if (obj instanceof TRCMethod) {
                meth = (TRCMethod)obj;
                cls = meth.getDefiningClass();
                pack = cls.getPackage();
            }
            this.searchInLevel(table, this.getItemsRoot(table), pack, cls, parentClsName, meth);
        }
    }

    protected TableTreeItem getItemsRoot(TableTree table) {
        return null;
    }

    protected void searchInPackageLevel(TableTree table, TableTreeItem item, TRCPackage pack, TRCClass cls, String parentClsName, TRCMethod meth) {
        TableTreeItem pacItem = null;
        TableTreeItem[] pacItems = null;
        pacItems = item != null ? item.getItems() : table.getItems();
        pacItem = this.searchItem(pacItems, pack);
        if (pacItem != null) {
            if (cls == null) {
                table.setSelection(new TableTreeItem[]{pacItem});
                return;
            }
            ((MultiLevelStatisticTreeViewer)this.getTableViewer()).expandItem(pacItem);
            this.searchInClassLevel(table, pacItem, cls, parentClsName, meth);
            return;
        }
        if (item != null) {
            table.setSelection(new TableTreeItem[]{item});
            return;
        }
        table.deselectAll();
    }

    protected void searchInClassLevel(TableTree table, TableTreeItem item, TRCClass cls, String parentClsName, TRCMethod meth) {
        TableTreeItem[] classItems = null;
        TableTreeItem classItemBis = null;
        classItems = item != null ? item.getItems() : table.getItems();
        classItemBis = this.searchItem(classItems, cls);
        if (classItemBis != null) {
            if (meth == null) {
                table.setSelection(new TableTreeItem[]{classItemBis});
                return;
            }
            ((MultiLevelStatisticTreeViewer)this.getTableViewer()).expandItem(classItemBis);
            this.searchInMethodLevel(table, classItemBis, meth);
            return;
        }
        if (item != null) {
            table.setSelection(new TableTreeItem[]{item});
            return;
        }
        table.deselectAll();
    }

    protected void searchInMethodLevel(TableTree table, TableTreeItem item, TRCMethod meth) {
        TableTreeItem[] methodItems = null;
        methodItems = item != null ? item.getItems() : table.getItems();
        TableTreeItem methodItem = this.searchItem(methodItems, meth);
        if (methodItem != null) {
            table.setSelection(new TableTreeItem[]{methodItem});
            return;
        }
        if (item != null) {
            table.setSelection(new TableTreeItem[]{item});
            return;
        }
        table.deselectAll();
    }

    protected void searchInLevel(TableTree table, TableTreeItem item, TRCPackage pack, TRCClass cls, String parentClsName, TRCMethod meth) {
        switch (this.getLevel()) {
            case 1: {
                this.searchInPackageLevel(table, item, pack, cls, parentClsName, meth);
                break;
            }
            case 2: {
                if (cls == null) break;
                this.searchInClassLevel(table, item, cls, parentClsName, meth);
            }
        }
    }

    protected Object getItemModelData(TableTreeItem item) {
        return item.getData();
    }

    protected TableTreeItem searchItem(TableTreeItem[] items, Object obj) {
        TableTreeItem item = null;
        int j = 0;
        while (j < items.length) {
            item = items[j];
            if (item.getData() != null && obj == this.getItemModelData(item)) {
                return item;
            }
            ++j;
        }
        return null;
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        this.resetChooseColumnsAction();
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public void redrawTable() {
        this.getTable().setRedraw(false);
        ArrayList list = ColumnData.createColumnData(this.getColumnsPreferencesKey(), this.getDefaultColumnsTemplate());
        this.resetColumns(list);
        this._currentColumns = list;
        this.getTable().setRedraw(true);
        this.refresh();
    }

    public void widgetSelected(SelectionEvent arg0) {
        super.widgetSelected(arg0);
        if (arg0.widget instanceof TableColumn) {
            this.expandFirstElement();
            this.handleSelectionEvent();
        }
    }

    protected void filterNames() {
        super.filterNames();
        this.expandFirstElement();
        this.handleSelectionEvent();
    }

    protected void resetColumns(ArrayList list) {
        super.resetColumns(list);
        this.expandFirstElement();
        this.handleSelectionEvent();
    }

    protected void resetChooseColumnsAction() {
        this._chooseColumnAction = null;
    }

    public void dispose() {
        super.dispose();
    }

    public void updateButtons() {
        ((MultiLevelStatisticPage)this.getTraceViewerPage()).updateButtons(this.getLevel());
        ((MultiLevelStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(this.canOpenSourceOnThisObject());
    }

    class MultiLevelStatisticTreeViewer
    extends TableTreeViewer {
        public MultiLevelStatisticTreeViewer(Composite parent) {
            super(parent);
        }

        public MultiLevelStatisticTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public abstract class MultiLevelStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public MultiLevelStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public abstract String getColumnText(Object var1, int var2);
    }

    public abstract class MultiLevelStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public abstract Object[] getElements(Object var1);

        public Object[] getChildren(Object element) {
            return new ArrayList().toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }
    }

    public abstract class MultiLevelStatisticSorter
    extends StatisticView.StatisticSorter {
        public MultiLevelStatisticSorter() {
            super(MultiLevelStatisticView.this);
        }

        public abstract int compare(Viewer var1, Object var2, Object var3);
    }
}

