/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;

public class CoverageUtil {
    private static String getSourceSig(TRCSourceInfo e) {
        return e != null ? e.getLocation() + ":" : "";
    }

    public static String getFullSig(TRCMethod e) {
        return CoverageUtil.getSourceSig(e.getSourceInfo()) + e.getLineNo() + ":" + CoverageUtil.getSig(e.getDefiningClass()) + "." + e.getName() + e.getSignature();
    }

    public static String getFullSig(TRCClass e) {
        return CoverageUtil.getSourceSig(e.getSourceInfo()) + e.getLineNo() + ":" + CoverageUtil.getSig(e);
    }

    public static String getFullSig(TRCPackage e) {
        return e.getName();
    }

    private static String getSig(TRCClass e) {
        return (e.getPackage().getName() == null ? "" : e.getPackage().getName() + ".") + e.getName();
    }

    public static boolean isFiltered(TRCPackage pac) {
        if (pac.getClasses() == null || pac.getClasses().size() == 0) {
            return true;
        }
        Object[] conflist = pac.getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
        return CoverageUtil.filtersMatch(conflist, pac.getName());
    }

    public static boolean isFiltered(TRCClass cl) {
        return cl.getMethods() == null || cl.getMethods().size() == 0;
    }

    private static boolean filtersMatch(Object[] conflist, String name) {
        int idx = 0;
        while (idx < conflist.length) {
            TRCConfiguration c = (TRCConfiguration)conflist[idx];
            if (c.isActive()) {
                Object[] filtlist = c.getFilters().toArray();
                int k = 0;
                while (k < filtlist.length) {
                    TRCFilter f = (TRCFilter)filtlist[k];
                    String pattern = f.getPattern();
                    if (pattern.indexOf("*") != -1) {
                        pattern = pattern.substring(0, pattern.indexOf("*"));
                    }
                    if (name.startsWith(pattern)) {
                        return !f.getMode().equals("INCLUDE");
                    }
                    ++k;
                }
                return false;
            }
            ++idx;
        }
        return false;
    }
}

