/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.extractors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.Extractor;

public class SimpleExtractor
extends Extractor {
    private static final int MESSAGE_STRING_ARRAY_SIZE = 8;
    protected StringArray inputs;
    protected String localLineSeparator = System.getProperty("line.separator");

    public void update() throws AdapterInvalidConfig {
        super.update();
        this.inputs = new StringArray();
    }

    public MessageString[] processStrings(String[] strings) {
        MessageString[] finalResult = null;
        if (strings != null) {
            int i = 0;
            while (i < strings.length) {
                if (strings[i] != null) {
                    this.inputs.enqueueString(strings[i]);
                }
                strings[i] = null;
                ++i;
            }
        }
        if (this.inputs == null || this.inputs.lastAddedString == this.inputs.lastRemovedString) {
            return null;
        }
        finalResult = !this.getContainsLineBreaks() ? this.processSeparateLines() : this.processMultipleLines();
        return finalResult;
    }

    private MessageString[] processSeparateLines() {
        return this.processMultipleLines();
    }

    private MessageString[] processMultipleLines() {
        Object[] entries;
        ArrayList results = new ArrayList();
        String searchString = this.buildString(this.inputs, this.inputs.lastRemovedString + 1, 0, this.inputs.lastAddedString, this.inputs.contents[this.inputs.lastAddedString].length() - 1);
        StringPosition start = new StringPosition();
        StringPosition end = new StringPosition();
        searchString = this.processSearchString(results, searchString, start, end);
        String temp = null;
        if (start.isValid()) {
            if (!end.isValid() && !this.flushingMode) {
                temp = searchString.substring(start.getStartPosition(), searchString.length());
            }
        } else {
            temp = searchString;
        }
        this.inputs.flush();
        if (temp != null) {
            this.inputs.enqueueString(temp);
        }
        if ((entries = results.toArray()).length > 0) {
            MessageString[] messages = new MessageString[entries.length];
            int i = 0;
            while (i < entries.length) {
                messages[i] = (MessageString)entries[i];
                ++i;
            }
            return messages;
        }
        return null;
    }

    private String buildString(StringArray array, int arrayStartIndex, int startPosition, int arrayStopIndex, int stopPosition) {
        StringBuffer result = new StringBuffer();
        int i = arrayStartIndex;
        while (i <= arrayStopIndex) {
            int copyStart = i == arrayStartIndex ? startPosition : 0;
            int copyEnd = i == arrayStopIndex ? stopPosition + 1 : array.contents[i].length();
            if (i != arrayStartIndex) {
                if (this.getLineBreakSymbol() != null && !this.getLineBreakSymbol().equals("")) {
                    result.append(this.getLineBreakSymbol());
                } else {
                    result.append(this.localLineSeparator);
                }
            }
            result.append(array.contents[i].substring(copyStart, copyEnd));
            ++i;
        }
        return result.toString();
    }

    private String processSearchString(List results, String searchString, StringPosition start, StringPosition end) {
        int startOffset = 0;
        int endOffset = searchString.length() - 1;
        while (true) {
            if (this.getStartPattern() != null && !this.getStartPattern().equals("")) {
                this.search(start, this.getStartPattern(), searchString, startOffset);
                if (!start.isValid()) {
                    return searchString;
                }
            } else {
                start.setStartPosition(startOffset);
                start.setEndPosition(startOffset);
                start.setValid(true);
            }
            if (start.isValid() && start.getEndPosition() < endOffset) {
                if (this.getEndPattern() == null || this.getEndPattern().equals("")) {
                    this.search(end, this.getStartPattern(), searchString, start.getEndPosition() + 1);
                } else {
                    this.search(end, this.getEndPattern(), searchString, start.getEndPosition() + 1);
                }
            }
            if (!end.isValid()) {
                if (this.flushingMode) {
                    end.setStartPosition(endOffset);
                    end.setEndPosition(endOffset);
                    results.add(this.adjustMessage(searchString, start, end));
                    searchString = null;
                }
                return searchString;
            }
            if (!start.isValid() || !end.isValid()) continue;
            results.add(this.adjustMessage(searchString, start, end));
            startOffset = this.getEndPattern() == null || this.getEndPattern().equals("") ? end.getStartPosition() : end.getEndPosition() + 1;
            if (startOffset > endOffset) {
                return null;
            }
            searchString = searchString.substring(startOffset, searchString.length());
            startOffset = 0;
            endOffset = searchString.length() - 1;
            start.setValid(false);
            end.setValid(false);
        }
    }

    protected MessageString adjustMessage(String searchString, StringPosition startPosition, StringPosition endPosition) {
        int endOffset = searchString.length() - 1;
        int adjustedStart = this.getIncludeStartPattern() ? startPosition.getStartPosition() : startPosition.getEndPosition() + 1;
        int adjustedEnd = this.getIncludeEndPattern() ? (endPosition.getStartPosition() > endOffset ? endOffset + 1 : endPosition.getEndPosition() + 1) : (endPosition.getStartPosition() == endOffset ? endPosition.getStartPosition() + 1 : endPosition.getStartPosition());
        MessageString result = new MessageString();
        result.setValue(searchString.substring(adjustedStart, adjustedEnd));
        return result;
    }

    protected void search(StringPosition position, String pattern, String searchString, int startOffset) {
        int foundPosition = -1;
        if (pattern != null) {
            foundPosition = searchString.indexOf(pattern, startOffset);
        }
        if (foundPosition > -1 && foundPosition < searchString.length()) {
            position.setStartPosition(foundPosition);
            if (pattern.length() > 1) {
                position.setEndPosition(foundPosition + pattern.length() - 1);
            } else {
                position.setEndPosition(foundPosition + pattern.length());
            }
            position.setValid(true);
        }
    }

    class StringPosition
    implements Cloneable {
        private int startPosition;
        private int endPosition;
        private boolean valid = false;

        StringPosition() {
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(int pos) {
            this.startPosition = pos;
        }

        int getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(int pos) {
            this.endPosition = pos;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        protected Object clone() throws CloneNotSupportedException {
            StringPosition rhs = new StringPosition();
            rhs.startPosition = this.startPosition;
            rhs.endPosition = this.endPosition;
            rhs.valid = this.valid;
            return rhs;
        }
    }

    class StringArray {
        public String[] contents = new String[8];
        public int offset = 0;
        public int lastAddedString = -1;
        public int lastRemovedString = -1;

        private void increaseStringArraySize() {
            String[] tempArray = new String[this.contents.length * 2];
            System.arraycopy(this.contents, 0, tempArray, 0, this.contents.length);
            this.contents = tempArray;
        }

        public void enqueueString(String newString) {
            if (this.offset + 1 >= this.contents.length) {
                this.increaseStringArraySize();
            }
            this.contents[this.offset++] = newString;
            this.lastAddedString = this.offset - 1;
        }

        public void flush() {
            int i = 0;
            while (i < this.contents.length) {
                this.contents[i] = null;
                ++i;
            }
            this.offset = 0;
            this.lastRemovedString = -1;
            this.lastAddedString = -1;
        }
    }
}

