/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.trace.TRCObjectEntry;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.VirtualObjectInfo;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;

public class TraceXMLFragmentLoader
extends IgnoredXMLFragmentLoader {
    protected static final String NAME = "name";
    protected static final String OBJ_ID_REF = "objIdRef";
    protected static final String METHOD_ID_REF = "methodIdRef";
    protected static final String CLASS_ID_REF = "classIdRef";
    protected static final String THREAD_ID_REF = "threadIdRef";
    protected static final String TIME = "time";
    protected static final String CLASS_CLASS1 = "java/lang/Class";
    protected static final String CLASS_CLASS2 = "java.lang.Class";
    protected static final String UNKNOWN = "unknown";
    protected TRCClass theClass;
    protected TRCHeapDump theHeapDump;
    protected TRCMethod theMethod;
    protected TRCObject theObject;
    protected TRCProcess theProcess;
    protected TRCThread theThread;
    protected VirtualObjectInfo virtualObject;
    protected boolean loadToModel;
    protected double time = 0.0;
    protected long classIdRef;
    protected int deltaSize = 0;
    protected int methodIdRef;
    protected int threadIdRef = 0;
    protected long objIdRef;
    protected TRCClass aClass;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCClassImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$TRCObjectEntry;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 3560141: {
                this.time = Double.parseDouble(value);
                break;
            }
            case 1910215054: {
                this.threadIdRef = Integer.parseInt(value);
                break;
            }
            case -311104800: {
                this.classIdRef = Integer.parseInt(value);
                break;
            }
            case -947782377: {
                this.methodIdRef = Integer.parseInt(value);
                break;
            }
            case 64634561: {
                this.objIdRef = Long.parseLong(value);
                break;
            }
        }
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.threadIdRef = 0;
        this.classIdRef = 0L;
        this.methodIdRef = 0;
        this.objIdRef = 0L;
        this.time = 0.0;
        this.theProcess = null;
        this.theThread = null;
        this.theClass = null;
        this.theMethod = null;
        this.theObject = null;
        this.virtualObject = null;
    }

    protected TRCClass getClassByIdRef(TRCThread thread, Class theObjectClass, int isArray) {
        int h;
        String name;
        TRCClass targetClass = null;
        TRCObject anObject = null;
        if (isArray > 0) {
            Object key = LoadersUtils.getLookUpKey((long)(-this.classIdRef));
            this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl, key);
            if (this.theClass != null) {
                return this.theClass;
            }
            key = LoadersUtils.getLookUpKey((long)this.classIdRef);
            targetClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCClassImpl, key);
            if (targetClass == null) {
                targetClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCArrayClassImpl, key);
            }
        } else {
            Object key = LoadersUtils.getLookUpKey((long)this.classIdRef);
            this.theClass = (TRCClass)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCClassImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCClassImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCClassImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCClassImpl, key);
            if (this.theClass != null) {
                return this.theClass;
            }
        }
        if (isArray > 0) {
            this.theClass = TraceFactory.eINSTANCE.createTRCArrayClass();
            this.theClass.setId(-this.classIdRef);
            ((TRCArrayClass)this.theClass).setArrayType(TRCPrimitiveType.get(isArray));
        } else {
            this.theClass = TraceFactory.eINSTANCE.createTRCClass();
            this.theClass.setId(this.classIdRef);
        }
        if (targetClass != null) {
            this.theClass.setName("[" + targetClass.getName());
            this.theClass.setLoadTime(this.createDeltaTime());
            this.theClass.setLoadedBy(thread);
            this.theClass.setPackage(targetClass.getPackage());
            anObject = this.getClassObjectByIdRef(-this.classIdRef, theObjectClass);
            this.theClass.getClassObjects().add((Object)anObject);
            anObject.setSize(this.theClass.getSize());
            TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, anObject);
            return this.theClass;
        }
        String sourceName = name = UNKNOWN + this.classIdRef;
        this.theClass.setName(TraceUtils.className(name));
        this.theClass.setLoadTime(this.createDeltaTime());
        TraceUtils.addClassToPackage(this.context, this.theClass, name, this.theProcess);
        TraceUtils.setSourceInfo(this.context, this.theProcess, this.theClass, sourceName);
        if (this.theProcess.getClassClass() == null && ((h = LoadersUtils.getHashCode((String)name)) == 1995981828 || h == -530663260)) {
            this.theProcess.setClassClass(this.theClass);
        }
        anObject = this.getClassObjectByIdRef(-this.classIdRef, theObjectClass);
        anObject.setSize(this.theClass.getSize());
        this.theClass.getClassObjects().add((Object)anObject);
        this.theClass.setLoadedBy(thread);
        TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, anObject);
        return this.theClass;
    }

    protected TRCObject getClassObjectByIdRef(long id, Class theObjectClass) {
        this.aClass = this.theProcess.getClassClass();
        if (this.aClass == null) {
            TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, null);
            this.aClass = this.theProcess.getClassClass();
        }
        return this.createObjectAndClassObject(id, theObjectClass);
    }

    protected TRCMethod getMethodByIdRef(TRCClass theClass) {
        Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? (class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCMethodWithLLDataImpl) : (class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCMethodImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCMethodImpl);
        Class clazz2 = clazz;
        TRCMethod method = (TRCMethod)LookupServiceExtensions.getInstance().locate(this.context, clazz2, LoadersUtils.getLookUpKey((int)this.methodIdRef));
        if (method == null) {
            method = this.createTRCMethod(theClass);
            method.setId(this.methodIdRef);
            method.setName(UNKNOWN + this.methodIdRef);
            method.setSignature("()");
            method.setDefiningClass(theClass);
        }
        return method;
    }

    protected TRCMethod createTRCMethod(TRCClass theClass2) {
        TRCMethod method = null;
        method = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? TraceFactory.eINSTANCE.createTRCMethodWithLLData() : TraceFactory.eINSTANCE.createTRCMethod();
        return method;
    }

    protected TRCObject getObjectByIdRef(long id, Class theObjectClass) {
        this.aClass = this.theClass;
        if (this.aClass == null) {
            this.theProcess = this.getProcess();
            this.aClass = this.theProcess.getClassClass();
            if (this.aClass == null) {
                TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, null);
                this.aClass = this.theProcess.getClassClass();
            }
        }
        return this.createObjectAndClassObject(id, theObjectClass);
    }

    protected TRCProcess getProcess() {
        TRCProcess p;
        if (this.context.getAgent() == null) {
            LoadersUtils.createAgent((HierarchyContext)this.context);
        }
        if ((p = TraceUtils.getProcess(this.context.getAgent())) == null) {
            p = TraceFactory.eINSTANCE.createTRCProcess();
            p.setId(this.context.getProcessProxy().getRuntimeId());
            p.setPid(this.context.getProcessProxy().getPid());
            p.setAgent(this.context.getAgent());
            p.setStartTime(this.createDeltaTime());
        }
        return p;
    }

    protected TRCThread getThreadByIdRef(TRCProcess p) {
        TRCThread thread = (TRCThread)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCThreadImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCThreadImpl, LoadersUtils.getLookUpKey((int)this.threadIdRef));
        if (thread == null) {
            thread = TraceFactory.eINSTANCE.createTRCThread();
            thread.setId(this.threadIdRef);
            thread.setName(UNKNOWN + this.threadIdRef);
            thread.setStartTime(this.createDeltaTime());
            thread.setProcess(p);
        }
        return thread;
    }

    protected double createDeltaTime() {
        return this.time - this.getZeroTime();
    }

    protected TRCObject createObject(long id, Class theObjectClass) {
        if (theObjectClass == (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl)) {
            return this.createTRCHeapObject(id);
        }
        if (theObjectClass == (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl)) {
            return this.createTRCFullHeapObject(id);
        }
        if (theObjectClass == (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl)) {
            return this.createTRCFullTraceObject(id);
        }
        return this.createTRCObject(id);
    }

    protected TRCObject createObject(long id, Class theObjectClass, TRCObjectEntry objectEntry) {
        if (theObjectClass == (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl)) {
            return this.createTRCHeapObject(id, objectEntry);
        }
        if (theObjectClass == (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullHeapObjectImpl)) {
            return this.createTRCHeapObject(id, objectEntry);
        }
        if (theObjectClass == (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl)) {
            return this.createTRCFullTraceObject(id, objectEntry);
        }
        return this.createTRCObject(id);
    }

    protected TRCObject createTRCFullTraceObject(long oId) {
        TRCFullTraceObject object = TraceFactory.eINSTANCE.createTRCFullTraceObject();
        object.setId(oId);
        object.setCreateTime(this.createDeltaTime());
        object.setThread(this.theClass.getLoadedBy());
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCFullTraceObject(long oId, TRCObjectEntry objectEntry) {
        TRCFullTraceObject object = TraceFactory.eINSTANCE.createTRCFullTraceObject();
        object.setId(oId);
        TRCHeapObject o = (TRCHeapObject)objectEntry.get(class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCHeapObjectImpl);
        if (o != null) {
            object.setIsA(o.getIsA());
        } else {
            object.setIsA(this.theClass);
        }
        object.setCreateTime(this.createDeltaTime());
        object.setThread(this.theClass.getLoadedBy());
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCHeapObject(long oId) {
        TRCHeapObject object = TraceFactory.eINSTANCE.createTRCHeapObject();
        object.setId(oId);
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCFullHeapObject(long oId) {
        TRCFullHeapObject object = TraceFactory.eINSTANCE.createTRCFullHeapObject();
        object.setId(oId);
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCHeapObject(long oId, TRCObjectEntry objectEntry) {
        TRCHeapObject object = TraceFactory.eINSTANCE.createTRCHeapObject();
        object.setId(oId);
        TRCFullTraceObject o = (TRCFullTraceObject)objectEntry.get(class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl);
        if (o != null) {
            object.setIsA(o.getIsA());
        } else {
            object.setIsA(this.theClass);
        }
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCFullHeapObject(long oId, TRCObjectEntry objectEntry) {
        TRCFullHeapObject object = TraceFactory.eINSTANCE.createTRCFullHeapObject();
        object.setId(oId);
        TRCFullTraceObject o = (TRCFullTraceObject)objectEntry.get(class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl = TraceXMLFragmentLoader.class$("org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCFullTraceObjectImpl);
        if (o != null) {
            object.setIsA(o.getIsA());
        } else {
            object.setIsA(this.theClass);
        }
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected TRCObject createTRCObject(long oId) {
        TRCObject object = TraceFactory.eINSTANCE.createTRCObject();
        object.setId(oId);
        object.setIsA(this.aClass);
        object.setProcess(this.getTRCObjectProcess());
        return object;
    }

    protected void dispatchProcessMode(int step) {
        switch (this.context.getCollectionMode().getValue()) {
            case 0: {
                this.processHS(step);
                break;
            }
            case 1: {
                this.processHF(step);
                break;
            }
            case 2: {
                this.processHF_EF(step);
                break;
            }
            case 3: {
                this.processHS_ES(step);
                break;
            }
            case 5: {
                this.processENI(step);
                break;
            }
            case 6: {
                this.processEF(step);
                break;
            }
            case 7: {
                this.processHF_ES(step);
                break;
            }
            case 4: {
                this.processES(step);
                break;
            }
            default: {
                this.dynamicProcess(this, step);
            }
        }
    }

    protected void dynamicProcess(TraceXMLFragmentLoader loader, int step) {
    }

    protected void processEF(int step) {
    }

    protected void processENI(int step) {
        this.processEF(step);
    }

    protected void processES(int step) {
    }

    protected void processHF(int step) {
    }

    protected void processHF_EF(int step) {
        this.processHF(step);
        this.processEF(step);
    }

    protected void processHF_ES(int step) {
        this.processHF(step);
        this.processES(step);
    }

    protected void processHS(int step) {
    }

    protected void processHS_ES(int step) {
        this.processHS(step);
        this.processES(step);
    }

    protected void updateVirtualObject(long oId, int size) {
        this.virtualObject = (VirtualObjectInfo)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo == null ? (class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo = TraceXMLFragmentLoader.class$("org.eclipse.hyades.loaders.trace.VirtualObjectInfo")) : class$org$eclipse$hyades$loaders$trace$VirtualObjectInfo, LoadersUtils.getLookUpKey((long)oId));
        if (this.virtualObject == null) {
            this.virtualObject = new VirtualObjectInfo();
            LoadersUtils.registerGenericLookUpEntry((HierarchyContext)this.context, (Object)LoadersUtils.getLookUpKey((long)oId), (Object)this.virtualObject);
        }
        this.virtualObject.myClass = this.theClass;
        this.virtualObject.myThread = this.theThread;
        this.virtualObject.createTime = this.createDeltaTime();
        this.virtualObject.size = size;
    }

    protected TRCProcess getTRCObjectProcess() {
        return this.getProcess();
    }

    protected double getZeroTime() {
        return this.getProcess().getAgent().getStartTime();
    }

    protected TRCObject createObjectAndClassObject(long id, Class theObjectClass) {
        Object oKey = LoadersUtils.getLookUpKey((long)id);
        TRCObjectEntry objectEntry = (TRCObjectEntry)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$loaders$trace$TRCObjectEntry == null ? (class$org$eclipse$hyades$loaders$trace$TRCObjectEntry = TraceXMLFragmentLoader.class$("org.eclipse.hyades.loaders.trace.TRCObjectEntry")) : class$org$eclipse$hyades$loaders$trace$TRCObjectEntry, oKey);
        TRCObject object = null;
        if (objectEntry != null) {
            object = objectEntry.get(theObjectClass);
            if (object == null) {
                object = this.createObject(id, theObjectClass, objectEntry);
                objectEntry.put(object.getClass(), object);
            }
        } else {
            object = this.createObject(id, theObjectClass);
        }
        return object;
    }

    protected TRCObject getClassObject(TRCClass class1, Class class2) {
        Iterator iter = class1.getClassObjects().iterator();
        while (iter.hasNext()) {
            TRCObject element = (TRCObject)iter.next();
            if (element.getClass() != class2) continue;
            return element;
        }
        TRCObject aObject = this.getClassObjectByIdRef(-this.classIdRef, class2);
        aObject.setSize(class1.getSize());
        this.theClass.getClassObjects().add((Object)aObject);
        TraceUtils.addClassObjectToClassClass(this.context, this.theProcess, aObject);
        return aObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

