/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.impl.AbstractTRCProcessImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

public class TRCProcessImpl
extends AbstractTRCProcessImpl
implements TRCProcess {
    private TRCProcessSnapshot _currentSnapshot;
    private TRCProcessSnapshot _previousSnapshot;
    protected static final int PID_EDEFAULT = 0;
    protected int pid = 0;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected static final double START_TIME_EDEFAULT = 0.0;
    protected double startTime = 0.0;
    protected static final double STOP_TIME_EDEFAULT = 0.0;
    protected double stopTime = 0.0;
    protected static final double LAST_EVENT_TIME_EDEFAULT = 0.0;
    protected double lastEventTime = 0.0;
    protected static final double INIT_FINISHED_TIME_EDEFAULT = 0.0;
    protected double initFinishedTime = 0.0;
    protected static final double BASE_TIME_EDEFAULT = 0.0;
    protected double baseTime = 0.0;
    protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;
    protected double cumulativeTime = 0.0;
    protected static final int CALLS_EDEFAULT = 0;
    protected int calls = 0;
    protected static final int INHERITED_CALLS_EDEFAULT = 0;
    protected int inheritedCalls = 0;
    protected static final double INHERITED_BASE_TIME_EDEFAULT = 0.0;
    protected double inheritedBaseTime = 0.0;
    protected static final double INHERITED_CUMULATIVE_TIME_EDEFAULT = 0.0;
    protected double inheritedCumulativeTime = 0.0;
    protected static final int TOTAL_SIZE_EDEFAULT = 0;
    protected int totalSize = 0;
    protected static final int TOTAL_INSTANCES_EDEFAULT = 0;
    protected int totalInstances = 0;
    protected static final int COLLECTED_SIZE_EDEFAULT = 0;
    protected int collectedSize = 0;
    protected static final int COLLECTED_INSTANCES_EDEFAULT = 0;
    protected int collectedInstances = 0;
    protected static final short REFERENCE_POINTER_SIZE_EDEFAULT = 4;
    protected short referencePointerSize = (short)4;
    protected EList threadStates = null;
    protected static final double TOTAL_CPU_TIME_EDEFAULT = 0.0;
    protected double totalCpuTime = 0.0;
    protected static final double CPU_SAMPLE_RESOLUTION_EDEFAULT = 0.0;
    protected double cpuSampleResolution = 0.0;
    protected EList threads = null;
    protected EList packages = null;
    protected TRCClass classClass = null;
    protected EList collectionBoundaryPoints = null;
    protected EList classLoaders = null;
    protected EList sourceInfos = null;
    protected EList objects = null;
    protected EList heapDumps = null;
    protected EList invocations = null;
    protected TRCInputOutputContainer inputOutputContainer = null;
    protected EMap methodLockAccessEntries = null;
    protected EMap allocationSitesEntries = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCThread;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCPackage;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCCollectionBoundary;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCClassLoader;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCSourceInfo;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCObject;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCHeapDump;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCMethodInvocation;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$TRCInputOutputContainer;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCMthdLckAccEntryImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$trace$impl$TRCObjectAllocationSitesEntryImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$TRCAgent;

    public int computeDelta(IDelta delta) {
        TRCProcessSnapshot delta1 = (TRCProcessSnapshot)delta;
        if (this._currentSnapshot == null || this._previousSnapshot == null) {
            delta1.baseTime = 0.0;
            delta1.calls = 0;
            delta1.collectedInstances = 0;
            delta1.collectedSize = 0;
            delta1.cumulativeTime = 0.0;
            delta1.inheritedBaseTime = 0.0;
            delta1.inheritedCalls = 0;
            delta1.inheritedCumulativeTime = 0.0;
            delta1.totalInstances = 0;
            delta1.totalSize = 0;
            return -1;
        }
        delta1.baseTime = this._currentSnapshot.baseTime - this._previousSnapshot.baseTime;
        delta1.calls = this._currentSnapshot.calls - this._previousSnapshot.calls;
        delta1.collectedInstances = this._currentSnapshot.collectedInstances - this._previousSnapshot.collectedInstances;
        delta1.collectedSize = this._currentSnapshot.collectedSize - this._previousSnapshot.collectedSize;
        delta1.cumulativeTime = this._currentSnapshot.cumulativeTime - this._previousSnapshot.cumulativeTime;
        delta1.inheritedBaseTime = this._currentSnapshot.inheritedBaseTime - this._previousSnapshot.inheritedBaseTime;
        delta1.inheritedCalls = this._currentSnapshot.inheritedCalls - this._previousSnapshot.inheritedCalls;
        delta1.inheritedCumulativeTime = this._currentSnapshot.inheritedCumulativeTime - this._previousSnapshot.inheritedCumulativeTime;
        delta1.totalInstances = this._currentSnapshot.totalInstances - this._previousSnapshot.totalInstances;
        delta1.totalSize = this._currentSnapshot.totalSize - this._previousSnapshot.totalSize;
        return 1;
    }

    public int computeDelta(IDelta delta, int featureID) {
        TRCProcessSnapshot delta1 = (TRCProcessSnapshot)delta;
        if (this._currentSnapshot == null || this._previousSnapshot == null) {
            switch (featureID) {
                case 8: {
                    delta1.baseTime = 0.0;
                    break;
                }
                case 9: {
                    delta1.cumulativeTime = 0.0;
                    break;
                }
                case 10: {
                    delta1.calls = 0;
                    break;
                }
                case 11: {
                    delta1.inheritedCalls = 0;
                    break;
                }
                case 12: {
                    delta1.inheritedBaseTime = 0.0;
                    break;
                }
                case 13: {
                    delta1.inheritedCumulativeTime = 0.0;
                    break;
                }
                case 14: {
                    delta1.totalSize = 0;
                    break;
                }
                case 15: {
                    delta1.totalInstances = 0;
                    break;
                }
                case 16: {
                    delta1.collectedSize = 0;
                    break;
                }
                case 17: {
                    delta1.collectedInstances = 0;
                }
            }
            return -1;
        }
        switch (featureID) {
            case 8: {
                delta1.baseTime = this._currentSnapshot.baseTime - this._previousSnapshot.baseTime;
                break;
            }
            case 9: {
                delta1.cumulativeTime = this._currentSnapshot.cumulativeTime - this._previousSnapshot.cumulativeTime;
                break;
            }
            case 10: {
                delta1.calls = this._currentSnapshot.calls - this._previousSnapshot.calls;
                break;
            }
            case 11: {
                delta1.inheritedCalls = this._currentSnapshot.inheritedCalls - this._previousSnapshot.inheritedCalls;
                break;
            }
            case 12: {
                delta1.inheritedBaseTime = this._currentSnapshot.inheritedBaseTime - this._previousSnapshot.inheritedBaseTime;
                break;
            }
            case 13: {
                delta1.inheritedCumulativeTime = this._currentSnapshot.inheritedCumulativeTime - this._previousSnapshot.inheritedCumulativeTime;
                break;
            }
            case 14: {
                delta1.totalSize = this._currentSnapshot.totalSize - this._previousSnapshot.totalSize;
                break;
            }
            case 15: {
                delta1.totalInstances = this._currentSnapshot.totalInstances - this._previousSnapshot.totalInstances;
                break;
            }
            case 16: {
                delta1.collectedSize = this._currentSnapshot.collectedSize - this._previousSnapshot.collectedSize;
                break;
            }
            case 17: {
                delta1.collectedInstances = this._currentSnapshot.collectedInstances - this._previousSnapshot.collectedInstances;
            }
        }
        return 1;
    }

    public void removeSnapshot() {
        this._currentSnapshot = null;
        this._previousSnapshot = null;
    }

    public ISnapshot retrieveSnapshot() {
        if (this._currentSnapshot == null) {
            this.takeSnapshot();
        }
        return this._currentSnapshot;
    }

    public void takeSnapshot() {
        TRCProcessSnapshot temp = this._previousSnapshot;
        this._previousSnapshot = this._currentSnapshot;
        this._currentSnapshot = temp;
        if (this._currentSnapshot == null) {
            this._currentSnapshot = new TRCProcessSnapshot();
        }
        this._currentSnapshot.baseTime = this.baseTime;
        this._currentSnapshot.calls = this.calls;
        this._currentSnapshot.collectedInstances = this.collectedInstances;
        this._currentSnapshot.collectedSize = this.collectedSize;
        this._currentSnapshot.cumulativeTime = this.cumulativeTime;
        this._currentSnapshot.inheritedBaseTime = this.inheritedBaseTime;
        this._currentSnapshot.inheritedCalls = this.inheritedCalls;
        this._currentSnapshot.inheritedCumulativeTime = this.inheritedCumulativeTime;
        this._currentSnapshot.totalInstances = this.totalInstances;
        this._currentSnapshot.totalSize = this.totalSize;
        this._currentSnapshot.totalCpuTime = this.totalCpuTime;
    }

    protected TRCProcessImpl() {
    }

    protected EClass eStaticClass() {
        return TracePackage.eINSTANCE.getTRCProcess();
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int newPid) {
        int oldPid = this.pid;
        this.pid = newPid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldPid, this.pid));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldId, (Object)this.id));
        }
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double newStartTime) {
        double oldStartTime = this.startTime;
        this.startTime = newStartTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldStartTime, this.startTime));
        }
    }

    public double getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(double newStopTime) {
        double oldStopTime = this.stopTime;
        this.stopTime = newStopTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldStopTime, this.stopTime));
        }
    }

    public double getLastEventTime() {
        return this.lastEventTime;
    }

    public void setLastEventTime(double newLastEventTime) {
        double oldLastEventTime = this.lastEventTime;
        this.lastEventTime = newLastEventTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldLastEventTime, this.lastEventTime));
        }
    }

    public double getInitFinishedTime() {
        return this.initFinishedTime;
    }

    public void setInitFinishedTime(double newInitFinishedTime) {
        double oldInitFinishedTime = this.initFinishedTime;
        this.initFinishedTime = newInitFinishedTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldInitFinishedTime, this.initFinishedTime));
        }
    }

    public double getBaseTime() {
        return this.baseTime;
    }

    public void setBaseTime(double newBaseTime) {
        double oldBaseTime = this.baseTime;
        this.baseTime = newBaseTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldBaseTime, this.baseTime));
        }
    }

    public double getCumulativeTime() {
        return this.cumulativeTime;
    }

    public void setCumulativeTime(double newCumulativeTime) {
        double oldCumulativeTime = this.cumulativeTime;
        this.cumulativeTime = newCumulativeTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldCumulativeTime, this.cumulativeTime));
        }
    }

    public int getCalls() {
        return this.calls;
    }

    public void setCalls(int newCalls) {
        int oldCalls = this.calls;
        this.calls = newCalls;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldCalls, this.calls));
        }
    }

    public int getInheritedCalls() {
        return this.inheritedCalls;
    }

    public void setInheritedCalls(int newInheritedCalls) {
        int oldInheritedCalls = this.inheritedCalls;
        this.inheritedCalls = newInheritedCalls;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldInheritedCalls, this.inheritedCalls));
        }
    }

    public double getInheritedBaseTime() {
        return this.inheritedBaseTime;
    }

    public void setInheritedBaseTime(double newInheritedBaseTime) {
        double oldInheritedBaseTime = this.inheritedBaseTime;
        this.inheritedBaseTime = newInheritedBaseTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldInheritedBaseTime, this.inheritedBaseTime));
        }
    }

    public double getInheritedCumulativeTime() {
        return this.inheritedCumulativeTime;
    }

    public void setInheritedCumulativeTime(double newInheritedCumulativeTime) {
        double oldInheritedCumulativeTime = this.inheritedCumulativeTime;
        this.inheritedCumulativeTime = newInheritedCumulativeTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldInheritedCumulativeTime, this.inheritedCumulativeTime));
        }
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int newTotalSize) {
        int oldTotalSize = this.totalSize;
        this.totalSize = newTotalSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldTotalSize, this.totalSize));
        }
    }

    public int getTotalInstances() {
        return this.totalInstances;
    }

    public void setTotalInstances(int newTotalInstances) {
        int oldTotalInstances = this.totalInstances;
        this.totalInstances = newTotalInstances;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldTotalInstances, this.totalInstances));
        }
    }

    public int getCollectedSize() {
        return this.collectedSize;
    }

    public void setCollectedSize(int newCollectedSize) {
        int oldCollectedSize = this.collectedSize;
        this.collectedSize = newCollectedSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldCollectedSize, this.collectedSize));
        }
    }

    public int getCollectedInstances() {
        return this.collectedInstances;
    }

    public void setCollectedInstances(int newCollectedInstances) {
        int oldCollectedInstances = this.collectedInstances;
        this.collectedInstances = newCollectedInstances;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldCollectedInstances, this.collectedInstances));
        }
    }

    public short getReferencePointerSize() {
        return this.referencePointerSize;
    }

    public void setReferencePointerSize(short newReferencePointerSize) {
        short oldReferencePointerSize = this.referencePointerSize;
        this.referencePointerSize = newReferencePointerSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldReferencePointerSize, this.referencePointerSize));
        }
    }

    public EList getThreadStates() {
        if (this.threadStates == null) {
            this.threadStates = new EDataTypeUniqueEList(class$java$lang$String == null ? (class$java$lang$String = TRCProcessImpl.class$("java.lang.String")) : class$java$lang$String, (InternalEObject)this, 19);
        }
        return this.threadStates;
    }

    public double getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public void setTotalCpuTime(double newTotalCpuTime) {
        double oldTotalCpuTime = this.totalCpuTime;
        this.totalCpuTime = newTotalCpuTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, oldTotalCpuTime, this.totalCpuTime));
        }
    }

    public double getCpuSampleResolution() {
        return this.cpuSampleResolution;
    }

    public void setCpuSampleResolution(double newCpuSampleResolution) {
        double oldCpuSampleResolution = this.cpuSampleResolution;
        this.cpuSampleResolution = newCpuSampleResolution;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, oldCpuSampleResolution, this.cpuSampleResolution));
        }
    }

    public EList getThreads() {
        if (this.threads == null) {
            this.threads = new EObjectContainmentWithInverseEList(class$org$eclipse$hyades$models$trace$TRCThread == null ? (class$org$eclipse$hyades$models$trace$TRCThread = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCThread")) : class$org$eclipse$hyades$models$trace$TRCThread, (InternalEObject)this, 22, 7);
        }
        return this.threads;
    }

    public EList getPackages() {
        if (this.packages == null) {
            this.packages = new EObjectContainmentWithInverseEList(class$org$eclipse$hyades$models$trace$TRCPackage == null ? (class$org$eclipse$hyades$models$trace$TRCPackage = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCPackage")) : class$org$eclipse$hyades$models$trace$TRCPackage, (InternalEObject)this, 23, 12);
        }
        return this.packages;
    }

    public TRCClass getClassClass() {
        if (this.classClass != null && this.classClass.eIsProxy()) {
            TRCClass oldClassClass = this.classClass;
            this.classClass = (TRCClass)this.eResolveProxy((InternalEObject)this.classClass);
            if (this.classClass != oldClassClass && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 24, (Object)oldClassClass, (Object)this.classClass));
            }
        }
        return this.classClass;
    }

    public TRCClass basicGetClassClass() {
        return this.classClass;
    }

    public void setClassClass(TRCClass newClassClass) {
        TRCClass oldClassClass = this.classClass;
        this.classClass = newClassClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldClassClass, (Object)this.classClass));
        }
    }

    public EList getCollectionBoundaryPoints() {
        if (this.collectionBoundaryPoints == null) {
            this.collectionBoundaryPoints = new EObjectContainmentWithInverseEList(class$org$eclipse$hyades$models$trace$TRCCollectionBoundary == null ? (class$org$eclipse$hyades$models$trace$TRCCollectionBoundary = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCCollectionBoundary")) : class$org$eclipse$hyades$models$trace$TRCCollectionBoundary, (InternalEObject)this, 25, 5);
        }
        return this.collectionBoundaryPoints;
    }

    public EList getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new EObjectContainmentWithInverseEList(class$org$eclipse$hyades$models$trace$TRCClassLoader == null ? (class$org$eclipse$hyades$models$trace$TRCClassLoader = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCClassLoader")) : class$org$eclipse$hyades$models$trace$TRCClassLoader, (InternalEObject)this, 26, 0);
        }
        return this.classLoaders;
    }

    public EList getSourceInfos() {
        if (this.sourceInfos == null) {
            this.sourceInfos = new EObjectContainmentEList(class$org$eclipse$hyades$models$trace$TRCSourceInfo == null ? (class$org$eclipse$hyades$models$trace$TRCSourceInfo = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCSourceInfo")) : class$org$eclipse$hyades$models$trace$TRCSourceInfo, (InternalEObject)this, 27);
        }
        return this.sourceInfos;
    }

    public EList getObjects() {
        if (this.objects == null) {
            this.objects = new EObjectContainmentWithInverseEList(class$org$eclipse$hyades$models$trace$TRCObject == null ? (class$org$eclipse$hyades$models$trace$TRCObject = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCObject")) : class$org$eclipse$hyades$models$trace$TRCObject, (InternalEObject)this, 28, 3);
        }
        return this.objects;
    }

    public EList getHeapDumps() {
        if (this.heapDumps == null) {
            this.heapDumps = new EObjectContainmentWithInverseEList(class$org$eclipse$hyades$models$trace$TRCHeapDump == null ? (class$org$eclipse$hyades$models$trace$TRCHeapDump = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCHeapDump")) : class$org$eclipse$hyades$models$trace$TRCHeapDump, (InternalEObject)this, 29, 5);
        }
        return this.heapDumps;
    }

    public EList getInvocations() {
        if (this.invocations == null) {
            this.invocations = new EObjectContainmentWithInverseEList(class$org$eclipse$hyades$models$trace$TRCMethodInvocation == null ? (class$org$eclipse$hyades$models$trace$TRCMethodInvocation = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCMethodInvocation")) : class$org$eclipse$hyades$models$trace$TRCMethodInvocation, (InternalEObject)this, 30, 4);
        }
        return this.invocations;
    }

    public TRCInputOutputContainer getInputOutputContainer() {
        if (this.inputOutputContainer != null && this.inputOutputContainer.eIsProxy()) {
            TRCInputOutputContainer oldInputOutputContainer = this.inputOutputContainer;
            this.inputOutputContainer = (TRCInputOutputContainer)this.eResolveProxy((InternalEObject)this.inputOutputContainer);
            if (this.inputOutputContainer != oldInputOutputContainer && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 31, (Object)oldInputOutputContainer, (Object)this.inputOutputContainer));
            }
        }
        return this.inputOutputContainer;
    }

    public TRCInputOutputContainer basicGetInputOutputContainer() {
        return this.inputOutputContainer;
    }

    public NotificationChain basicSetInputOutputContainer(TRCInputOutputContainer newInputOutputContainer, NotificationChain msgs) {
        TRCInputOutputContainer oldInputOutputContainer = this.inputOutputContainer;
        this.inputOutputContainer = newInputOutputContainer;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 31, (Object)oldInputOutputContainer, (Object)newInputOutputContainer);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setInputOutputContainer(TRCInputOutputContainer newInputOutputContainer) {
        if (newInputOutputContainer != this.inputOutputContainer) {
            NotificationChain msgs = null;
            if (this.inputOutputContainer != null) {
                msgs = ((InternalEObject)this.inputOutputContainer).eInverseRemove((InternalEObject)this, 0, class$org$eclipse$hyades$models$trace$TRCInputOutputContainer == null ? (class$org$eclipse$hyades$models$trace$TRCInputOutputContainer = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCInputOutputContainer")) : class$org$eclipse$hyades$models$trace$TRCInputOutputContainer, msgs);
            }
            if (newInputOutputContainer != null) {
                msgs = ((InternalEObject)newInputOutputContainer).eInverseAdd((InternalEObject)this, 0, class$org$eclipse$hyades$models$trace$TRCInputOutputContainer == null ? (class$org$eclipse$hyades$models$trace$TRCInputOutputContainer = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCInputOutputContainer")) : class$org$eclipse$hyades$models$trace$TRCInputOutputContainer, msgs);
            }
            if ((msgs = this.basicSetInputOutputContainer(newInputOutputContainer, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 31, (Object)newInputOutputContainer, (Object)newInputOutputContainer));
        }
    }

    public EMap getMethodLockAccessEntries() {
        if (this.methodLockAccessEntries == null) {
            this.methodLockAccessEntries = new EcoreEMap(TracePackage.eINSTANCE.getTRCMthdLckAccEntry(), class$org$eclipse$hyades$models$trace$impl$TRCMthdLckAccEntryImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCMthdLckAccEntryImpl = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.impl.TRCMthdLckAccEntryImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCMthdLckAccEntryImpl, (InternalEObject)this, 32);
        }
        return this.methodLockAccessEntries;
    }

    public EMap getAllocationSitesEntries() {
        if (this.allocationSitesEntries == null) {
            this.allocationSitesEntries = new EcoreEMap(TracePackage.eINSTANCE.getTRCObjectAllocationSitesEntry(), class$org$eclipse$hyades$models$trace$impl$TRCObjectAllocationSitesEntryImpl == null ? (class$org$eclipse$hyades$models$trace$impl$TRCObjectAllocationSitesEntryImpl = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSitesEntryImpl")) : class$org$eclipse$hyades$models$trace$impl$TRCObjectAllocationSitesEntryImpl, (InternalEObject)this, 33);
        }
        return this.allocationSitesEntries;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 0, msgs);
                }
                case 22: {
                    return ((InternalEList)this.getThreads()).basicAdd((Object)otherEnd, msgs);
                }
                case 23: {
                    return ((InternalEList)this.getPackages()).basicAdd((Object)otherEnd, msgs);
                }
                case 25: {
                    return ((InternalEList)this.getCollectionBoundaryPoints()).basicAdd((Object)otherEnd, msgs);
                }
                case 26: {
                    return ((InternalEList)this.getClassLoaders()).basicAdd((Object)otherEnd, msgs);
                }
                case 28: {
                    return ((InternalEList)this.getObjects()).basicAdd((Object)otherEnd, msgs);
                }
                case 29: {
                    return ((InternalEList)this.getHeapDumps()).basicAdd((Object)otherEnd, msgs);
                }
                case 30: {
                    return ((InternalEList)this.getInvocations()).basicAdd((Object)otherEnd, msgs);
                }
                case 31: {
                    if (this.inputOutputContainer != null) {
                        msgs = ((InternalEObject)this.inputOutputContainer).eInverseRemove((InternalEObject)this, 0, class$org$eclipse$hyades$models$trace$TRCInputOutputContainer == null ? (class$org$eclipse$hyades$models$trace$TRCInputOutputContainer = TRCProcessImpl.class$("org.eclipse.hyades.models.trace.TRCInputOutputContainer")) : class$org$eclipse$hyades$models$trace$TRCInputOutputContainer, msgs);
                    }
                    return this.basicSetInputOutputContainer((TRCInputOutputContainer)otherEnd, msgs);
                }
                case 32: {
                    return ((InternalEList)this.getMethodLockAccessEntries()).basicAdd((Object)otherEnd, msgs);
                }
                case 33: {
                    return ((InternalEList)this.getAllocationSitesEntries()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return this.eBasicSetContainer(null, 0, msgs);
                }
                case 22: {
                    return ((InternalEList)this.getThreads()).basicRemove((Object)otherEnd, msgs);
                }
                case 23: {
                    return ((InternalEList)this.getPackages()).basicRemove((Object)otherEnd, msgs);
                }
                case 25: {
                    return ((InternalEList)this.getCollectionBoundaryPoints()).basicRemove((Object)otherEnd, msgs);
                }
                case 26: {
                    return ((InternalEList)this.getClassLoaders()).basicRemove((Object)otherEnd, msgs);
                }
                case 27: {
                    return ((InternalEList)this.getSourceInfos()).basicRemove((Object)otherEnd, msgs);
                }
                case 28: {
                    return ((InternalEList)this.getObjects()).basicRemove((Object)otherEnd, msgs);
                }
                case 29: {
                    return ((InternalEList)this.getHeapDumps()).basicRemove((Object)otherEnd, msgs);
                }
                case 30: {
                    return ((InternalEList)this.getInvocations()).basicRemove((Object)otherEnd, msgs);
                }
                case 31: {
                    return this.basicSetInputOutputContainer(null, msgs);
                }
                case 32: {
                    return ((InternalEList)this.getMethodLockAccessEntries()).basicRemove((Object)otherEnd, msgs);
                }
                case 33: {
                    return ((InternalEList)this.getAllocationSitesEntries()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 0: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 10, class$org$eclipse$hyades$models$hierarchy$TRCAgent == null ? (class$org$eclipse$hyades$models$hierarchy$TRCAgent = TRCProcessImpl.class$("org.eclipse.hyades.models.hierarchy.TRCAgent")) : class$org$eclipse$hyades$models$hierarchy$TRCAgent, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getAgent();
            }
            case 1: {
                return new Integer(this.getPid());
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getId();
            }
            case 4: {
                return new Double(this.getStartTime());
            }
            case 5: {
                return new Double(this.getStopTime());
            }
            case 6: {
                return new Double(this.getLastEventTime());
            }
            case 7: {
                return new Double(this.getInitFinishedTime());
            }
            case 8: {
                return new Double(this.getBaseTime());
            }
            case 9: {
                return new Double(this.getCumulativeTime());
            }
            case 10: {
                return new Integer(this.getCalls());
            }
            case 11: {
                return new Integer(this.getInheritedCalls());
            }
            case 12: {
                return new Double(this.getInheritedBaseTime());
            }
            case 13: {
                return new Double(this.getInheritedCumulativeTime());
            }
            case 14: {
                return new Integer(this.getTotalSize());
            }
            case 15: {
                return new Integer(this.getTotalInstances());
            }
            case 16: {
                return new Integer(this.getCollectedSize());
            }
            case 17: {
                return new Integer(this.getCollectedInstances());
            }
            case 18: {
                return new Short(this.getReferencePointerSize());
            }
            case 19: {
                return this.getThreadStates();
            }
            case 20: {
                return new Double(this.getTotalCpuTime());
            }
            case 21: {
                return new Double(this.getCpuSampleResolution());
            }
            case 22: {
                return this.getThreads();
            }
            case 23: {
                return this.getPackages();
            }
            case 24: {
                if (resolve) {
                    return this.getClassClass();
                }
                return this.basicGetClassClass();
            }
            case 25: {
                return this.getCollectionBoundaryPoints();
            }
            case 26: {
                return this.getClassLoaders();
            }
            case 27: {
                return this.getSourceInfos();
            }
            case 28: {
                return this.getObjects();
            }
            case 29: {
                return this.getHeapDumps();
            }
            case 30: {
                return this.getInvocations();
            }
            case 31: {
                if (resolve) {
                    return this.getInputOutputContainer();
                }
                return this.basicGetInputOutputContainer();
            }
            case 32: {
                return this.getMethodLockAccessEntries();
            }
            case 33: {
                return this.getAllocationSitesEntries();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setAgent((TRCAgent)newValue);
                return;
            }
            case 1: {
                this.setPid((Integer)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setId((String)newValue);
                return;
            }
            case 4: {
                this.setStartTime((Double)newValue);
                return;
            }
            case 5: {
                this.setStopTime((Double)newValue);
                return;
            }
            case 6: {
                this.setLastEventTime((Double)newValue);
                return;
            }
            case 7: {
                this.setInitFinishedTime((Double)newValue);
                return;
            }
            case 8: {
                this.setBaseTime((Double)newValue);
                return;
            }
            case 9: {
                this.setCumulativeTime((Double)newValue);
                return;
            }
            case 10: {
                this.setCalls((Integer)newValue);
                return;
            }
            case 11: {
                this.setInheritedCalls((Integer)newValue);
                return;
            }
            case 12: {
                this.setInheritedBaseTime((Double)newValue);
                return;
            }
            case 13: {
                this.setInheritedCumulativeTime((Double)newValue);
                return;
            }
            case 14: {
                this.setTotalSize((Integer)newValue);
                return;
            }
            case 15: {
                this.setTotalInstances((Integer)newValue);
                return;
            }
            case 16: {
                this.setCollectedSize((Integer)newValue);
                return;
            }
            case 17: {
                this.setCollectedInstances((Integer)newValue);
                return;
            }
            case 18: {
                this.setReferencePointerSize((Short)newValue);
                return;
            }
            case 19: {
                this.getThreadStates().clear();
                this.getThreadStates().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.setTotalCpuTime((Double)newValue);
                return;
            }
            case 21: {
                this.setCpuSampleResolution((Double)newValue);
                return;
            }
            case 22: {
                this.getThreads().clear();
                this.getThreads().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.getPackages().clear();
                this.getPackages().addAll((Collection)newValue);
                return;
            }
            case 24: {
                this.setClassClass((TRCClass)newValue);
                return;
            }
            case 25: {
                this.getCollectionBoundaryPoints().clear();
                this.getCollectionBoundaryPoints().addAll((Collection)newValue);
                return;
            }
            case 26: {
                this.getClassLoaders().clear();
                this.getClassLoaders().addAll((Collection)newValue);
                return;
            }
            case 27: {
                this.getSourceInfos().clear();
                this.getSourceInfos().addAll((Collection)newValue);
                return;
            }
            case 28: {
                this.getObjects().clear();
                this.getObjects().addAll((Collection)newValue);
                return;
            }
            case 29: {
                this.getHeapDumps().clear();
                this.getHeapDumps().addAll((Collection)newValue);
                return;
            }
            case 30: {
                this.getInvocations().clear();
                this.getInvocations().addAll((Collection)newValue);
                return;
            }
            case 31: {
                this.setInputOutputContainer((TRCInputOutputContainer)newValue);
                return;
            }
            case 32: {
                this.getMethodLockAccessEntries().clear();
                this.getMethodLockAccessEntries().addAll((Collection)newValue);
                return;
            }
            case 33: {
                this.getAllocationSitesEntries().clear();
                this.getAllocationSitesEntries().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setAgent(null);
                return;
            }
            case 1: {
                this.setPid(0);
                return;
            }
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 4: {
                this.setStartTime(0.0);
                return;
            }
            case 5: {
                this.setStopTime(0.0);
                return;
            }
            case 6: {
                this.setLastEventTime(0.0);
                return;
            }
            case 7: {
                this.setInitFinishedTime(0.0);
                return;
            }
            case 8: {
                this.setBaseTime(0.0);
                return;
            }
            case 9: {
                this.setCumulativeTime(0.0);
                return;
            }
            case 10: {
                this.setCalls(0);
                return;
            }
            case 11: {
                this.setInheritedCalls(0);
                return;
            }
            case 12: {
                this.setInheritedBaseTime(0.0);
                return;
            }
            case 13: {
                this.setInheritedCumulativeTime(0.0);
                return;
            }
            case 14: {
                this.setTotalSize(0);
                return;
            }
            case 15: {
                this.setTotalInstances(0);
                return;
            }
            case 16: {
                this.setCollectedSize(0);
                return;
            }
            case 17: {
                this.setCollectedInstances(0);
                return;
            }
            case 18: {
                this.setReferencePointerSize((short)4);
                return;
            }
            case 19: {
                this.getThreadStates().clear();
                return;
            }
            case 20: {
                this.setTotalCpuTime(0.0);
                return;
            }
            case 21: {
                this.setCpuSampleResolution(0.0);
                return;
            }
            case 22: {
                this.getThreads().clear();
                return;
            }
            case 23: {
                this.getPackages().clear();
                return;
            }
            case 24: {
                this.setClassClass(null);
                return;
            }
            case 25: {
                this.getCollectionBoundaryPoints().clear();
                return;
            }
            case 26: {
                this.getClassLoaders().clear();
                return;
            }
            case 27: {
                this.getSourceInfos().clear();
                return;
            }
            case 28: {
                this.getObjects().clear();
                return;
            }
            case 29: {
                this.getHeapDumps().clear();
                return;
            }
            case 30: {
                this.getInvocations().clear();
                return;
            }
            case 31: {
                this.setInputOutputContainer(null);
                return;
            }
            case 32: {
                this.getMethodLockAccessEntries().clear();
                return;
            }
            case 33: {
                this.getAllocationSitesEntries().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getAgent() != null;
            }
            case 1: {
                return this.pid != 0;
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 4: {
                return this.startTime != 0.0;
            }
            case 5: {
                return this.stopTime != 0.0;
            }
            case 6: {
                return this.lastEventTime != 0.0;
            }
            case 7: {
                return this.initFinishedTime != 0.0;
            }
            case 8: {
                return this.baseTime != 0.0;
            }
            case 9: {
                return this.cumulativeTime != 0.0;
            }
            case 10: {
                return this.calls != 0;
            }
            case 11: {
                return this.inheritedCalls != 0;
            }
            case 12: {
                return this.inheritedBaseTime != 0.0;
            }
            case 13: {
                return this.inheritedCumulativeTime != 0.0;
            }
            case 14: {
                return this.totalSize != 0;
            }
            case 15: {
                return this.totalInstances != 0;
            }
            case 16: {
                return this.collectedSize != 0;
            }
            case 17: {
                return this.collectedInstances != 0;
            }
            case 18: {
                return this.referencePointerSize != 4;
            }
            case 19: {
                return this.threadStates != null && !this.threadStates.isEmpty();
            }
            case 20: {
                return this.totalCpuTime != 0.0;
            }
            case 21: {
                return this.cpuSampleResolution != 0.0;
            }
            case 22: {
                return this.threads != null && !this.threads.isEmpty();
            }
            case 23: {
                return this.packages != null && !this.packages.isEmpty();
            }
            case 24: {
                return this.classClass != null;
            }
            case 25: {
                return this.collectionBoundaryPoints != null && !this.collectionBoundaryPoints.isEmpty();
            }
            case 26: {
                return this.classLoaders != null && !this.classLoaders.isEmpty();
            }
            case 27: {
                return this.sourceInfos != null && !this.sourceInfos.isEmpty();
            }
            case 28: {
                return this.objects != null && !this.objects.isEmpty();
            }
            case 29: {
                return this.heapDumps != null && !this.heapDumps.isEmpty();
            }
            case 30: {
                return this.invocations != null && !this.invocations.isEmpty();
            }
            case 31: {
                return this.inputOutputContainer != null;
            }
            case 32: {
                return this.methodLockAccessEntries != null && !this.methodLockAccessEntries.isEmpty();
            }
            case 33: {
                return this.allocationSitesEntries != null && !this.allocationSitesEntries.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pid: ");
        result.append(this.pid);
        result.append(", name: ");
        result.append(this.name);
        result.append(", id: ");
        result.append(this.id);
        result.append(", startTime: ");
        result.append(this.startTime);
        result.append(", stopTime: ");
        result.append(this.stopTime);
        result.append(", lastEventTime: ");
        result.append(this.lastEventTime);
        result.append(", initFinishedTime: ");
        result.append(this.initFinishedTime);
        result.append(", baseTime: ");
        result.append(this.baseTime);
        result.append(", cumulativeTime: ");
        result.append(this.cumulativeTime);
        result.append(", calls: ");
        result.append(this.calls);
        result.append(", inheritedCalls: ");
        result.append(this.inheritedCalls);
        result.append(", inheritedBaseTime: ");
        result.append(this.inheritedBaseTime);
        result.append(", inheritedCumulativeTime: ");
        result.append(this.inheritedCumulativeTime);
        result.append(", totalSize: ");
        result.append(this.totalSize);
        result.append(", totalInstances: ");
        result.append(this.totalInstances);
        result.append(", collectedSize: ");
        result.append(this.collectedSize);
        result.append(", collectedInstances: ");
        result.append(this.collectedInstances);
        result.append(", referencePointerSize: ");
        result.append(this.referencePointerSize);
        result.append(", threadStates: ");
        result.append(this.threadStates);
        result.append(", totalCpuTime: ");
        result.append(this.totalCpuTime);
        result.append(", cpuSampleResolution: ");
        result.append(this.cpuSampleResolution);
        result.append(')');
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TRCProcessSnapshot
    implements IDelta,
    ISnapshot {
        protected double baseTime = 0.0;
        protected int calls = 0;
        protected int collectedInstances = 0;
        protected int collectedSize = 0;
        protected double cumulativeTime = 0.0;
        protected double inheritedBaseTime = 0.0;
        protected int inheritedCalls = 0;
        protected double inheritedCumulativeTime = 0.0;
        protected int totalInstances = 0;
        protected int totalSize = 0;
        protected double totalCpuTime = 0.0;

        public Object get(int featureID) {
            switch (featureID) {
                case 8: {
                    return new Double(this.getBaseTime());
                }
                case 9: {
                    return new Double(this.getCumulativeTime());
                }
                case 10: {
                    return new Integer(this.getCalls());
                }
                case 11: {
                    return new Integer(this.getInheritedCalls());
                }
                case 12: {
                    return new Double(this.getInheritedBaseTime());
                }
                case 13: {
                    return new Double(this.getInheritedCumulativeTime());
                }
                case 14: {
                    return new Integer(this.getTotalSize());
                }
                case 15: {
                    return new Integer(this.getTotalInstances());
                }
                case 16: {
                    return new Integer(this.getCollectedSize());
                }
                case 17: {
                    return new Integer(this.getCollectedInstances());
                }
                case 20: {
                    return new Double(this.getTotalCpuTime());
                }
            }
            return null;
        }

        public double getBaseTime() {
            return this.baseTime;
        }

        public int getCalls() {
            return this.calls;
        }

        public int getCollectedInstances() {
            return this.collectedInstances;
        }

        public int getCollectedSize() {
            return this.collectedSize;
        }

        public double getCumulativeTime() {
            return this.cumulativeTime;
        }

        public double getInheritedBaseTime() {
            return this.inheritedBaseTime;
        }

        public int getInheritedCalls() {
            return this.inheritedCalls;
        }

        public int getTotalInstances() {
            return this.totalInstances;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public double getInheritedCumulativeTime() {
            return this.inheritedCumulativeTime;
        }

        public double getTotalCpuTime() {
            return this.totalCpuTime;
        }

        public void setTotalCpuTime(double totalCpuTime) {
            this.totalCpuTime = totalCpuTime;
        }
    }
}

