/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.datapool.evaluator.DatapoolEvaluatorLiteral;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEvaluatorExt;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;

public class DatapoolUtil {
    private static IExtension[] dpEvaluatorExts;
    private static HashMap dpEvaluatorsMap;

    private static IExtension[] getEvaluatorExts() {
        if (dpEvaluatorExts == null) {
            IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.datapool.datapool_evaluator");
            if (extPoint != null) {
                DPLLogImpl.log("ext point found!!!");
                dpEvaluatorExts = extPoint.getExtensions();
                DPLLogImpl.log("extensions.length: " + dpEvaluatorExts.length);
            } else {
                dpEvaluatorExts = new IExtension[0];
            }
        }
        return dpEvaluatorExts;
    }

    public static IDatapoolEvaluatorExt findDatapoolEvaluator(String tag) {
        try {
            IDatapoolEvaluatorExt evaluator = (IDatapoolEvaluatorExt)dpEvaluatorsMap.get(tag);
            if (evaluator != null) {
                return evaluator;
            }
            if (tag != null && tag.equals("Literal")) {
                Class<?> cls = Class.forName("org.eclipse.hyades.datapool.evaluator.DatapoolEvaluatorLiteral");
                evaluator = (DatapoolEvaluatorLiteral)cls.newInstance();
                dpEvaluatorsMap.put(tag, evaluator);
                return evaluator;
            }
            IExtension[] extensions = DatapoolUtil.getEvaluatorExts();
            int i = 0;
            while (i < extensions.length) {
                IExtension currentExtension = extensions[i];
                DPLLogImpl.log("   extension:" + currentExtension.getUniqueIdentifier());
                IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                DPLLogImpl.log("configElements.length : " + configElements.length);
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement currentConfigElement = configElements[j];
                    String currentTag = currentConfigElement.getAttribute("tag");
                    DPLLogImpl.log("Tag: " + currentTag);
                    DPLLogImpl.log("configElement: " + currentConfigElement.toString());
                    if (tag.equals(currentTag)) {
                        evaluator = (IDatapoolEvaluatorExt)currentConfigElement.createExecutableExtension("class");
                        dpEvaluatorsMap.put(tag, evaluator);
                        DPLLogImpl.log("evaluator: " + evaluator.toString());
                        return evaluator;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            DPLLogImpl.log(t.getMessage());
        }
        return null;
    }

    static {
        dpEvaluatorsMap = new HashMap();
    }
}

