/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import java.util.HashMap;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;

public class LoadersManager {
    private static LoadersManager loadersManager;
    private static HashMap map;
    private static SDView currentView;
    private String primaryViewId = null;

    private LoadersManager() {
        map = new HashMap();
    }

    public static LoadersManager getLoadersManager() {
        if (loadersManager == null) {
            loadersManager = new LoadersManager();
        }
        return loadersManager;
    }

    public IUml2SDLoader createLoader(String className, ClassLoader cl, SDView view) {
        IUml2SDLoader loader = null;
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            Class<?> clazz = cl.loadClass(className);
            loader = (IUml2SDLoader)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        if (view != null) {
            this.setCurrentLoader(loader, view.getViewSite().getId());
        }
        if (loader != null) {
            loader.setViewer(view);
        }
        return loader;
    }

    public void setCurrentLoader(IUml2SDLoader loader, String id) {
        IWorkbenchPage persp;
        if (id == null) {
            return;
        }
        IUml2SDLoader currentLoader = null;
        if (map.get(id) instanceof IUml2SDLoader) {
            currentLoader = (IUml2SDLoader)map.get(id);
        }
        if (currentLoader != null && currentLoader != loader) {
            if (loader != null) {
                persp = UIPlugin.getActivePage();
                try {
                    SDView sdview = null;
                    IViewReference viewref = persp.findViewReference(id);
                    if (viewref != null) {
                        sdview = (SDView)viewref.getView(false);
                    }
                    if (sdview != null) {
                        sdview.resetProviders();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            currentLoader.aboutToBeReplaced();
        }
        persp = UIPlugin.getActivePage();
        map.put(id, loader);
        if (loader != null && id != null) {
            SDViewerPlugin.getDefault().setLastLoader(loader.getClass().getName(), id);
        }
    }

    public void resetLoaders(String viewId) {
        map.put(viewId, null);
    }

    public IUml2SDLoader getCurrentLoader(String viewId) {
        if (viewId == null) {
            return null;
        }
        IWorkbenchPage persp = UIPlugin.getActivePage();
        try {
            SDView view = null;
            IViewReference viewref = persp.findViewReference(viewId);
            if (viewref != null) {
                view = (SDView)viewref.getView(false);
            }
            if (map.size() == 0) {
                SDViewerPlugin.getDefault().createLastLoaderIfAny();
            }
            if (view != null && map.get(viewId) instanceof IUml2SDLoader) {
                return (IUml2SDLoader)map.get(viewId);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

