/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDCollapseProvider;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;
import org.eclipse.hyades.uml2sd.ui.view.DiagramToolTip;
import org.eclipse.hyades.uml2sd.ui.view.ITimeCompressionListener;
import org.eclipse.hyades.uml2sd.ui.view.NGC;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidgetSelectionProvider;
import org.eclipse.hyades.uml2sd.ui.view.ScrollView;
import org.eclipse.hyades.uml2sd.ui.view.TimeCompressionBar;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.ViewPart;

public class SDWidget
extends ScrollView
implements SelectionListener,
IPropertyChangeListener,
DisposeListener,
ITimeCompressionListener {
    private Frame frame;
    private Image overView = null;
    private static Color foreGroundColor = null;
    private static Color backGroundColor = null;
    private static Display display = null;
    private Menu menu = null;
    protected MenuItem zoomIn = null;
    protected MenuItem zoomOut = null;
    protected SDWidgetSelectionProvider selProvider = null;
    protected float zoomValue = 1.0f;
    protected boolean zoomInMode = false;
    protected boolean zoomOutMode = false;
    protected List selectedNodeList = null;
    protected boolean multiSelection = false;
    private ViewPart site = null;
    public GraphNode currentGraphNode = null;
    private TimeCompressionBar timeBar = null;
    private DiagramToolTip toolTip = null;
    private Accessible accessible = null;
    protected GraphNode toolTipNode;
    protected GraphNode dragAndDrop = null;
    protected int focusedWidget = -1;
    private boolean getDragAndDrop = false;
    protected int dragX = 0;
    protected int dragY = 0;
    protected boolean reorderMode = false;
    Image collapaseCaretImg = null;
    Image arrowUpCaretImg = null;
    Image currentCaretImage = null;
    protected ISDCollapseProvider collapseProvider = null;
    protected Caret insertionCartet = null;
    protected ArrayList reorderList = null;
    private AutoScroll auto_scroll_ = null;
    private Timer auto_scroll_timer_ = null;

    public SDWidget(Composite c, int s) {
        super(c, s | 0x40000, false);
        display = this.getDisplay();
        this.setOverviewEnabled(true);
        this.selectedNodeList = new ArrayList();
        this.selProvider = new SDWidgetSelectionProvider();
        SDViewPref.getInstance().addPropertyChangeListener(this);
        this.toolTip = new DiagramToolTip(this.getViewControl());
        super.addDisposeListener((DisposeListener)this);
        this.accessible = this.getViewControl().getAccessible();
        this.accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    if (e.childID == 0) {
                        if (SDWidget.this.toolTipNode != null) {
                            if (SDWidget.this.toolTipNode instanceof Lifeline) {
                                Lifeline lifeline = (Lifeline)SDWidget.this.toolTipNode;
                                e.result = lifeline.getToolTipText();
                            } else {
                                e.result = SDWidget.this.toolTipNode.getName();
                            }
                        }
                    } else {
                        e.result = SDWidget.this.currentGraphNode.getName();
                    }
                }
            }
        });
        this.accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getFocus(AccessibleControlEvent e) {
                e.childID = SDWidget.this.focusedWidget == -1 ? -1 : SDWidget.this.focusedWidget;
            }

            public void getRole(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.detail = 10;
                        break;
                    }
                    case 0: {
                        e.detail = 13;
                        break;
                    }
                    case 1: {
                        e.detail = 41;
                    }
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (e.childID == -1) {
                    e.detail |= 4;
                } else {
                    e.detail |= 0x200000;
                    if (e.childID == SDWidget.this.focusedWidget) {
                        e.detail |= 0x16;
                    }
                }
            }
        });
        this.insertionCartet = new Caret((Canvas)this.getViewControl(), 0);
        this.insertionCartet.setVisible(false);
        this.collapaseCaretImg = SDViewerPlugin.getResourceImage("arrow_colapse.bmp").createImage();
        this.arrowUpCaretImg = SDViewerPlugin.getResourceImage("arrow_up.bmp").createImage();
        this.reorderList = new ArrayList();
    }

    public void setTimeBar(TimeCompressionBar bar) {
        if (bar != null) {
            this.timeBar = bar;
            this.timeBar.addTimeCompressionListener(this);
        }
    }

    protected void setCollapseProvider(ISDCollapseProvider provider) {
        this.collapseProvider = provider;
    }

    protected void keyPressedEvent(KeyEvent event) {
        if (event.keyCode == 262144) {
            this.multiSelection = true;
        }
        if (event.character == ' ' && (this.zoomInMode || this.zoomOutMode)) {
            int cx = Math.round((float)(this.getContentsX() + this.getVisibleWidth() / 2) / this.zoomValue);
            int cy = Math.round((float)(this.getContentsY() + this.getVisibleHeight() / 2) / this.zoomValue);
            if (this.zoomInMode) {
                if (this.zoomValue < 64.0f) {
                    this.zoomValue *= 1.25f;
                }
            } else {
                this.zoomValue /= 1.25f;
            }
            int x = Math.round((float)cx * this.zoomValue - (float)(this.getVisibleWidth() / 2));
            int y = Math.round((float)cy * this.zoomValue - (float)(this.getVisibleHeight() / 2));
            this.setContentsPos(x, y);
            if (this.timeBar != null) {
                this.timeBar.setZoom(this.zoomValue);
            }
            this.redraw();
        }
        super.keyPressedEvent(event);
    }

    protected void keyReleasedEvent(KeyEvent event) {
        this.setFocus(-1);
        this.multiSelection = false;
        super.keyReleasedEvent(event);
        this.setFocus(1);
    }

    public void resizeContents(Frame frame) {
        int width = Math.round((float)(frame.getWidth() + 20) * this.zoomValue);
        int height = Math.round((float)(frame.getHeight() + 20) * this.zoomValue);
        this.resizeContents(width, height);
    }

    protected boolean checkFocusOnChilds(Control childs) {
        if (childs instanceof Composite) {
            Control[] child = ((Composite)childs).getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) {
                    return true;
                }
                this.checkFocusOnChilds(child[i]);
                ++i;
            }
        }
        return false;
    }

    public boolean isFocusControl() {
        Control[] child = this.getChildren();
        int i = 0;
        while (i < child.length) {
            if (child[i].isFocusControl()) {
                return true;
            }
            this.checkFocusOnChilds(child[i]);
            ++i;
        }
        return false;
    }

    protected void setFrame(Frame theFrame, boolean resetPosition) {
        this.reorderList.clear();
        this.selectedNodeList.clear();
        this.selProvider.setSelection((ISelection)new StructuredSelection());
        this.frame = theFrame;
        if (resetPosition) {
            this.setContentsPos(0, 0);
            this.resizeContents(this.frame);
            this.redraw();
        }
        if (this.overView != null) {
            this.overView.dispose();
        }
        this.overView = null;
        this.resizeContents(this.frame);
    }

    protected Frame getFrame() {
        return this.frame;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selProvider;
    }

    public boolean setContentsPos(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (this.frame == null) {
            return false;
        }
        if (x + this.getVisibleWidth() > this.getContentsWidth()) {
            x = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (y + this.getVisibleHeight() > this.getContentsHeight()) {
            y = this.getContentsHeight() - this.getVisibleHeight();
        }
        int x1 = Math.round((float)x / this.zoomValue);
        int y2 = Math.round((float)y / this.zoomValue);
        int width = Math.round((float)this.getVisibleWidth() / this.zoomValue);
        int height = Math.round((float)this.getVisibleHeight() / this.zoomValue);
        this.frame.updateIndex(x1, y2, width, height);
        if (this.insertionCartet != null && this.insertionCartet.isVisible()) {
            this.insertionCartet.setVisible(false);
        }
        return super.setContentsPos(x, y);
    }

    protected void contentsMouseHover(MouseEvent event) {
        GraphNode graphNode = null;
        if (this.frame != null) {
            int y;
            int x = Math.round((float)event.x / this.zoomValue);
            graphNode = this.frame.getNodeAt(x, y = Math.round((float)event.y / this.zoomValue));
            if (graphNode != null) {
                this.toolTipNode = graphNode;
                String postfix = "";
                if (this.currentGraphNode != null && this.currentGraphNode instanceof ITimeRange && graphNode instanceof ITimeRange && this.currentGraphNode != graphNode && ((ITimeRange)((Object)graphNode)).hasTimeInfo() && ((ITimeRange)((Object)this.currentGraphNode)).hasTimeInfo()) {
                    double delta = ((ITimeRange)((Object)graphNode)).getLastTime() - ((ITimeRange)((Object)this.currentGraphNode)).getLastTime();
                    postfix = "\n";
                    postfix = postfix + MessageFormat.format(SDViewerPlugin.getResourceString("STR_ELAPSED_TIME"), SDViewerPlugin.timeToString(delta));
                    if (!((ITimeRange)((Object)this.currentGraphNode)).hasTimeInfo()) {
                        return;
                    }
                }
                if (graphNode instanceof Lifeline) {
                    Lifeline lifeline = (Lifeline)graphNode;
                    this.toolTip.showToolTip(lifeline.getToolTipText() + postfix);
                    this.setFocus(0);
                } else {
                    this.toolTip.showToolTip(graphNode.getName() + postfix);
                    this.setFocus(0);
                }
            } else {
                this.toolTip.hideToolTip();
            }
        }
    }

    protected void setFocus(int newFocusShape) {
        this.focusedWidget = newFocusShape;
        if (this.focusedWidget == -1) {
            this.getViewControl().getAccessible().setFocus(-1);
        } else {
            this.getViewControl().getAccessible().setFocus(this.focusedWidget);
        }
    }

    protected void contentsMouseMoveEvent(MouseEvent e) {
        this.toolTip.hideToolTip();
        if (!this.isFocusControl() && !this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            int i = 0;
            while (i < child.length) {
                if (child[i].isFocusControl()) {
                    this.getViewControl().setFocus();
                    break;
                }
                ++i;
            }
        }
        this.setFocus(-1);
        if ((e.stateMask & SWT.BUTTON_MASK) != 0 && (this.dragAndDrop != null || this.getDragAndDrop) && (this.reorderMode || this.collapseProvider != null)) {
            this.getDragAndDrop = false;
            if (this.currentGraphNode instanceof Lifeline) {
                this.dragAndDrop = (Lifeline)this.currentGraphNode;
            }
            if (this.dragAndDrop != null) {
                int dx = 0;
                int dy = 0;
                if (e.x > this.getContentsX() + this.getVisibleWidth()) {
                    dx = e.x - (this.getContentsX() + this.getVisibleWidth());
                } else if (e.x < this.getContentsX()) {
                    dx = -this.getContentsX() + e.x;
                }
                if (e.y > this.getContentsY() + this.getVisibleHeight()) {
                    dy = e.y - (this.getContentsY() + this.getVisibleHeight());
                } else if (e.y < this.getContentsY()) {
                    dy = -this.getContentsY() + e.y;
                }
                this.dragX = e.x;
                this.dragY = e.y;
                if (dx != 0 || dy != 0) {
                    if (this.auto_scroll_ == null) {
                        if (this.auto_scroll_timer_ == null) {
                            this.auto_scroll_timer_ = new Timer(true);
                        }
                        this.auto_scroll_ = new AutoScroll(this, dx, dy);
                        this.auto_scroll_timer_.schedule((TimerTask)this.auto_scroll_, 0L, 75L);
                    } else {
                        this.auto_scroll_.dx_ = dx;
                        this.auto_scroll_.dy_ = dy;
                    }
                } else if (this.auto_scroll_ != null) {
                    this.auto_scroll_.cancel();
                    this.auto_scroll_ = null;
                }
                this.dragX = Math.round((float)e.x / this.zoomValue);
                this.dragY = Math.round((float)e.y / this.zoomValue);
                this.redraw();
                Lifeline node = this.frame.getCloserLifeline(this.dragX);
                if (node != null && node != this.dragAndDrop) {
                    int y = 0;
                    int y1 = 0;
                    int height = Metrics.getLifelineHeaderFontHeigth() + 8;
                    int hMargin = 7;
                    int x = node.getX();
                    int width = node.getWidth();
                    y = this.frame.getVisibleAreaY() < node.getY() + node.getHeight() - height - hMargin ? this.contentsToViewY(Math.round((float)(node.getY() + node.getHeight()) * this.zoomValue)) : Math.round((float)height * this.zoomValue);
                    y1 = this.frame.getVisibleAreaY() < this.contentsToViewY(node.getY() - hMargin) ? this.contentsToViewY(Math.round((float)(node.getY() - hMargin) * this.zoomValue)) : Math.round((float)height * this.zoomValue);
                    int rx = Math.round((float)x * this.zoomValue);
                    this.insertionCartet.setVisible(true);
                    if (this.insertionCartet.getImage() != null && !this.insertionCartet.getImage().isDisposed()) {
                        this.insertionCartet.getImage().dispose();
                    }
                    if (rx <= e.x && Math.round((float)rx + (float)width * this.zoomValue) >= e.x) {
                        if (this.collapseProvider != null) {
                            ImageData data = this.collapaseCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.collapaseCaretImg.getBounds().width * this.zoomValue), Math.round((float)this.collapaseCaretImg.getBounds().height * this.zoomValue));
                            this.currentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.insertionCartet.setImage(this.currentCaretImage);
                            this.insertionCartet.setLocation(this.contentsToViewX(rx + Math.round((float)(width / 2) * this.zoomValue)) - this.currentCaretImage.getBounds().width / 2, y);
                        }
                    } else if (this.reorderMode) {
                        if (rx > e.x) {
                            if (node.getIndex() > 1 && this.frame.getLifeline(node.getIndex() - 2) == this.dragAndDrop) {
                                return;
                            }
                            ImageData data = this.arrowUpCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.arrowUpCaretImg.getBounds().width * this.zoomValue), Math.round((float)this.arrowUpCaretImg.getBounds().height * this.zoomValue));
                            this.currentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.insertionCartet.setImage(this.currentCaretImage);
                            this.insertionCartet.setLocation(this.contentsToViewX(Math.round((float)(x - 22) * this.zoomValue)) - this.currentCaretImage.getBounds().width / 2, y1);
                        } else {
                            if (node.getIndex() < this.frame.lifeLinesCount() && this.frame.getLifeline(node.getIndex()) == this.dragAndDrop) {
                                return;
                            }
                            ImageData data = this.arrowUpCaretImg.getImageData();
                            data = data.scaledTo(Math.round((float)this.arrowUpCaretImg.getBounds().width * this.zoomValue), Math.round((float)this.arrowUpCaretImg.getBounds().height * this.zoomValue));
                            this.currentCaretImage = new Image((Device)Display.getCurrent(), data);
                            this.insertionCartet.setImage(this.currentCaretImage);
                            this.insertionCartet.setLocation(this.contentsToViewX(Math.round((float)(x + width + 22) * this.zoomValue)) - this.currentCaretImage.getBounds().width / 2 + 1, y1);
                        }
                    }
                } else {
                    this.insertionCartet.setVisible(false);
                }
            }
        } else {
            super.contentsMouseMoveEvent(e);
        }
    }

    protected void contentsMouseUpEvent(MouseEvent event) {
        this.insertionCartet.setVisible(false);
        if (this.dragAndDrop != null) {
            if (this.overView != null && !this.overView.isDisposed()) {
                this.overView.dispose();
            }
            this.overView = null;
            Lifeline node = this.frame.getCloserLifeline(this.dragX);
            if (node != null) {
                int rx = Math.round((float)node.getX() * this.zoomValue);
                if (rx <= event.x && Math.round((float)rx + (float)node.getWidth() * this.zoomValue) >= event.x) {
                    if (this.collapseProvider != null && this.dragAndDrop != node) {
                        this.collapseProvider.collapseTwoLifelines((Lifeline)this.dragAndDrop, node);
                    }
                } else if (rx < event.x) {
                    this.frame.insertLifelineAfter((Lifeline)this.dragAndDrop, node);
                    if (node.getIndex() < this.frame.lifeLinesCount()) {
                        Lifeline[] temp = new Lifeline[]{(Lifeline)this.dragAndDrop, this.frame.getLifeline(node.getIndex())};
                        this.reorderList.add(temp);
                    } else {
                        Lifeline[] temp = new Lifeline[]{(Lifeline)this.dragAndDrop, null};
                        this.reorderList.add(temp);
                    }
                } else {
                    this.frame.insertLifelineBefore((Lifeline)this.dragAndDrop, node);
                    Lifeline[] temp = new Lifeline[]{(Lifeline)this.dragAndDrop, node};
                    this.reorderList.add(temp);
                }
            }
        }
        this.dragAndDrop = null;
        this.redraw();
        if (this.frame == null) {
            return;
        }
        this.frame.resetTimeCompression();
        if (this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
        super.contentsMouseUpEvent(event);
    }

    protected void contentsMouseDownEvent(MouseEvent event) {
        if (this.frame == null) {
            return;
        }
        this.frame.resetTimeCompression();
        this.multiSelection = (event.stateMask & 0x40000) != 0;
        if ((this.zoomInMode || this.zoomOutMode) && event.button == 1) {
            int cx = Math.round((float)event.x / this.zoomValue);
            int cy = Math.round((float)event.y / this.zoomValue);
            if (this.zoomInMode) {
                if (this.zoomValue < 64.0f) {
                    this.zoomValue *= 1.25f;
                }
            } else {
                this.zoomValue /= 1.25f;
            }
            int x = Math.round((float)cx * this.zoomValue - (float)(this.getVisibleWidth() / 2));
            int y = Math.round((float)cy * this.zoomValue - (float)(this.getVisibleHeight() / 2));
            this.setContentsPos(x, y);
            if (this.timeBar != null) {
                this.timeBar.setZoom(this.zoomValue);
            }
            this.redraw();
        } else {
            GraphNode node = null;
            if (this.frame != null) {
                int x = Math.round((float)event.x / this.zoomValue);
                int y = Math.round((float)event.y / this.zoomValue);
                node = this.frame.getNodeAt(x, y);
                if (event.button == 1 || node != null && !node.isSelected() && !this.multiSelection) {
                    this.performSelection(node);
                    this.currentGraphNode = node;
                }
                this.redraw();
            }
        }
        if (this.dragAndDrop == null) {
            super.contentsMouseDownEvent(event);
        }
        this.getDragAndDrop = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performSelection(GraphNode node) {
        if (this.multiSelection) {
            if (node == null) return;
            if (this.selectedNodeList.contains(node)) {
                this.removeSelection(node);
                return;
            } else {
                this.addSelection(node);
            }
            return;
        } else {
            this.clearSelection();
            if (node == null) return;
            this.addSelection(node);
        }
    }

    public List getSelection() {
        return this.selectedNodeList;
    }

    public void addSelection(GraphNode node) {
        if (node == null) {
            return;
        }
        this.selectedNodeList.add(node);
        node.setSelected(true);
        this.currentGraphNode = node;
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void addSelection(List list) {
        this.selectedNodeList.addAll(list);
        int i = 0;
        while (i < list.size()) {
            ((GraphNode)list.get(i)).setSelected(true);
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void removeSelection(GraphNode node) {
        this.selectedNodeList.remove(node);
        node.setSelected(false);
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void removeSelection(List list) {
        this.selectedNodeList.removeAll(list);
        int i = 0;
        while (i < list.size()) {
            ((GraphNode)list.get(i)).setSelected(false);
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)selection);
    }

    public void clearSelection() {
        int i = 0;
        while (i < this.selectedNodeList.size()) {
            ((GraphNode)this.selectedNodeList.get(i)).setSelected(false);
            ++i;
        }
        this.selectedNodeList.clear();
        this.selProvider.setSelection((ISelection)new StructuredSelection());
    }

    public void setSite(ViewPart viewSite) {
        this.site = viewSite;
        this.site.getSite().setSelectionProvider((ISelectionProvider)this.selProvider);
        String[] sdScropes = new String[]{"org.eclipse.ui.UML2SDScope", "org.eclipse.ui.globalScope"};
        this.site.getSite().getKeyBindingService().setScopes(sdScropes);
    }

    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        if (this.frame == null) {
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.fillRectangle(0, 0, this.getVisibleWidth(), this.getVisibleHeight());
            gc.dispose();
            return;
        }
        Frame.setUserPref(SDViewPref.getInstance());
        this.update();
        Rectangle area = this.getClientArea();
        Image dbuffer = null;
        GC gcim = null;
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                if (dbuffer != null) {
                    dbuffer.dispose();
                }
                dbuffer = new Image((Device)this.getDisplay(), area.width, area.height);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            gcim = new GC(dbuffer);
        } else {
            gcim = gc;
        }
        NGC context = new NGC(this, gcim);
        Metrics.setLifelineFontHeight(context.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineFontWidth(context.getFontWidth(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineWidth(SDViewPref.getInstance().getLifelineWidth());
        Metrics.setFrameFontHeight(context.getFontHeight(Frame.getUserPref().getFont("PREF_FRAME_NAME")));
        Metrics.setLifelineHeaderFontHeight(context.getFontHeight(Frame.getUserPref().getFont("PREF_LIFELINE_HEADER")));
        int syncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS"));
        int syncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS_RET"));
        int asyncMessFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS"));
        int asyncMessRetFontH = context.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS_RET"));
        int messageFontHeight = 0;
        messageFontHeight = syncMessFontH > syncMessRetFontH ? syncMessFontH : syncMessRetFontH;
        if (messageFontHeight < asyncMessFontH) {
            messageFontHeight = asyncMessFontH;
        }
        if (messageFontHeight < asyncMessRetFontH) {
            messageFontHeight = asyncMessRetFontH;
        }
        Metrics.setMessageFontHeight(messageFontHeight);
        context.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        int width = Math.round((float)(this.frame.getWidth() + 20) * this.zoomValue);
        int height = Math.round((float)(this.frame.getHeight() + 20) * this.zoomValue);
        this.resizeContents(width, height);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.fillRectangle(0, 0, this.getContentsWidth(), 10);
        context.fillRectangle(0, 0, this.frame.getX(), this.getContentsHeight());
        context.fillRectangle(this.frame.getX() + this.frame.getWidth() + 1, 0, this.getContentsWidth() - (this.frame.getX() + this.frame.getWidth() + 1), this.getContentsHeight());
        context.fillRectangle(0, this.frame.getY() + this.frame.getHeight() + 1, this.getContentsWidth(), this.getContentsHeight() - (this.frame.getY() + this.frame.getHeight() + 1));
        gcim.setLineWidth(1);
        this.frame.draw(context);
        if (this.dragAndDrop instanceof Lifeline) {
            Lifeline node = (Lifeline)this.dragAndDrop;
            boolean isSelected = this.dragAndDrop.isSelected();
            node.setSelected(false);
            node.draw(context, this.dragX, this.dragY);
            node.setSelected(isSelected);
        }
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                gc.drawImage(dbuffer, 0, 0, area.width, area.height, 0, 0, area.width, area.height);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            gcim.dispose();
            dbuffer.dispose();
        }
        gc.dispose();
        context.dispose();
        this.setHScrollBarIncrement(Math.round((float)(SDViewPref.getInstance().getLifelineWidth() / 2) * this.zoomValue));
        this.setVScrollBarIncrement(Math.round((float)Metrics.getMessagesSpacing() * this.zoomValue));
        if (this.timeBar != null && this.frame.hasTimeInfo()) {
            this.timeBar.resizeContents(9, height + this.getHorizontalBarHeight());
            this.timeBar.setContentsPos(this.getContentsX(), this.getContentsY());
            this.timeBar.redraw();
            this.timeBar.update();
        }
        float xRatio = this.getContentsWidth() / this.getVisibleWidth();
        float yRatio = this.getContentsHeight() / this.getVisibleHeight();
        if (yRatio > xRatio) {
            this.setOverviewSize((int)((double)this.getVisibleHeight() * 0.75));
        } else {
            this.setOverviewSize((int)((double)this.getVisibleWidth() * 0.75));
        }
    }

    public GraphNode getMouseOverNode() {
        return this.currentGraphNode;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.zoomIn) {
            this.zoomValue *= 2.0f;
        } else if (event.widget == this.zoomOut) {
            this.zoomValue /= 2.0f;
        }
        this.redraw();
    }

    public void setZoomInMode(boolean value) {
        if (value) {
            this.setZoomOutMode(false);
        }
        this.zoomInMode = value;
    }

    public void setZoomOutMode(boolean value) {
        if (value) {
            this.setZoomInMode(false);
        }
        this.zoomOutMode = value;
    }

    public void moveTo(GraphNode node) {
        if (node == null) {
            return;
        }
        this.clearSelection();
        this.addSelection(node);
        this.ensureVisible(node);
    }

    public void ensureVisible(GraphNode node) {
        if (node == null) {
            return;
        }
        int x = Math.round((float)node.getX() * this.zoomValue);
        int y = Math.round((float)node.getY() * this.zoomValue);
        int width = Math.round((float)node.getWidth() * this.zoomValue);
        int height = Math.round((float)node.getHeight() * this.zoomValue);
        if (node instanceof BaseMessage && height == 0) {
            int header = 8 + Metrics.getLifelineHeaderFontHeigth();
            height = -Math.round((float)(Metrics.getMessagesSpacing() + header) * this.zoomValue);
            y += Math.round(10.0f * this.zoomValue);
        }
        if (node instanceof Lifeline) {
            y = this.getContentsY() + 30;
            height = this.getVisibleHeight() - 30;
        }
        this.ensureVisible(x, y, width, height, 0x1000000, true);
        this.redraw();
    }

    public float getZoomFactor() {
        return this.zoomValue;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getProperty().equals("PREFOK")) {
            if (this.overView != null) {
                this.overView.dispose();
            }
            this.overView = null;
            this.redraw();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.overView != null) {
            this.overView.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        if (this.currentCaretImage != null && !this.currentCaretImage.isDisposed()) {
            this.currentCaretImage.dispose();
        }
        if (this.arrowUpCaretImg != null && !this.arrowUpCaretImg.isDisposed()) {
            this.arrowUpCaretImg.dispose();
        }
        if (this.collapaseCaretImg != null && !this.collapaseCaretImg.isDisposed()) {
            this.collapaseCaretImg.dispose();
        }
        SDViewPref.getInstance().removePropertyChangeListener(this);
        LoadersManager lm = LoadersManager.getLoadersManager();
        if (this.site != null && this.site instanceof SDView) {
            ((SDView)this.site).resetProviders();
            if (lm != null) {
                lm.resetLoaders(((SDView)this.site).getViewSite().getId());
            }
        }
    }

    protected void drawOverview(GC gc, Rectangle r) {
        float oldzoom = this.zoomValue;
        this.zoomValue = this.getContentsWidth() > this.getContentsHeight() ? (float)r.width / (float)this.getContentsWidth() * oldzoom : (float)r.height / (float)this.getContentsHeight() * oldzoom;
        if (this.overView != null && (r.width != this.overView.getBounds().width || r.height != this.overView.getBounds().height)) {
            this.overView.dispose();
            this.overView = null;
        }
        if (this.overView == null) {
            int backX = this.getContentsX();
            int backY = this.getContentsY();
            this.setContentsPos(0, 0);
            this.overView = new Image((Device)this.getDisplay(), r.width, r.height);
            GC gcim = new GC((Drawable)this.overView);
            NGC context = new NGC(this, gcim);
            context.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
            this.frame.draw(context);
            this.setContentsPos(backX, backY);
            gcim.dispose();
            context.dispose();
        }
        if (this.overView != null && r.width == this.overView.getBounds().width && r.height == this.overView.getBounds().height) {
            gc.drawImage(this.overView, 0, 0, r.width, r.height, 0, 0, r.width, r.height);
        }
        this.zoomValue = oldzoom;
        super.drawOverview(gc, r);
    }

    public void deltaSelected(Lifeline lifeline, int startEvent, int nbEvent, IColor color) {
        this.frame.highlightTimeCompression(lifeline, startEvent, nbEvent, color);
        this.ensureVisible(lifeline);
        this.redraw();
        this.update();
    }

    public void resetZoomFactor() {
        int currentX = Math.round((float)this.getContentsX() / this.zoomValue);
        int currentY = Math.round((float)this.getContentsY() / this.zoomValue);
        this.zoomValue = 1.0f;
        if (this.timeBar != null && !this.timeBar.isDisposed()) {
            this.timeBar.setZoom(this.zoomValue);
        }
        this.redraw();
        this.update();
        this.setContentsPos(currentX, currentY);
    }

    public void setReorderMode(boolean mode) {
        this.reorderMode = mode;
    }

    public ArrayList getLifelineReoderList() {
        return this.reorderList;
    }

    private static class AutoScroll
    extends TimerTask {
        public int dx_;
        public int dy_;
        public SDWidget sv_;

        public AutoScroll(SDWidget _sv, int _dx, int _dy) {
            this.sv_ = _sv;
            this.dx_ = _dx;
            this.dy_ = _dy;
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ AutoScroll this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (this.this$0.sv_.isDisposed()) {
                        return;
                    }
                    this.this$0.sv_.dragX += this.this$0.dx_;
                    this.this$0.sv_.dragY += this.this$0.dy_;
                    this.this$0.sv_.scrollBy(this.this$0.dx_, this.this$0.dy_);
                }
            });
        }
    }
}

