/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.EventObject;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.ILabelAndDescriptionProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class ChooseElementComposite
extends Composite
implements IDisposable,
ISelectionProvider,
ISelectionChangedListener {
    private StructuredViewer structuredViewer = this.createStructuredViewer(this);
    private Label structuredViewerLabel;
    private Text descriptionText;
    private Label descriptionLabel;

    public ChooseElementComposite(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        WorkbenchHelp.setHelp((Control)this.structuredViewer.getControl(), (String)(HyadesUIPlugin.getID() + ".celt0002"));
    }

    public void dispose() {
        this.structuredViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
        if (!this.structuredViewer.getControl().isDisposed()) {
            this.structuredViewer.getControl().dispose();
        }
        if (!this.structuredViewerLabel.isDisposed()) {
            this.structuredViewerLabel.dispose();
        }
        if (!this.descriptionLabel.isDisposed()) {
            this.descriptionLabel.dispose();
        }
        if (!this.descriptionText.isDisposed()) {
            this.descriptionText.dispose();
        }
        this.descriptionText = null;
    }

    protected StructuredViewer createStructuredViewer(Composite parent) {
        return new TableViewer(parent, 2820);
    }

    public boolean setSelection(int index, boolean fireSelection) {
        if (this.structuredViewer.getControl() instanceof Table) {
            Table table = (Table)this.structuredViewer.getControl();
            table.select(index);
            if (fireSelection) {
                UIUtil.fireCurrentSelection(this.structuredViewer);
            }
            return true;
        }
        return false;
    }

    public void createContents(ILabelProvider labelProvider) {
        this.setLayout((Layout)new GridLayout());
        this.structuredViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.adjustStructuredViewer(this.structuredViewer);
        if (this.structuredViewer.getLabelProvider() instanceof ILabelAndDescriptionProvider) {
            this.descriptionText = this.createDescriptionText(this);
        }
    }

    protected void adjustStructuredViewer(StructuredViewer structuredViewer) {
        TableViewer tableViewer = (TableViewer)structuredViewer;
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TableLayout tableLayout = new TableLayout();
        Table table = tableViewer.getTable();
        table.setLayout((Layout)tableLayout);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        table.setLayoutData((Object)gridData);
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        ViewerSorter sorter = new ViewerSorter(){

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        };
        tableViewer.setSorter(sorter);
    }

    protected Text createDescriptionText(Composite parent) {
        Text text = new Text(parent, 2626);
        text.setLayoutData((Object)GridDataUtil.createFill());
        text.setEditable(false);
        WorkbenchHelp.setHelp((Control)text, (String)(HyadesUIPlugin.getID() + ".celt0001"));
        return text;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.structuredViewer.addDoubleClickListener(listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.structuredViewer.removeDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.structuredViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.structuredViewer.removeSelectionChangedListener(listener);
    }

    public void setDescriptionLabel(String string) {
        if (string == null) {
            if (this.descriptionLabel == null) {
                return;
            }
            string = "";
        }
        if (this.descriptionLabel == null) {
            this.descriptionLabel = new Label((Composite)this, 0);
            if (this.descriptionText != null) {
                this.descriptionLabel.moveAbove((Control)this.descriptionText);
                this.layout();
            }
        }
        this.descriptionLabel.setText(string);
        if (this.descriptionText != null) {
            this.descriptionLabel.pack();
        }
    }

    public String getDescriptionLabel() {
        if (this.descriptionLabel == null) {
            return null;
        }
        return this.descriptionLabel.getText();
    }

    public void setStructuredViewerLabel(String string) {
        if (string == null) {
            if (this.structuredViewerLabel == null) {
                return;
            }
            string = "";
        }
        if (this.structuredViewerLabel == null) {
            this.structuredViewerLabel = new Label((Composite)this, 0);
            this.structuredViewerLabel.moveAbove(this.structuredViewer.getControl());
            this.layout();
        }
        this.structuredViewerLabel.setText(string);
        this.structuredViewerLabel.pack();
    }

    public String getStructuredViewerLabel() {
        if (this.structuredViewerLabel == null) {
            return null;
        }
        return this.structuredViewerLabel.getText();
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.structuredViewer.setContentProvider(contentProvider);
    }

    public IContentProvider getContentProvider() {
        return this.structuredViewer.getContentProvider();
    }

    public ILabelProvider getLabelProvider() {
        return (ILabelProvider)this.structuredViewer.getLabelProvider();
    }

    public void setInput(Object[] input) {
        this.structuredViewer.setInput((Object)input);
    }

    public Object[] getInput() {
        return (Object[])this.structuredViewer.getInput();
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, false, false);
    }

    public void setSelection(ISelection selection, boolean reveal, boolean fireSelection) {
        this.structuredViewer.setSelection(selection, reveal);
        if (fireSelection) {
            UIUtil.fireCurrentSelection(this.structuredViewer);
        }
    }

    public ISelection getSelection() {
        return this.structuredViewer.getSelection();
    }

    public Control getControl() {
        return this.structuredViewer.getControl();
    }

    public boolean fired(EventObject eventObject) {
        if (eventObject == null) {
            return false;
        }
        return eventObject.getSource() == this.structuredViewer || eventObject.getSource() == this.getControl() || eventObject.getSource() == this;
    }

    public boolean fired(Event event) {
        if (event == null) {
            return false;
        }
        return event.widget == this.getControl() || event.widget == this;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.structuredViewer) {
            if (this.descriptionText == null) {
                return;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
            if (structuredSelection.size() == 0) {
                this.descriptionText.setText("");
            } else {
                String description = ((ILabelAndDescriptionProvider)this.getLabelProvider()).getDescription(structuredSelection.getFirstElement());
                if (description == null) {
                    description = "";
                }
                this.descriptionText.setText(description);
            }
        }
    }
}

