/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PartInitException;

public abstract class HyadesNewWizard
extends HyadesWizard
implements INewWizard,
Listener {
    protected static final String SET_LAST_SELECTION = "LAST_SELECTION";
    private LocationPage locationPage;
    private AttributeWizardPage attributeWizardPage;
    private boolean firstNameDescriptionPageActivation = true;
    private IFile newFile;

    public void dispose() {
        this.attributeWizardPage.removeActivationListener(this);
        super.dispose();
    }

    protected void initPages() {
        IStructuredSelection structuredSelection = this.adjustSeletion();
        this.locationPage = new LocationPage("location", structuredSelection);
        String fileExtension = this.getFileExtension();
        if (fileExtension != null) {
            this.locationPage.setFileExtension(fileExtension);
            this.locationPage.setFileName("");
        }
        this.attributeWizardPage = new AttributeWizardPage("nameDescription");
        this.attributeWizardPage.addActivationListener(this);
    }

    protected IStructuredSelection adjustSeletion() {
        IResource resource;
        String lastSelection;
        IStructuredSelection structuredSelection = this.getSelection();
        if (this.getDialogSettings() != null && (structuredSelection == null || structuredSelection.isEmpty()) && (lastSelection = this.getDialogSettings().get(SET_LAST_SELECTION)) != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(lastSelection)) != null && resource.exists()) {
            structuredSelection = new StructuredSelection((Object)resource);
        }
        return structuredSelection;
    }

    protected LocationPage getLocationPage() {
        return this.locationPage;
    }

    protected AttributeWizardPage getAttributeWizardPage() {
        return this.attributeWizardPage;
    }

    public void handleEvent(Event event) {
        if (event.type == 3 && event.data == this.getAttributeWizardPage() && this.firstNameDescriptionPageActivation) {
            this.firstNameDescriptionPageActivation = false;
            this.adjustAttributePage();
        }
    }

    protected void adjustAttributePage() {
        if (this.getAttributeWizardPage() == null || this.getLocationPage() == null) {
            return;
        }
        if (this.getAttributeWizardPage().getItemName() == null || "".equals(this.getAttributeWizardPage().getItemName())) {
            String name = this.getLocationPage().getFileName();
            if (name.endsWith("." + this.getFileExtension())) {
                name = name.substring(0, name.lastIndexOf(this.getFileExtension()) - 1);
            }
            this.getAttributeWizardPage().setItemName(name);
        }
    }

    public boolean performFinish() {
        this.adjustAttributePage();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = this.getLocationPage().getContainerFullPath();
        if (root.findMember(path) == null) {
            try {
                ResourceUtil.createContainer((IContainer)root.getFolder(path), null);
            }
            catch (CoreException e) {
                this.handleException(path.toString(), (Exception)((Object)e));
                return false;
            }
        }
        String fileName = this.getLocationPage().getFileName();
        String fileExtension = this.getLocationPage().getFileExtension();
        if (!fileName.endsWith("." + fileExtension)) {
            fileName = fileName + "." + fileExtension;
        }
        path = path.append(fileName);
        IFile file = root.getFile(path);
        try {
            if (!this.createObject(file)) {
                return false;
            }
        }
        catch (Exception e) {
            this.handleException(file.getFullPath().toString(), e);
            return false;
        }
        this.newFile = file;
        this.selectAndReveal((IResource)file);
        try {
            this.openEditor(file);
        }
        catch (PartInitException e) {
            this.handleException(file.getFullPath().toString(), (Exception)((Object)e));
        }
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        ResourceUtil.selectAndReveal(newResource, this.getWorkbench().getActiveWorkbenchWindow());
    }

    protected String getFileExtension() {
        return null;
    }

    protected void openEditor(IFile file) throws PartInitException {
        UIUtil.openEditor(file, null, false);
    }

    protected void handleException(String filePath, Exception exception) {
        HyadesUIPlugin.logError(exception);
        UIUtil.openSaveFileErrorDialog(this.getShell(), filePath, exception);
    }

    protected abstract boolean createObject(IFile var1) throws Exception;

    public IFile getNewFile() {
        return this.newFile;
    }

    protected void setAttributeWizardPage(AttributeWizardPage attributeWizardPage) {
        this.attributeWizardPage = attributeWizardPage;
    }

    protected void setLocationPage(LocationPage locationPage) {
        this.locationPage = locationPage;
    }
}

