/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseLifelineLoader;

public class ObjectInteractions
extends BaseLifelineLoader {
    public EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation mi) {
        if (mi.getOwningObject().getIsA() == mi.getProcess().getClassClass()) {
            return mi.getMethod().getDefiningClass();
        }
        return mi.getOwningObject();
    }

    public String getLifeLineTitle(EObject eo, boolean long_) {
        TRCClass cl;
        String owningObject = "";
        if (eo instanceof TRCTraceObject) {
            TRCTraceObject to = (TRCTraceObject)eo;
            cl = ((TRCTraceObject)eo).getIsA();
            owningObject = ":" + to.getId();
        } else {
            cl = (TRCClass)eo;
        }
        return cl.getName() + owningObject + (!long_ && cl.getPackage() != null ? " (" + cl.getPackage().getName() + ")" : "");
    }

    public String getLifeLineId(EObject eo) {
        TRCAgentProxy ap;
        if (eo instanceof TRCTraceObject) {
            TRCTraceObject to = (TRCTraceObject)eo;
            ap = ((TRCTraceObject)eo).getProcess().getAgent().getAgentProxy();
        } else {
            ap = ((TRCClass)eo).getPackage().getProcess().getAgent().getAgentProxy();
        }
        return ap.getRuntimeId() + "#" + this.getLifeLineTitle(eo, true);
    }

    public int getLifeLineCategory(EObject eo) {
        if (eo instanceof TRCClass) {
            return 0;
        }
        return 1;
    }

    public String getFinalTitleString() {
        return TraceSDPlugin.getResourceString("STR_UML2SD_OBJECT_INTERACTION");
    }
}

