/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBResource;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.InternalDatabase;
import org.eclipse.hyades.resources.database.internal.PagingList;
import org.eclipse.hyades.resources.database.internal.QueryFactory;
import org.eclipse.hyades.resources.database.internal.ReferenceQuery;

public class DynamicPagingListImpl
extends DelegatingEcoreEList.Dynamic
implements PagingList {
    protected int pagingSize;
    protected int first;
    protected InternalDatabase database;
    protected EObject[] objects;
    protected boolean loaded;
    protected boolean setReferences;
    protected int size;
    protected boolean modified;

    public DynamicPagingListImpl(InternalEObject owner, EStructuralFeature eStructuralFeature, DBResource resource, int pagingSize) {
        super(owner, eStructuralFeature);
        this.init(pagingSize);
        this.database = (InternalDatabase)resource.getDatabase();
    }

    public DynamicPagingListImpl(InternalEObject owner, EStructuralFeature eStructuralFeature, Database database, int pagingSize) {
        super(owner, eStructuralFeature);
        this.init(pagingSize);
        this.database = (InternalDatabase)database;
    }

    protected void init(int pagingSize) {
        this.pagingSize = pagingSize;
        this.first = -1;
        this.size = -1;
        this.loaded = false;
        this.setReferences = true;
        this.modified = false;
    }

    protected List delegateList() {
        return this;
    }

    public void set(Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void unset() {
        throw new UnsupportedOperationException();
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        throw new UnsupportedOperationException();
    }

    public NotificationChain basicAdd(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected boolean delegateContains(Object object) {
        if (!(object instanceof EObject)) {
            return false;
        }
        boolean result = false;
        InternalEObject eObject = (InternalEObject)object;
        if (this.isContainment()) {
            result = eObject.eContainer() == this.owner && (this.hasNavigableInverse() ? eObject.eContainerFeatureID() == this.getInverseFeatureID() : -1 - eObject.eContainerFeatureID() == this.getFeatureID());
        } else if (this.hasNavigableInverse() && !this.hasManyInverse()) {
            boolean bl = result = ((EObject)object).eGet((EStructuralFeature)this.getInverseEReference()) == this.owner;
        }
        if (result) {
            return result;
        }
        try {
            return this.getInternalDatabase().contains(this.getObject(), this.getReference(), (EObject)eObject);
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
    }

    protected Object delegateGet(int index) {
        if (!this.loaded || this.objects == null || index >= this.first + this.objects.length) {
            this.load(index);
        } else if (index < this.first) {
            int start = this.first - this.pagingSize;
            if (start < 0) {
                start = 0;
            } else if (index >= 0 && index < start) {
                start = index;
            }
            this.load(start);
        }
        if (this.objects[index - this.first] == null) {
            if (this.size() > index) {
                this.load(this.first);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
        return this.objects[index - this.first];
    }

    protected Iterator delegateIterator() {
        return new ArrayList().iterator();
    }

    protected boolean inDatabase() {
        DBResource resource = (DBResource)this.owner.eResource();
        if (resource == null) {
            return true;
        }
        return resource.isInDatabase();
    }

    protected void load(int index) {
        PerfUtil p = new PerfUtil("DynamicPagingListImpl.load() index=" + index, true);
        if (this.getInternalDatabase().isCaching()) {
            try {
                this.getInternalDatabase().forceUpdates();
            }
            catch (Exception e) {
                throw new DBCollectedExceptions(e);
            }
        }
        this.loaded = true;
        ReferenceQuery query = this.createReferenceQuery(index, index + this.pagingSize - 1);
        EObject[] referenced = this.getObjects(query);
        if (referenced == null) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < referenced.length) {
            this.addAdapter(referenced[i]);
            ++i;
        }
        this.first = index;
        if (this.objects == null) {
            this.objects = index == 0 && referenced.length < this.pagingSize ? new EObject[referenced.length] : new EObject[this.pagingSize];
        }
        System.arraycopy(referenced, 0, this.objects, 0, referenced.length);
        int i2 = referenced.length;
        while (i2 < this.objects.length) {
            this.objects[i2] = null;
            ++i2;
        }
        p.stopAndPrintStatus();
    }

    protected EObject[] getObjects(ReferenceQuery query) {
        EObject[] referenced = null;
        try {
            referenced = this.getInternalDatabase().getObjects(query);
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
        return referenced;
    }

    protected ReferenceQuery createReferenceQuery(int lower, int upper) {
        ReferenceQuery query = QueryFactory.INSTANCE.createReferenceQuery();
        query.setEObject(this.getObject());
        query.setEReference(this.getReference());
        query.setLower(lower);
        query.setUpper(upper);
        if (!this.setReferences) {
            query.setReferences(this.setReferences);
        }
        HashSet<EClass> notLoadedClasses = new HashSet<EClass>(1);
        notLoadedClasses.add(this.getReference().getEReferenceType());
        query.setNotLoadedClasses(notLoadedClasses);
        return query;
    }

    protected int delegateSize() {
        if (this.size == -1) {
            try {
                this.size = this.getInternalDatabase().count(this.getObject(), this.getReference());
                if (this.size == -1) {
                    this.size = 0;
                }
            }
            catch (Exception e) {
                throw new DBCollectedExceptions(e);
            }
        }
        return this.size;
    }

    public void setPagingSize(int value) {
        if (value == this.pagingSize) {
            return;
        }
        boolean increase = false;
        if (!this.loaded) {
            this.objects = new EObject[value];
        } else if (value < this.pagingSize) {
            EObject[] oldObjects = this.objects;
            this.objects = new EObject[value];
            System.arraycopy(oldObjects, 0, this.objects, 0, value);
        } else if (value > this.pagingSize) {
            increase = true;
        }
        this.pagingSize = value;
        if (this.loaded && increase) {
            this.objects = new EObject[value];
            this.load(this.first);
        }
    }

    public int getPagingSize() {
        return this.pagingSize;
    }

    public void setDatabase(Database database) {
        this.database = (InternalDatabase)database;
    }

    public Database getDatabase() {
        return this.getInternalDatabase();
    }

    public EObject getObject() {
        return this.owner;
    }

    public EReference getReference() {
        return (EReference)this.eStructuralFeature;
    }

    protected boolean delegateIsEmpty() {
        return this.size() == 0;
    }

    public void setReferences(boolean setReferences) {
        this.setReferences = setReferences;
    }

    protected void delegateAdd(Object object) {
        this.add(this.size(), object);
    }

    protected void delegateAdd(int index, Object element) {
        if (!this.loaded) {
            this.loaded = true;
            this.objects = new EObject[this.pagingSize];
        } else if (index >= this.first + this.objects.length && this.objects.length < this.pagingSize) {
            EObject[] newObjects = new EObject[this.pagingSize];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            this.objects = newObjects;
        }
        if (this.first == -1 || index >= this.first + this.objects.length) {
            this.first = index;
            this.objects[0] = (EObject)element;
            int i = 1;
            while (i < this.objects.length) {
                this.objects[i] = null;
                ++i;
            }
            ++this.size;
            this.modified = true;
        } else {
            if (index < this.first) {
                throw new UnsupportedOperationException();
            }
            if (this.objects[index - this.first] != null) {
                throw new UnsupportedOperationException();
            }
            this.objects[index - this.first] = (EObject)element;
            ++this.size;
            this.modified = true;
        }
    }

    protected Object[] delegateToArray() {
        if (this.objects != null && this.objects.length < this.pagingSize) {
            Object[] dbObjects = new Object[this.objects.length];
            System.arraycopy(this.objects, 0, dbObjects, 0, this.objects.length);
            return dbObjects;
        }
        if (this.size() == 0) {
            return new Object[0];
        }
        ReferenceQuery query = this.createReferenceQuery(0, -1);
        Object[] dbObjects = this.getObjects(query);
        if (this.objects == null && dbObjects.length < this.pagingSize) {
            this.loaded = true;
            this.first = 0;
            this.objects = new EObject[dbObjects.length];
            System.arraycopy(dbObjects, 0, this.objects, 0, dbObjects.length);
            this.size = dbObjects.length;
        }
        return dbObjects;
    }

    protected Object[] delegateToArray(Object[] array) {
        EObject[] dbObjects = null;
        if (this.objects != null && this.objects.length < this.pagingSize) {
            dbObjects = this.objects;
        }
        if (dbObjects == null) {
            if (this.size() == 0) {
                dbObjects = new EObject[]{};
            } else {
                ReferenceQuery query = this.createReferenceQuery(0, -1);
                dbObjects = this.getObjects(query);
            }
        }
        if (array.length < dbObjects.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), dbObjects.length);
        }
        System.arraycopy(dbObjects, 0, array, 0, dbObjects.length);
        if (array.length > dbObjects.length) {
            array[dbObjects.length] = null;
        }
        if (this.objects == null && dbObjects.length < this.pagingSize) {
            this.loaded = true;
            this.first = 0;
            this.objects = new EObject[dbObjects.length];
            System.arraycopy(dbObjects, 0, this.objects, 0, dbObjects.length);
            this.size = dbObjects.length;
        }
        return array;
    }

    protected int delegateIndexOf(Object element) {
        if (!(element instanceof EObject)) {
            return -1;
        }
        EObject eObject = (EObject)element;
        try {
            return this.getInternalDatabase().indexOf(this.getObject(), this.getReference(), eObject);
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
    }

    protected int delegateLastIndexOf(Object element) {
        if (!(element instanceof EObject)) {
            return -1;
        }
        EObject eObject = (EObject)element;
        try {
            return this.getInternalDatabase().lastIndexOf(this.getObject(), this.getReference(), eObject);
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
    }

    protected InternalDatabase getInternalDatabase() {
        if (this.database.isCaching()) {
            try {
                this.database.forceUpdates();
            }
            catch (Exception e) {
                throw new DBCollectedExceptions(e);
            }
        }
        return this.database;
    }

    protected void addAdapter(EObject object) {
        if (object == null) {
            return;
        }
        DBResource resource = (DBResource)object.eResource();
        if (resource == null) {
            return;
        }
        EContentAdapter contentAdapter = resource.getContentAdapter();
        if (contentAdapter == null) {
            return;
        }
        if (!object.eAdapters().contains((Object)contentAdapter)) {
            object.eAdapters().add((Object)contentAdapter);
        }
    }

    protected void delegateClear() {
        this.init(this.pagingSize);
    }

    protected Object delegateRemove(int index) {
        throw new UnsupportedOperationException();
    }

    protected Object delegateSet(int index, Object object) {
        throw new UnsupportedOperationException();
    }
}

