/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public class IndexStatement
extends SQLStatement {
    protected EClass eClass;

    public IndexStatement(DatabaseType dbType, DBMap map, EClass eClass) {
        super(dbType, map);
        this.eClass = eClass;
    }

    public String getStatement() {
        if (this.statement.length() != 0) {
            return this.statement.toString();
        }
        DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)this.eClass);
        Table table = data.getTable();
        String indexName = this.getIndexName();
        String columnName = this.getColumnName();
        this.statement.append("CREATE INDEX ");
        this.statement.append(this.addQuotes(indexName));
        this.statement.append(" ON ");
        this.statement.append(this.addQuotes(table.getName()));
        this.statement.append(" (");
        this.statement.append(this.addQuotes(columnName));
        this.statement.append(")");
        return this.statement.toString();
    }

    protected String getIndexName() {
        EAttribute attribute = this.eClass.getEIDAttribute();
        DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)attribute);
        EList constraints = data.getValueColumn().getConstraints();
        int i = 0;
        int l = constraints.size();
        while (i < l) {
            Constraint constraint = (Constraint)constraints.get(i);
            if (constraint.getType().equals("INDEX")) {
                return constraint.getName();
            }
            ++i;
        }
        return null;
    }

    protected String getColumnName() {
        EAttribute attribute = this.eClass.getEIDAttribute();
        DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)attribute);
        return data.getValueColumn().getName();
    }
}

