/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public class InsertStatement
extends SQLStatement {
    protected Table table;
    protected List columns;
    protected String[] statements;
    protected Map objectsToIds;
    protected String header;
    protected List statementList;
    protected boolean rowAdded;

    public InsertStatement(DBMap map, DatabaseType dbType, Map objectsToIds) {
        super(dbType, map);
        this.objectsToIds = objectsToIds;
        this.table = null;
        this.columns = null;
        this.rowAdded = false;
    }

    public InsertStatement(DatabaseType dbType, Table table, List columns) {
        super(dbType, null);
        this.table = table;
        this.columns = columns;
    }

    public String getStatement() {
        this.statement = new StringBuffer();
        this.statement.append("INSERT INTO ");
        this.statement.append(this.addQuotes(this.table.getName()));
        this.statement.append(" (");
        int i = 0;
        int l = this.columns.size();
        while (i < l) {
            Column column = (Column)this.columns.get(i);
            if (i != 0) {
                this.statement.append(", ");
            }
            this.statement.append(this.addQuotes(column.getName()));
            ++i;
        }
        this.statement.append(")");
        this.statement.append("  VALUES (");
        int i2 = 0;
        int l2 = this.columns.size();
        while (i2 < l2) {
            if (i2 != 0) {
                this.statement.append(", ");
            }
            this.statement.append("?");
            ++i2;
        }
        this.statement.append(")");
        return this.statement.toString();
    }

    public String getStatement(List objects) throws Exception {
        if (this.header == null) {
            this.header = this.createHeader();
        }
        this.statement = new StringBuffer();
        this.statement.append(this.header);
        int i = 0;
        int l = objects.size();
        while (i < l) {
            this.createRows((EObject)objects.get(i), i == 0);
            ++i;
        }
        if (this.statementList != null) {
            this.statementList.add(this.statement.toString());
            this.statements = this.statementList.toArray(new String[this.statementList.size()]);
        }
        if (this.rowAdded) {
            if (this.statements == null) {
                return this.statement.toString();
            }
            return null;
        }
        this.statements = new String[0];
        return null;
    }

    protected void createRows(EObject object, boolean first) throws Exception {
        StringBuffer row = this.createRow(object);
        if (row != null) {
            this.addRowToStatement(row, first);
        }
    }

    protected void addRowToStatement(StringBuffer row, boolean first) {
        this.rowAdded = true;
        if (this.statementTooLong(row)) {
            this.processLongStatement(row);
        } else {
            if (!first) {
                this.statement.append(", ");
            }
            this.statement.append(row);
        }
    }

    protected void processLongStatement(StringBuffer row) {
        if (this.statementList == null) {
            this.statementList = new ArrayList();
        }
        this.statementList.add(this.statement.toString());
        this.statement = new StringBuffer();
        this.statement.append(this.header);
        this.statement.append(row);
    }

    protected String createHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ");
        buffer.append(this.addQuotes(this.getTable().getName()));
        buffer.append(" (");
        List columns = this.getColumns();
        int i = 0;
        int l = columns.size();
        while (i < l) {
            Column column = (Column)columns.get(i);
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.addQuotes(column.getName()));
            ++i;
        }
        buffer.append(") VALUES ");
        return buffer.toString();
    }

    protected String createParameterMarkers() {
        StringBuffer buffer = new StringBuffer();
        List columns = this.getColumns();
        buffer.append('(');
        int i = 0;
        int l = columns.size();
        while (i < l) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append('?');
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected Table getTable() {
        return this.table;
    }

    protected List getColumns() {
        return this.columns;
    }

    protected StringBuffer createRow(EObject object) throws Exception {
        return null;
    }

    protected boolean statementTooLong(StringBuffer row) {
        return this.statement.length() + row.length() > this.dbType.getMaximumSQLLength();
    }

    public String[] getStatements() {
        return this.statements;
    }

    protected void appendValue(StringBuffer buffer, Object value, int sqlType) {
        if (value == null) {
            buffer.append("NULL");
        } else if (sqlType == 1 || sqlType == 12 || sqlType == -1) {
            buffer.append("'");
            String valueString = value.toString();
            int i = 0;
            int l = valueString.length();
            while (i < l) {
                char c = valueString.charAt(i);
                if (c == '\'') {
                    buffer.append("''");
                } else {
                    buffer.append(c);
                }
                ++i;
            }
            buffer.append("'");
        } else {
            buffer.append(value.toString());
        }
    }

    protected void appendBatchedValue(PreparedStatement ps, int colPos, Object value, int sqlType) throws Exception {
        if (value == null) {
            ps.setNull(colPos, sqlType);
            if (this.debugPreparedStatement) {
                this.statement.append(',');
                this.statement.append("NULL");
            }
        } else if (sqlType == 1 || sqlType == 12 || sqlType == -1) {
            String valueString = value.toString();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            int l = valueString.length();
            while (i < l) {
                char c = valueString.charAt(i);
                if (c == '\'') {
                    buffer.append("''");
                } else {
                    buffer.append(c);
                }
                ++i;
            }
            ps.setString(colPos, buffer.toString());
            if (this.debugPreparedStatement) {
                this.statement.append(',');
                this.statement.append(buffer.toString());
            }
        } else if (sqlType == 4) {
            ps.setInt(colPos, (Integer)value);
            if (this.debugPreparedStatement) {
                this.statement.append(',');
                this.statement.append(value);
            }
        } else if (sqlType == 8) {
            ps.setDouble(colPos, (Double)value);
            if (this.debugPreparedStatement) {
                this.statement.append(',');
                this.statement.append(value);
            }
        } else if (sqlType == 5) {
            ps.setShort(colPos, (Short)value);
            if (this.debugPreparedStatement) {
                this.statement.append(',');
                this.statement.append(value);
            }
        } else {
            ps.setObject(colPos, value);
            if (this.debugPreparedStatement) {
                this.statement.append(',');
                this.statement.append(value);
            }
        }
    }

    public PreparedStatement getPreparedStatement(JDBCHelper helper, List objects) throws Exception {
        if (this.header == null) {
            this.header = this.createHeader();
        }
        this.statement.setLength(0);
        this.statement.append(this.header);
        this.statement.append(this.createParameterMarkers());
        if (this.statementList == null) {
            this.statementList = new ArrayList();
        } else {
            this.statementList.clear();
        }
        this.statementList.add(this.statement.toString());
        PreparedStatement ps = helper.createPreparedStatement(this.statement.toString());
        PerfUtil p = new PerfUtil("InsertStatement.getPreparedStatement() sql=" + this.statement.toString() + ", size=" + objects.size(), true);
        int i = 0;
        while (i < objects.size()) {
            if (this.debugPreparedStatement) {
                this.statement.setLength(0);
            }
            this.addBatchedRows(ps, (EObject)objects.get(i));
            if (this.debugPreparedStatement) {
                this.statementList.add(this.statement.toString());
            }
            ++i;
        }
        p.stopAndPrintStatus();
        this.statements = this.statementList.toArray(new String[this.statementList.size()]);
        return ps;
    }

    protected void addBatchedRow(PreparedStatement ps, EObject object) throws Exception {
    }

    protected void addBatchedRows(PreparedStatement ps, EObject object) throws Exception {
        this.addBatchedRow(ps, object);
    }
}

