/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.IndirectedList;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;
import org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class TimeBasedCorrelationCommand
extends DBCommand {
    private TimeBasedCorrelationQuery query;
    private ResourceSet resourceSet;
    private WeakObjectCache cache;
    private Collection notLoadedClasses;
    private int correlationContainerID = -1;

    public TimeBasedCorrelationCommand(JDBCHelper helper, DBMap map, TimeBasedCorrelationQuery query, ResourceSet targetResourceSet, WeakObjectCache cache, Collection notLoadedClasses) {
        super(helper, map);
        this.query = query;
        this.resourceSet = this.resourceSet;
        this.cache = cache;
        this.notLoadedClasses = notLoadedClasses;
    }

    public Object execute() throws Exception {
        String s2;
        QueryResult queryResult = ExtensionsFactory.eINSTANCE.createQueryResult();
        queryResult.setQuery((Query)this.query);
        PerfUtil p = new PerfUtil("TimeBasedCorrelationCommand.execute()", false);
        if (this.query.getOutputElements().size() == 0) {
            List sts = this.createCorrelation();
            try {
                Iterator iter = sts.iterator();
                while (iter.hasNext()) {
                    String s2 = (String)iter.next();
                    p.setMessageAndStart("TimeBasedCorrelationCommand.execute() 1 statement=" + s2);
                    this.helper.executeUpdateStatement(s2);
                    p.stopAndPrintStatus();
                }
                this.helper.executeUpdateStatement("UPDATE Id_Table SET id = (NEXTVAL FOR id_sequence)");
                this.helper.commitTransaction();
            }
            catch (Exception e) {
                this.helper.rollbackTransaction();
                throw e;
            }
            return queryResult;
        }
        if (this.query.getOutputElements().size() == 1 && ((LeftOperand)this.query.getOutputElements().get(0)).getType() == CBEPackage.eINSTANCE.getCBECommonBaseEvent()) {
            s2 = this.getCorrelatedCBECommonBaseEvents();
        } else if (this.query.getOutputElements().size() == 2 && ((LeftOperand)this.query.getOutputElements().get(0)).getFeature() == HierarchyPackage.eINSTANCE.getCorrelationEntry_Value()) {
            s2 = this.getInboundCorrelationEntries();
            ((LeftOperand)this.query.getOutputElements().get(0)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
            ((LeftOperand)this.query.getOutputElements().get(0)).setFeature(null);
            ((LeftOperand)this.query.getOutputElements().get(1)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
            ((LeftOperand)this.query.getOutputElements().get(1)).setFeature(null);
        } else if (this.query.getOutputElements().size() == 2 && ((LeftOperand)this.query.getOutputElements().get(0)).getFeature() == HierarchyPackage.eINSTANCE.getCorrelationEntry_Key()) {
            s2 = this.getOutboundCorrelationEntries();
            ((LeftOperand)this.query.getOutputElements().get(0)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
            ((LeftOperand)this.query.getOutputElements().get(0)).setFeature(null);
            ((LeftOperand)this.query.getOutputElements().get(1)).setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
            ((LeftOperand)this.query.getOutputElements().get(1)).setFeature(null);
        } else {
            throw new IllegalArgumentException("Illegal arguments in query " + this.query);
        }
        Statement st = this.helper.createStatement(1004, 1007);
        p.setMessageAndStart("TimeBasedCorrelationCommand.execute() 2 statement=" + s2);
        this.helper.executeQuery(st, s2);
        p.stopAndPrintStatus();
        ResultSet rs = st.getResultSet();
        int i = 0;
        while (i < this.query.getOutputElements().size()) {
            Object objects;
            if (this.query.isCount() || ((LeftOperand)this.query.getOutputElements().get(i)).isCount()) {
                objects = new BasicEList();
                rs.absolute(1);
                Integer id = new Integer(rs.getInt(i + 1));
                objects.add((Object)id);
            } else {
                objects = new IndirectedList(this.helper, this.dbMap, this.cache, (Query)this.query, s2, this.resourceSet, this.notLoadedClasses, rs, i);
            }
            ResultEntry resultEntry = ExtensionsFactory.eINSTANCE.createResultEntry();
            resultEntry.setObjects((EList)objects);
            queryResult.getResultEntries().add((Object)resultEntry);
            ++i;
        }
        return queryResult;
    }

    protected String getCorrelatedCBECommonBaseEvents() {
        SimpleSearchQueryStatement st = new SimpleSearchQueryStatement(this.helper, this.dbMap, (SimpleSearchQuery)this.query){

            protected void processOutputElementsInSelectFrom() {
                this.statement.append("SELECT DISTINCT CBECommonBaseEvent.id, CBECommonBaseEvent.creationTime+P.deltaTime AS ct");
                this.first = false;
                this.all = false;
                this.processedAlready.add(this.getOperandType((LeftOperand)this.query.getOutputElements().get(0)));
                super.processOutputElementsInSelectFrom();
            }

            protected void processFromSet() {
                this.statement.append(" FROM CBECommonBaseEvent,CorrelationEntry AS K,CorrelationEntry_value AS V, Correlation_Params AS P");
                this.processedAlready.add("CBECommonBaseEvent");
                this.first = false;
                super.processFromSet();
            }

            protected void processBinaryExpressions() {
                this.statement.append(" WHERE K.correlationContainer=" + TimeBasedCorrelationCommand.this.getCorrelationContainerID() + " AND K.id = V.Source_Id AND (CBECommonBaseEvent.id = K.key OR CBECommonBaseEvent.id = V.Target_Id ) AND CBECommonBaseEvent.p_p=P.agentPath AND P.correlationContainer=" + TimeBasedCorrelationCommand.this.getCorrelationContainerID());
                this.first = false;
                super.processBinaryExpressions();
            }

            protected void processOrderByExpressionsInOrderByClause() {
                this.statement.append(" ORDER BY ct");
                this.first = false;
                super.processOrderByExpressionsInOrderByClause();
            }

            protected void appendWhereClauseForSources() {
            }
        };
        return ((SQLStatement)st).getStatement();
    }

    protected int getCorrelationContainerID() {
        if (this.correlationContainerID == -1) {
            DBCommand command = DBCommandFactory.INSTANCE.createGetIdByURICommand(this.helper, this.dbMap, this.query.getCorrelationContainerURI());
            try {
                this.correlationContainerID = (Integer)command.execute();
            }
            catch (Exception e) {
                throw new DBCollectedExceptions(e);
            }
        }
        return this.correlationContainerID;
    }

    protected String getInboundCorrelationEntries() {
        SimpleSearchQueryStatement st = new SimpleSearchQueryStatement(this.helper, this.dbMap, (SimpleSearchQuery)this.query){

            protected void processOutputElementsInSelectFrom() {
                this.statement.append("SELECT C2.id,C1.id");
                this.first = false;
                this.all = false;
                this.processedAlready.add(this.getOperandType((LeftOperand)this.query.getOutputElements().get(0)));
                this.processedAlready.add(this.getOperandType((LeftOperand)this.query.getOutputElements().get(1)));
                super.processOutputElementsInSelectFrom();
            }

            protected void processFromSet() {
                this.statement.append(" FROM CBECommonBaseEvent AS C1,CBECommonBaseEvent AS C2,CorrelationEntry AS K,CorrelationEntry_value AS V, Correlation_Params AS P");
                this.processedAlready.add("CBECommonBaseEvent");
                this.first = false;
                super.processFromSet();
            }

            protected void processBinaryExpressions() {
                this.statement.append(" WHERE K.correlationContainer=" + TimeBasedCorrelationCommand.this.getCorrelationContainerID() + " AND K.id = V.Source_Id AND C1.id = K.key AND C2.id = V.Target_Id AND P.correlationContainer=" + TimeBasedCorrelationCommand.this.getCorrelationContainerID() + " AND C2.p_p=P.agentPath");
                this.first = false;
                super.processBinaryExpressions();
            }

            protected void processOrderByExpressionsInOrderByClause() {
                this.statement.append(" ORDER BY C2.creationTime+P.deltaTime");
                this.first = false;
                super.processOrderByExpressionsInOrderByClause();
            }

            protected void appendWhereClauseForSources() {
            }
        };
        return ((SQLStatement)st).getStatement();
    }

    protected String getOutboundCorrelationEntries() {
        SimpleSearchQueryStatement st = new SimpleSearchQueryStatement(this.helper, this.dbMap, (SimpleSearchQuery)this.query){

            protected void processOutputElementsInSelectFrom() {
                this.statement.append("SELECT C1.id,C2.id");
                this.first = false;
                this.all = false;
                this.processedAlready.add(this.getOperandType((LeftOperand)this.query.getOutputElements().get(0)));
                this.processedAlready.add(this.getOperandType((LeftOperand)this.query.getOutputElements().get(1)));
                super.processOutputElementsInSelectFrom();
            }

            protected void processFromSet() {
                this.statement.append(" FROM CBECommonBaseEvent AS C1,CBECommonBaseEvent AS C2,CorrelationEntry AS K,CorrelationEntry_value AS V, Correlation_Params AS P");
                this.processedAlready.add("CBECommonBaseEvent");
                this.first = false;
                super.processFromSet();
            }

            protected void processBinaryExpressions() {
                this.statement.append(" WHERE K.correlationContainer=" + TimeBasedCorrelationCommand.this.getCorrelationContainerID() + " AND K.id = V.Source_Id AND C1.id = K.key AND C2.id = V.Target_Id AND P.correlationContainer=" + TimeBasedCorrelationCommand.this.getCorrelationContainerID() + " AND C1.p_p=P.agentPath");
                this.first = false;
                super.processBinaryExpressions();
            }

            protected void processOrderByExpressionsInOrderByClause() {
                this.statement.append(" ORDER BY C1.creationTime+P.deltaTime");
                this.first = false;
                super.processOrderByExpressionsInOrderByClause();
            }

            protected void appendWhereClauseForSources() {
            }
        };
        return ((SQLStatement)st).getStatement();
    }

    protected List createCorrelation() {
        StringBuffer statement = new StringBuffer();
        ArrayList<String> statements = new ArrayList<String>();
        String containerURI = this.query.getCorrelationContainerURI();
        this.updateCorrelationContainer();
        statement.append("ALTER SEQUENCE id_sequence RESTART WITH " + (this.getCorrelationContainerID() + 1));
        statements.add(statement.toString());
        statement.setLength(0);
        statement.append("INSERT INTO ");
        statement.append("RESOURCE_TABLE VALUES (");
        statement.append("'" + this.getContainerResourceURI(containerURI) + "'");
        statement.append(",'CorrelationContainer'," + this.getCorrelationContainerID() + ")");
        statements.add(statement.toString());
        statement.setLength(0);
        statement.append("INSERT INTO CORRELATIONCONTAINER VALUES ('/'," + this.getCorrelationContainerID() + ",0,'0')");
        statements.add(statement.toString());
        statement.setLength(0);
        this.appendInsertParams(statement);
        statements.add(statement.toString());
        statement.setLength(0);
        statement.append("INSERT INTO Correlation_Temp SELECT " + this.getCorrelationContainerID() + ",id, creationTime+B.deltaTime AS ct FROM CBECommonBaseEvent AS A, Correlation_Params AS B WHERE A.p_p=B.agentPath AND B.correlationContainer=" + this.getCorrelationContainerID());
        statements.add(statement.toString());
        statement.setLength(0);
        statement.append("INSERT INTO CorrelationEntry (p_p,id,correlationContainer,key) ");
        statement.append(" SELECT '" + this.getCorrelationContainerID() + "/', NEXTVAL FOR id_sequence," + this.getCorrelationContainerID() + ",A.Id FROM (select distinct S.objId as id from Correlation_Temp AS S, Correlation_Temp AS T WHERE S.correlationContainer=" + this.getCorrelationContainerID() + " and T.correlationContainer=" + this.getCorrelationContainerID() + " and S.objId<T.objId AND S.creationTime=T.creationTime) as A");
        statements.add(statement.toString());
        statement.setLength(0);
        statement.append("INSERT INTO CorrelationEntry_Value (Source_Id,Target_Id)");
        statement.append(" SELECT CE.id,idT FROM CorrelationEntry as CE,(select distinct S.objId as idS, T.objId as idT from Correlation_Temp AS S, Correlation_Temp AS T WHERE S.correlationContainer=" + this.getCorrelationContainerID() + " and T.correlationContainer=" + this.getCorrelationContainerID() + " and S.objId<T.objId AND S.creationTime=T.creationTime) as A where CE.key=A.idS and CE.correlationContainer=" + this.getCorrelationContainerID());
        statements.add(statement.toString());
        statement.setLength(0);
        statement.append("DELETE FROM Correlation_Temp WHERE correlationContainer=" + this.getCorrelationContainerID());
        statements.add(statement.toString());
        statement.setLength(0);
        return statements;
    }

    private String getContainerResourceURI(String uri) {
        int i = uri.indexOf(35);
        if (i != -1) {
            uri = uri.substring(0, i);
        }
        return uri;
    }

    private void updateCorrelationContainer() {
        try {
            DBCommand command = DBCommandFactory.INSTANCE.createGetLargestDatabaseId(this.helper, this.dbMap);
            Integer id = (Integer)command.execute();
            this.correlationContainerID = id == null ? -1 : id;
        }
        catch (Exception e) {
            new DBCollectedExceptions(e);
        }
    }

    protected void appendInsertParams(StringBuffer statement) {
        boolean first = true;
        int i = 0;
        while (i < this.query.getSources().size()) {
            String element = (String)this.query.getSources().get(i);
            String currentAgentPath = this.getObjectCompressedURIFragment(element);
            double currentDeltaTime = this.getDeltaTime(i);
            if (first) {
                statement.append("INSERT INTO Correlation_Params VALUES ");
                first = false;
            } else {
                statement.append(',');
            }
            statement.append("(" + this.getCorrelationContainerID() + ",'" + currentAgentPath + "'," + currentDeltaTime + ")");
            ++i;
        }
    }

    private double getDeltaTime(int i) {
        if (this.query.getDeltaTime().size() > i) {
            return (Double)this.query.getDeltaTime().get(i);
        }
        return 0.0;
    }

    protected String getObjectCompressedURIFragment(String source) {
        DBCommand command = DBCommandFactory.INSTANCE.createGetCommpressedPathByURICommand(this.helper, this.dbMap, source);
        String s = "";
        try {
            s = (String)command.execute();
        }
        catch (Exception e) {
            new DBCollectedExceptions(e);
        }
        return s;
    }
}

