/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TypeConverter {
    protected static final boolean debug = false;
    public static final String TRUE_VALUE = "T";
    public static final String FALSE_VALUE = "F";

    public void setValue(EObject object, EAttribute attr, EFactory factory, String value) {
        this.setValue(object, attr, factory, value, false);
    }

    public void setValue(EObject object, EAttribute attr, EFactory factory, String value, boolean many) {
        block6: {
            if (value == null) {
                return;
            }
            if (TypeConverter.isBooleanType(attr)) {
                this.setBooleanValue(object, attr, value, many);
            } else {
                Object objectValue = null;
                try {
                    objectValue = factory.createFromString(attr.getEAttributeType(), value);
                    if (!many) {
                        object.eSet((EStructuralFeature)attr, objectValue);
                        break block6;
                    }
                    ((List)object.eGet((EStructuralFeature)attr)).add(objectValue);
                }
                catch (Exception e) {}
            }
        }
    }

    protected void setBooleanValue(EObject object, EAttribute attribute, String value, boolean many) {
        if (TRUE_VALUE.equals(value)) {
            if (!many) {
                object.eSet((EStructuralFeature)attribute, (Object)Boolean.TRUE);
            } else {
                ((List)object.eGet((EStructuralFeature)attribute)).add(Boolean.TRUE);
            }
        } else if (!many) {
            object.eSet((EStructuralFeature)attribute, (Object)Boolean.FALSE);
        } else {
            ((List)object.eGet((EStructuralFeature)attribute)).add(Boolean.FALSE);
        }
    }

    public Object getValue(EObject object, EAttribute attribute) throws Exception {
        if (!object.eIsSet((EStructuralFeature)attribute)) {
            return null;
        }
        Object value = object.eGet((EStructuralFeature)attribute);
        if (TypeConverter.isBooleanType(attribute)) {
            if (value == Boolean.TRUE) {
                return TRUE_VALUE;
            }
            return FALSE_VALUE;
        }
        return value;
    }

    public static boolean isBooleanType(EAttribute attribute) {
        EDataType type = attribute.getEAttributeType();
        int id = type.getClassifierID();
        return id == 20 || id == 21;
    }
}

