/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.common.internal;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.common.internal.CommonClickListener;
import org.eclipse.hyades.perfmon.common.internal.CommonModifierProxy;
import org.eclipse.hyades.perfmon.utils.internal.AgentUpdater;
import org.eclipse.hyades.perfmon.utils.internal.DCAgentGenericLoader;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;
import org.eclipse.hyades.perfmon.utils.internal.StatConImageApplier;
import org.eclipse.hyades.perfmon.utils.internal.TRCAgentUtil;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.AgentChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ClickListener;
import org.eclipse.hyades.statistical.ui.editor.internal.DynamicAction;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class CommonModuleTrace
implements Runnable,
AgentChangeListener {
    static int ID_POSTFIX = 0;
    static Object ID_LOCK = new Object();
    int TRCID;
    ImageManager img = PerfmonPlugin.img;
    protected StatConInterface statcon;
    IProgressMonitor pmonitor;
    String ACTION_STOP_TRACE = "ACTION_STOP_TRACE_ID";
    String ACTION_UPDATE_TREE = "ACTION_UPDATE_TREE_ID";
    String ACTION_START_TRACING = "ACTION_START_TRACING_ID";
    String ACTION_STOP_TRACING = "ACTION_STOP_TRACING_ID";
    ClickListener click_listener;
    String tracename;
    SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
    boolean new_monitor = true;
    protected TRCAgent agent;
    DCAgentGenericLoader loader;
    CommonModifierProxy cmodproxy;
    AgentUpdater agentupdate;
    URI smodelpath;
    URI monitor_uri;
    String rachost;
    private Init init;

    public void unloadTrace() {
        try {
            this.cmodproxy.shutdown();
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.warning("failed to shut down Common Modifier Proxy");
        }
        try {
            this.agentupdate.shutdown();
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.warning("failed to shut down Agent updater");
        }
        try {
            this.loader.shutdown();
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.warning("failed to shut down Perfmon loader");
        }
        try {
            this.statcon.setConstantUpdate("PERFMON UPDATE " + this.loader.hashCode(), false, 1000L);
            this.statcon.setAgentImage(this.agent, this.img.getImage("trace_stop.gif"));
            this.statcon.removeDynamicAction(this.ACTION_STOP_TRACE + this.TRCID);
            this.statcon.removeDynamicAction(this.ACTION_UPDATE_TREE + this.TRCID);
            this.statcon.removeDynamicAction(this.ACTION_START_TRACING + this.TRCID);
            this.statcon.removeDynamicAction(this.ACTION_STOP_TRACING + this.TRCID);
            this.statcon.removeClickListener(this.click_listener);
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.warning("failed to remove stuff from statcon");
        }
        this.statcon.removeAgentChangeListener((AgentChangeListener)this);
    }

    public void agentAdded(TRCAgent dead_agent) {
    }

    public void agentRemoved(TRCAgent dead_agent) {
        if (this.agent == dead_agent) {
            this.unloadTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonModuleTrace() {
        Object object = ID_LOCK;
        synchronized (object) {
            this.TRCID = ID_POSTFIX++;
        }
    }

    protected void init(StatConInterface statcon, String rac_host, String process_exe, String trace_prefix, String trace_postfix, String agent_name, SetVariableCommand[] reg_commands, URI smodelpath, URI monitor_uri) {
        this.statcon = statcon;
        this.smodelpath = smodelpath;
        this.monitor_uri = monitor_uri;
        this.rachost = rac_host;
        this.init = new Init(rac_host, process_exe, trace_prefix, trace_postfix, agent_name, reg_commands);
    }

    public void setProgressMonitor(IProgressMonitor pmonitor) {
        this.pmonitor = pmonitor;
    }

    public void run() {
        this.init.run();
    }

    protected String getStatModelFileName() {
        return this.tracename;
    }

    private void removeRepresentations(SDDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        if (descriptor instanceof SDMemberDescriptor) {
            SDMemberDescriptor mem = (SDMemberDescriptor)descriptor;
            mem.setRepresentation(null);
            EList obslist = mem.getSnapshotObservation();
            int i = 0;
            while (i < obslist.size()) {
                SDSnapshotObservation obs = (SDSnapshotObservation)obslist.get(i);
                if (obs.getWindow() == null) {
                    PerfmonPlugin.DBG.warning("NULL OBSERVATION WINDOW UNDER " + descriptor.getName() + " (" + descriptor.getDescription() + ")");
                }
                ++i;
            }
        }
        EList list = descriptor.getChildren();
        int i = 0;
        while (i < list.size()) {
            this.removeRepresentations((SDDescriptor)list.get(i));
            ++i;
        }
    }

    private void configureSliders() throws Exception {
        double ctime;
        TimeZoomSlider xslider = this.statcon.getGraphWindow().getXSlider(0);
        double minvis = xslider.getMinVisible();
        double maxvis = xslider.getMaxVisible();
        double min = xslider.getMinLimit();
        double max = xslider.getMaxLimit();
        minvis = ctime = (double)System.currentTimeMillis();
        maxvis = ctime + 60000.0;
        min = Math.min(min, ctime - 3600000.0);
        max = Math.max(max, ctime + 8.64E7);
        xslider.configure(min, max, minvis, maxvis, xslider.getResolution());
        ZoomSlider yslider = this.statcon.getGraphWindow().getYSlider(0);
        minvis = yslider.getMinVisible();
        maxvis = Math.max(yslider.getMaxVisible(), 100.0);
        min = yslider.getMinLimit();
        max = Math.max(yslider.getMaxLimit(), maxvis * 10.0);
        yslider.configure(min, max, minvis, maxvis, yslider.getResolution());
    }

    private class CounterOFF
    extends DynamicAction {
        DCAgentGenericLoader loader;
        TRCAgent agent;

        public CounterOFF(DCAgentGenericLoader loader, TRCAgent agent) {
            this.loader = loader;
            this.agent = agent;
        }

        public Image getImage() {
            return CommonModuleTrace.this.img.getImage("trace_stop.gif");
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            boolean oneValid = false;
            int i = 0;
            while (i < relations.length) {
                if (relations[i] != null) {
                    if (!(relations[i] instanceof SDDescriptor)) {
                        return false;
                    }
                    SDDescriptor test = (SDDescriptor)relations[i];
                    while (test.getAgent() == null) {
                        if ((test = test.getParent()) != null) continue;
                        return false;
                    }
                    if (test.getAgent() != this.agent) {
                        return false;
                    }
                    oneValid = true;
                }
                ++i;
            }
            return oneValid;
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                if (relations[i] != null) {
                    try {
                        SDDescriptor selected = (SDDescriptor)relations[i];
                        this.loader.getCommandUtil().stopTracing(selected);
                        try {
                            StatConImageApplier.applyDown(statcon, selected, StatConImageApplier.getStandardStoppedImage());
                        }
                        catch (Exception e) {
                            EditorPlugin.DBG.warning("stop trace action failed to apply stop tracing images", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    private class CounterON
    extends DynamicAction {
        DCAgentGenericLoader loader;
        TRCAgent agent;

        public CounterON(DCAgentGenericLoader loader, TRCAgent agent) {
            this.loader = loader;
            this.agent = agent;
        }

        public Image getImage() {
            return CommonModuleTrace.this.img.getImage("trace_start.gif");
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            boolean oneValid = false;
            int i = 0;
            while (i < relations.length) {
                if (relations[i] != null) {
                    if (!(relations[i] instanceof SDDescriptor)) {
                        return false;
                    }
                    SDDescriptor test = (SDDescriptor)relations[i];
                    while (test.getAgent() == null) {
                        if ((test = test.getParent()) != null) continue;
                        return false;
                    }
                    if (test.getAgent() != this.agent) {
                        return false;
                    }
                    oneValid = true;
                }
                ++i;
            }
            return oneValid;
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                if (relations[i] != null) {
                    try {
                        SDDescriptor selected = (SDDescriptor)relations[i];
                        this.loader.getCommandUtil().startTracing(selected);
                        try {
                            StatConImageApplier.applyBoth(statcon, selected, StatConImageApplier.getStandardTracingImage());
                        }
                        catch (Exception e) {
                            EditorPlugin.DBG.warning("start trace action failed to apply start tracing images", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    private class UpdateTreeDAction
    extends DynamicAction {
        DCAgentGenericLoader loader;
        TRCAgent agent;

        public UpdateTreeDAction(DCAgentGenericLoader loader, TRCAgent agent) {
            this.loader = loader;
            this.agent = agent;
        }

        public Image getImage() {
            return CommonModuleTrace.this.img.getImage("update_tree.gif");
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            boolean oneValid = false;
            int i = 0;
            while (i < relations.length) {
                if (relations[i] != null) {
                    if (!(relations[i] instanceof SDDescriptor)) {
                        return false;
                    }
                    SDDescriptor test = (SDDescriptor)relations[i];
                    while (test.getAgent() == null) {
                        if ((test = test.getParent()) != null) continue;
                        return false;
                    }
                    if (test.getAgent() != this.agent) {
                        return false;
                    }
                    oneValid = true;
                }
                ++i;
            }
            return oneValid;
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                if (relations[i] != null) {
                    try {
                        SDDescriptor selected = (SDDescriptor)relations[i];
                        this.loader.getCommandUtil().getUpdatedTree(selected);
                    }
                    catch (IOException e) {
                        PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_UPDATE_TREE"), false);
                    }
                }
                ++i;
            }
        }
    }

    private class StopTraceDAction
    extends DynamicAction {
        DCAgentGenericLoader loader;
        TRCAgent agent;

        public StopTraceDAction(DCAgentGenericLoader loader, TRCAgent agent) {
            this.loader = loader;
            this.agent = agent;
        }

        public Image getImage() {
            return CommonModuleTrace.this.img.getImage("trace_stop.gif");
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            return relations.length == 1 && relations[0] == this.agent;
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            CommonModuleTrace.this.unloadTrace();
            try {
                EList descriptors = this.agent.getDescriptor();
                int i = 0;
                while (i < descriptors.size()) {
                    CommonModuleTrace.this.removeRepresentations((SDDescriptor)descriptors.get(i));
                    ++i;
                }
                TRCAgentUtil.saveTRCAgent(this.agent);
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.error("problem saving statistical model", (Throwable)e);
            }
            try {
                this.loader.killProcess();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.error("problem killing perfmon process", (Throwable)e);
            }
        }
    }

    private class SliderFollow
    implements Runnable {
        private SliderFollow() {
        }

        public void run() {
            if (CommonModuleTrace.this.statcon != null) {
                CommonModuleTrace.this.statcon.getGraphWindow().setTimeSliderFollowing(CommonModuleTrace.this.statcon.getGraphWindow().getXSlider(0), true);
            }
        }
    }

    private class Init
    extends Thread {
        String rac_host;
        String trace_prefix;
        String trace_postfix;
        String agent_name;
        SetVariableCommand[] reg_commands;
        String process_exe;

        public Init(String rac_host, String process_exe, String trace_prefix, String trace_postfix, String agent_name, SetVariableCommand[] reg_commands) {
            this.rac_host = rac_host;
            this.process_exe = process_exe;
            this.trace_prefix = trace_prefix;
            this.trace_postfix = trace_postfix;
            this.agent_name = agent_name;
            this.reg_commands = reg_commands;
        }

        public void run() {
            if (CommonModuleTrace.this.pmonitor != null) {
                CommonModuleTrace.this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));
            }
            try {
                HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;
                long started = System.currentTimeMillis();
                String host = this.rac_host;
                int port = 10002;
                CommonModuleTrace.this.tracename = this.trace_prefix + " " + PerfmonPlugin.getString("TRACE") + " - " + this.trace_postfix + " " + CommonModuleTrace.this.smodel_sdf.format(new Date(started));
                String modelname = this.trace_prefix + " " + PerfmonPlugin.getString("HOST_TRACE") + " - " + CommonModuleTrace.this.smodel_sdf.format(new Date(started));
                CommonModuleTrace.this.agent = TRCAgentUtil.newAgent(CommonModuleTrace.this.smodelpath, CommonModuleTrace.this.monitor_uri, null, null, null, CommonModuleTrace.this.getStatModelFileName(), CommonModuleTrace.this.tracename, CommonModuleTrace.this.rachost, this.agent_name, CommonModuleTrace.this.tracename, "Profiler");
                PerfmonPlugin.DBG.info("Creating variable loader");
                CommonModuleTrace.this.loader = new DCAgentGenericLoader(CommonModuleTrace.this.pmonitor, started, CommonModuleTrace.this.agent, modelname, this.process_exe, host, port, this.reg_commands, 1000);
                if (CommonModuleTrace.this.pmonitor != null) {
                    CommonModuleTrace.this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));
                }
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)CommonModuleTrace.this.agent.getAgentProxy());
                event.setType(1);
                ProfileUpdate update = new ProfileUpdate();
                update.event = event;
                Display.getDefault().syncExec((Runnable)update);
                if (CommonModuleTrace.this.statcon != null) {
                    PerfmonPlugin.DBG.info("Creating common variable modifier proxy");
                    CommonModuleTrace.this.cmodproxy = new CommonModifierProxy(CommonModuleTrace.this.loader.getCommandUtil(), CommonModuleTrace.this.statcon, CommonModuleTrace.this.agent);
                    PerfmonPlugin.DBG.info("Creating agent update thread");
                    CommonModuleTrace.this.agentupdate = new AgentUpdater(CommonModuleTrace.this.statcon, CommonModuleTrace.this.agent, CommonModuleTrace.this.loader);
                    Display.getDefault().syncExec((Runnable)new StatconUpdate());
                    CommonModuleTrace.this.click_listener = new CommonClickListener(CommonModuleTrace.this.loader, CommonModuleTrace.this.agent);
                    CommonModuleTrace.this.statcon.addClickListener(CommonModuleTrace.this.click_listener);
                }
                Display.getDefault().asyncExec((Runnable)new SliderFollow());
                TRCAgentUtil.saveTRCAgent(CommonModuleTrace.this.agent);
                if (CommonModuleTrace.this.pmonitor != null) {
                    CommonModuleTrace.this.pmonitor.done();
                }
            }
            catch (AgentControllerUnavailableException t) {
                if (CommonModuleTrace.this.pmonitor != null) {
                    CommonModuleTrace.this.pmonitor.done();
                }
                PerfmonPlugin.DBG.logVisibleError((Throwable)t, PerfmonPlugin.getString("ERROR_NO_RAC"), true);
            }
            catch (Throwable t) {
                if (CommonModuleTrace.this.pmonitor != null) {
                    CommonModuleTrace.this.pmonitor.done();
                }
                PerfmonPlugin.DBG.logVisibleError(t, PerfmonPlugin.getString("ERROR_STARTING_TRACE"), true);
            }
        }
    }

    private class StatconUpdate
    implements Runnable {
        private StatconUpdate() {
        }

        public void run() {
            try {
                CommonModuleTrace.this.statcon.setConstantUpdate("PERFMON UPDATE " + CommonModuleTrace.this.loader.hashCode(), true, 1000L);
                CommonModuleTrace.this.statcon.addAgent(CommonModuleTrace.this.agent);
                CommonModuleTrace.this.statcon.addDynamicAction("perfmon.common.agent", CommonModuleTrace.this.ACTION_STOP_TRACE + CommonModuleTrace.this.TRCID, PerfmonPlugin.getString("STOP_TRACE"), (DynamicAction)new StopTraceDAction(CommonModuleTrace.this.loader, CommonModuleTrace.this.agent));
                CommonModuleTrace.this.statcon.addDynamicAction("perfmon.common.control", CommonModuleTrace.this.ACTION_UPDATE_TREE + CommonModuleTrace.this.TRCID, PerfmonPlugin.getString("UPDATE_TREE"), (DynamicAction)new UpdateTreeDAction(CommonModuleTrace.this.loader, CommonModuleTrace.this.agent));
                CommonModuleTrace.this.statcon.addDynamicAction("perfmon.common.control", CommonModuleTrace.this.ACTION_START_TRACING + CommonModuleTrace.this.TRCID, PerfmonPlugin.getString("START_TRACING"), (DynamicAction)new CounterON(CommonModuleTrace.this.loader, CommonModuleTrace.this.agent));
                CommonModuleTrace.this.statcon.addDynamicAction("perfmon.common.control", CommonModuleTrace.this.ACTION_STOP_TRACING + CommonModuleTrace.this.TRCID, PerfmonPlugin.getString("STOP_TRACING"), (DynamicAction)new CounterOFF(CommonModuleTrace.this.loader, CommonModuleTrace.this.agent));
                CommonModuleTrace.this.configureSliders();
                CommonModuleTrace.this.statcon.setAgentFile(CommonModuleTrace.this.agent, CommonModuleTrace.this.agent.eResource().getURI());
                PerfmonPlugin.DBG.info("setting up trcagent + variable padder");
                CommonModuleTrace.this.statcon.addAgentChangeListener((AgentChangeListener)CommonModuleTrace.this);
                CommonModuleTrace.this.statcon.setAgentImage(CommonModuleTrace.this.agent, CommonModuleTrace.this.img.getImage("trace_start.gif"));
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_STATCON_UPDATE") + " (2)", true);
            }
        }
    }

    private class ProfileUpdate
    implements Runnable {
        ProfileEvent event;

        private ProfileUpdate() {
        }

        public void run() {
            try {
                UIPlugin.getDefault().notifyProfileEventListener(this.event);
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_SEND_PROFILING"), true);
            }
        }
    }
}

