/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.utils.internal;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;

public class TRCAgentUtil {
    static HierarchyFactory hfactory = HierarchyFactory.eINSTANCE;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$TRCMonitor;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$TRCNode;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$TRCProcessProxy;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$TRCAgent;

    public static URI getParentURI(URI uri) {
        return uri.trimSegments(1);
    }

    private static void createHierarchyComponent(URI uri, EObject instance) {
        EditorPlugin.DBG.info("Creating new Hierarchy component at " + uri);
        HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();
        Resource monitorResource = null;
        monitorResource = resourceSet.createResource(uri);
        EditorPlugin.DBG.info("had to create new Hierachy resource");
        try {
            monitorResource.getContents().add((Object)instance);
        }
        catch (Exception x) {
            EditorPlugin.DBG.error("problem adding to monitor resource", (Throwable)x);
        }
    }

    private static Object getHierarchyComponent(URI uri, Class type) {
        EditorPlugin.DBG.info("Fetching Hierarchy at " + uri);
        HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();
        Resource monitorResource = null;
        try {
            monitorResource = resourceSet.getResource(uri, true);
            EditorPlugin.DBG.info("got Hierarchy resource OK");
            EList resources = monitorResource.getContents();
            int i = 0;
            while (i < resources.size()) {
                Object o = resources.get(i);
                if (type.isAssignableFrom(o.getClass())) {
                    EditorPlugin.DBG.info("got Hierarchy component OK (" + type.getName() + ")");
                    return o;
                }
                ++i;
            }
        }
        catch (Exception e) {
            EditorPlugin.DBG.info("Hierarchy not found at " + uri);
        }
        return null;
    }

    private static void createResources(TRCAgent agent, URI monitorURI, URI nodeURI, URI processURI, URI agentURI) throws IOException {
        HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();
        Resource monitorResource = null;
        Resource nodeResource = null;
        Resource processResource = null;
        Resource agentResource = null;
        try {
            monitorResource = resourceSet.getResource(monitorURI, true);
            EditorPlugin.DBG.info("got TRCMonitor resource OK");
        }
        catch (Exception e) {
            monitorResource = resourceSet.createResource(monitorURI);
            EditorPlugin.DBG.info("created TRCMonitor resource OK");
        }
        try {
            nodeResource = resourceSet.getResource(nodeURI, true);
            EditorPlugin.DBG.info("got TRCNode resource OK");
        }
        catch (Exception e) {
            nodeResource = resourceSet.createResource(nodeURI);
            EditorPlugin.DBG.info("created TRCNode resource OK");
        }
        try {
            processResource = resourceSet.getResource(processURI, true);
            EditorPlugin.DBG.info("got TRCProcessProxy resource OK");
        }
        catch (Exception e) {
            processResource = resourceSet.createResource(processURI);
            EditorPlugin.DBG.info("created TRCProcessProxy resource OK");
        }
        try {
            agentResource = resourceSet.getResource(agentURI, true);
            EditorPlugin.DBG.info("got TRCAgent resource OK");
        }
        catch (Exception e) {
            agentResource = resourceSet.createResource(agentURI);
            EditorPlugin.DBG.info("created TRCAgent resource OK");
        }
        try {
            monitorResource.getContents().add((Object)agent.getAgentProxy().getProcessProxy().getNode().getMonitor());
        }
        catch (Exception e) {
            EditorPlugin.DBG.error("problem adding to monitor resource");
        }
        try {
            nodeResource.getContents().add((Object)agent.getAgentProxy().getProcessProxy().getNode());
        }
        catch (Exception e) {
            EditorPlugin.DBG.error("problem adding to node resource");
        }
        try {
            processResource.getContents().add((Object)agent.getAgentProxy().getProcessProxy());
        }
        catch (Exception e) {
            EditorPlugin.DBG.error("problem adding to process resource");
        }
        agentResource.getContents().add((Object)agent);
    }

    public static void saveTRCAgent(TRCAgent agent) throws IOException {
        agent.getAgentProxy().getProcessProxy().getNode().getMonitor().eResource().save(Collections.EMPTY_MAP);
        agent.getAgentProxy().getProcessProxy().getNode().eResource().save(Collections.EMPTY_MAP);
        agent.getAgentProxy().getProcessProxy().eResource().save(Collections.EMPTY_MAP);
        agent.eResource().save(Collections.EMPTY_MAP);
    }

    public static TRCAgent newAgent(URI project_uri, URI monitor_uri, URI node_uri, URI process_uri, URI agent_uri, String filename, String monitor_name, String node_name, String process_name, String agent_name, String agent_type) throws IOException {
        TRCAgent agentroot;
        TRCProcessProxy pproxyroot;
        TRCNode noderoot;
        TRCMonitor monitorroot;
        TRCAgentUtil.createContainer(project_uri);
        if (agent_type == null) {
            agent_type = "Profiler";
        }
        boolean new_monitor = false;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = null;
        if (monitor_uri == null) {
            path = new Path(project_uri + "/" + filename + ".trcmxmi");
            monitor_uri = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        }
        if (node_uri == null) {
            path = new Path(project_uri + "/" + filename + ".trcnxmi");
            node_uri = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        }
        if (process_uri == null) {
            path = new Path(project_uri + "/" + filename + ".trcpxmi");
            process_uri = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        }
        if (agent_uri == null) {
            path = new Path(project_uri + "/" + filename + ".trcaxmi");
            agent_uri = URI.createPlatformResourceURI((String)workspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        }
        if ((monitorroot = (TRCMonitor)TRCAgentUtil.getHierarchyComponent(monitor_uri, class$org$eclipse$hyades$models$hierarchy$TRCMonitor == null ? (class$org$eclipse$hyades$models$hierarchy$TRCMonitor = TRCAgentUtil.class$("org.eclipse.hyades.models.hierarchy.TRCMonitor")) : class$org$eclipse$hyades$models$hierarchy$TRCMonitor)) == null) {
            new_monitor = true;
            monitorroot = hfactory.createTRCMonitor();
            monitorroot.setName(monitor_name);
            monitorroot.setStartTime((double)System.currentTimeMillis());
            TRCAgentUtil.createHierarchyComponent(monitor_uri, (EObject)monitorroot);
        }
        if ((noderoot = (TRCNode)TRCAgentUtil.getHierarchyComponent(node_uri, class$org$eclipse$hyades$models$hierarchy$TRCNode == null ? (class$org$eclipse$hyades$models$hierarchy$TRCNode = TRCAgentUtil.class$("org.eclipse.hyades.models.hierarchy.TRCNode")) : class$org$eclipse$hyades$models$hierarchy$TRCNode)) == null) {
            noderoot = hfactory.createTRCNode();
            noderoot.setMonitor(monitorroot);
            noderoot.setName(node_name);
            noderoot.setRuntimeId("unknown");
            noderoot.setTimezone(0.0);
            TRCAgentUtil.createHierarchyComponent(node_uri, (EObject)noderoot);
        }
        if ((pproxyroot = (TRCProcessProxy)TRCAgentUtil.getHierarchyComponent(process_uri, class$org$eclipse$hyades$models$hierarchy$TRCProcessProxy == null ? (class$org$eclipse$hyades$models$hierarchy$TRCProcessProxy = TRCAgentUtil.class$("org.eclipse.hyades.models.hierarchy.TRCProcessProxy")) : class$org$eclipse$hyades$models$hierarchy$TRCProcessProxy)) == null) {
            pproxyroot = hfactory.createTRCProcessProxy();
            pproxyroot.setNode(noderoot);
            noderoot.getProcessProxies().add((Object)pproxyroot);
            pproxyroot.setActive(true);
            pproxyroot.setName(process_name);
            TRCAgentUtil.createHierarchyComponent(process_uri, (EObject)pproxyroot);
        }
        if ((agentroot = (TRCAgent)TRCAgentUtil.getHierarchyComponent(agent_uri, class$org$eclipse$hyades$models$hierarchy$TRCAgent == null ? (class$org$eclipse$hyades$models$hierarchy$TRCAgent = TRCAgentUtil.class$("org.eclipse.hyades.models.hierarchy.TRCAgent")) : class$org$eclipse$hyades$models$hierarchy$TRCAgent)) == null) {
            agentroot = hfactory.createTRCAgent();
            agentroot.setName(agent_name);
            agentroot.setType(agent_type);
            TRCAgentUtil.createHierarchyComponent(agent_uri, (EObject)agentroot);
            TRCAgentProxy aproxyroot = hfactory.createTRCAgentProxy();
            aproxyroot.setProcessProxy(pproxyroot);
            pproxyroot.getAgentProxies().add((Object)aproxyroot);
            aproxyroot.setActive(true);
            aproxyroot.setAttached(true);
            aproxyroot.setMonitored(true);
            aproxyroot.setType(agent_type);
            aproxyroot.setName(agent_name);
            agentroot.setAgentProxy(aproxyroot);
        } else {
            TRCAgentProxy aproxyroot = agentroot.getAgentProxy();
        }
        HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();
        String project_path = project_uri.toString().replaceFirst("platform:/resource/", "");
        Path temp = new Path(project_path.toString().replaceFirst("platform:/resource/", ""));
        try {
            TRCAgentUtil.createResources(agentroot, monitor_uri, node_uri, process_uri, agent_uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TRCAgentUtil.saveTRCAgent(agentroot);
        try {
            MonitorViewUpdate update = new MonitorViewUpdate(monitorroot, new_monitor, (IPath)temp);
            Display.getDefault().syncExec((Runnable)update);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return agentroot;
    }

    private static final IContainer createContainer(URI uri) {
        String path = uri.toString().replaceFirst("platform:/resource/", "");
        Path ipath = new Path(path.toString().replaceFirst("platform:/resource/", ""));
        return TRCAgentUtil.createContainer((IPath)ipath);
    }

    private static final IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = UIPlugin.getPluginWorkbench();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            String seg = path.segment(idx);
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    IProject[] projects = workbench.getRoot().getProjects();
                    int k = 0;
                    while (k < projects.length) {
                        if (projects[k].getName().equalsIgnoreCase(seg)) {
                            project = projects[k];
                        }
                        ++k;
                    }
                }
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
        return container;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MonitorViewUpdate
    implements Runnable {
        IPath temp;
        boolean new_monitor = false;
        TRCMonitor monitor;

        public MonitorViewUpdate(TRCMonitor monitor, boolean new_monitor, IPath temp) {
            this.monitor = monitor;
            this.new_monitor = new_monitor;
            this.temp = temp;
        }

        public void run() {
            block3: {
                try {
                    if (!this.new_monitor) {
                        PDContentProvider.resetMonitors();
                        break block3;
                    }
                    PDContentProvider.addMonitor((IResource)TRCAgentUtil.createContainer(this.temp), (TRCMonitor)this.monitor);
                }
                catch (Throwable e) {
                    PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_UPDATE_PROFMON"), true);
                }
            }
        }
    }
}

