/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.ui.preferences.AcadEditorPreferencePage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDResourceImpl;

public final class AcadEditorPlugin
extends EMFPlugin {
    private static final String extensionPointID = "cbeSchema";
    public static final String cbeName = "CommonBaseEvent";
    protected String identifier;
    public static final AcadEditorPlugin INSTANCE = new AcadEditorPlugin();
    private static Implementation plugin;
    private HashMap elementMap;
    private HashMap inheritedTypesMap;
    private XSDSchema schema;

    public AcadEditorPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public HashMap getCBEElements() {
        if (this.elementMap == null) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    AcadEditorPlugin.this.loadCBEPackageInfo();
                }
            });
        }
        return this.elementMap;
    }

    public void loadCBEPackageInfo() {
        XSDSchema schema = this.getCBESchema();
        this.elementMap = new HashMap();
        this.inheritedTypesMap = new HashMap();
        if (schema == null) {
            String msg = AcadEditorPlugin.getPlugin().getString("STR_SCHEMA_ERROR");
            Status err = new Status(2, "org.eclipse.core.resources", 566, msg, null);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)AcadEditorPlugin.getPlugin().getString("STR_AD_MSG_TITLE"), (String)"", (IStatus)err);
            return;
        }
        EList elems = schema.getElementDeclarations();
        int idx = 0;
        while (idx < elems.size()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)elems.get(idx);
            this.elementMap.put(elem.getName(), elem);
            ++idx;
        }
        elems = schema.getTypeDefinitions();
        int idx2 = 0;
        while (idx2 < elems.size()) {
            XSDTypeDefinition baseType;
            XSDTypeDefinition elem = (XSDTypeDefinition)elems.get(idx2);
            Object value = this.inheritedTypesMap.get(elem);
            if (value == null) {
                this.inheritedTypesMap.put(elem, new ArrayList());
            }
            if ((baseType = elem.getBaseType()) != null) {
                value = this.inheritedTypesMap.get(baseType);
                if (value == null) {
                    ArrayList<XSDTypeDefinition> list = new ArrayList<XSDTypeDefinition>();
                    list.add(elem);
                    this.inheritedTypesMap.put(baseType, list);
                } else {
                    ((ArrayList)value).add(elem);
                }
            }
            ++idx2;
        }
    }

    protected XSDSchema getCBESchema() {
        if (this.schema != null) {
            return this.schema;
        }
        IExtensionPoint point = AcadEditorPlugin.getPlugin().getDescriptor().getExtensionPoint(extensionPointID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String schemaName = elem.getAttribute("name");
                if (schemaName == null || schemaName.length() == 0) {
                    return null;
                }
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI uri = URI.createURI((String)(AcadEditorPlugin.getPlugin().getDescriptor().getInstallURL().toString() + schemaName));
                XSDResourceImpl xsdSchemaResource = (XSDResourceImpl)resourceSet.getResource(uri, true);
                Iterator resources = resourceSet.getResources().iterator();
                while (resources.hasNext()) {
                    Resource resource = (Resource)resources.next();
                    if (!(resource instanceof XSDResourceImpl)) continue;
                    XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
                    this.schema = xsdResource.getSchema();
                    return this.schema;
                }
                ++i;
            }
        }
        return null;
    }

    public Object getElementDefinitionForType(RuleElementType elem) {
        String elementName = elem.getName();
        if (elementName == null) {
            return null;
        }
        Object cbeObject = INSTANCE.getCBEElements().get(elementName);
        if (cbeObject != null) {
            return cbeObject;
        }
        EObject container = elem.eContainer();
        ArrayList<String> list = new ArrayList<String>();
        while (container != null && container instanceof RuleElementType && cbeObject == null) {
            cbeObject = INSTANCE.getCBEElements().get(((RuleElementType)container).getName());
            if (cbeObject == null) {
                String name = ((RuleElementType)container).getName();
                list.add(name);
            }
            container = ((RuleElementType)container).eContainer();
        }
        if (cbeObject == null) {
            return null;
        }
        int idx = list.size() - 1;
        while (idx >= 0) {
            if ((cbeObject = INSTANCE.getElementDefinitionFromType(((XSDElementDeclaration)cbeObject).getType(), list.get(idx).toString())) == null) break;
            --idx;
        }
        if (cbeObject != null && cbeObject instanceof XSDElementDeclaration) {
            return this.getElementDefinitionFromType(((XSDElementDeclaration)cbeObject).getTypeDefinition(), elementName);
        }
        if (cbeObject instanceof XSDTypeDefinition) {
            return this.getElementDefinitionFromType((XSDTypeDefinition)cbeObject, elementName);
        }
        return null;
    }

    public Object getElementDefinitionFromType(XSDTypeDefinition type, String typeName) {
        if (type == null || typeName == null) {
            return null;
        }
        if (type instanceof XSDComplexTypeDefinition) {
            XSDParticleContent pcontent;
            XSDComplexTypeContent tdef;
            Object inhList;
            XSDComplexTypeDefinition ctype = (XSDComplexTypeDefinition)type;
            if (ctype.isAbstract() && (inhList = this.getInheritedTypes((XSDTypeDefinition)ctype)) != null) {
                ArrayList list = (ArrayList)inhList;
                int idx = 0;
                while (idx < list.size()) {
                    XSDTypeDefinition def = (XSDTypeDefinition)list.get(idx);
                    if (def.getName().equals(typeName)) {
                        return def;
                    }
                    ++idx;
                }
            }
            if ((tdef = ctype.getContentType()) != null && tdef instanceof XSDParticle && (pcontent = ((XSDParticle)tdef).getContent()) instanceof XSDModelGroup) {
                XSDModelGroup group = (XSDModelGroup)pcontent;
                EList tcontents = group.getContents();
                int i = 0;
                while (i < tcontents.size()) {
                    XSDWildcard wcard;
                    XSDParticle obj = (XSDParticle)tcontents.get(i);
                    XSDTerm odecl = obj.getTerm();
                    if (odecl instanceof XSDElementDeclaration) {
                        XSDElementDeclaration edecl = (XSDElementDeclaration)odecl;
                        if (edecl.getName().equals(typeName)) {
                            return edecl;
                        }
                    } else if (odecl instanceof XSDModelGroup) {
                        EList elemList = ((XSDModelGroup)odecl).getContents();
                        int k = 0;
                        while (k < elemList.size()) {
                            XSDElementDeclaration edecl;
                            XSDTerm term = ((XSDParticle)elemList.get(k)).getTerm();
                            if (term instanceof XSDElementDeclaration && (edecl = (XSDElementDeclaration)term).getName().equals(typeName)) {
                                return edecl;
                            }
                            ++k;
                        }
                    } else if (odecl instanceof XSDWildcard && (wcard = (XSDWildcard)odecl).getStringLexicalNamespaceConstraint().equals(typeName)) {
                        return wcard;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public Object getInheritedTypes(XSDTypeDefinition type) {
        if (this.inheritedTypesMap == null) {
            return null;
        }
        return this.inheritedTypesMap.get(type);
    }

    public Object getTypeFromName(String name) {
        if (this.inheritedTypesMap == null) {
            return null;
        }
        Iterator iterator = this.inheritedTypesMap.keySet().iterator();
        while (iterator.hasNext()) {
            XSDTypeDefinition type = (XSDTypeDefinition)iterator.next();
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static AcadEditorPlugin getDefault() {
        return INSTANCE;
    }

    public void logMessage(IStatus status, boolean showMessageDialog) {
        plugin.getLog().log(status);
        if (showMessageDialog) {
            ErrorDialog.openError((Shell)this.getActiveWorkbenchWindow().getShell(), (String)"Generic Adaptor Message", null, (IStatus)status, (int)4);
        }
    }

    public void logMessage(IStatus status) {
        this.logMessage(status, false);
    }

    public void log(Object logEntry) {
        if (logEntry instanceof Throwable) {
            Throwable err = (Throwable)logEntry;
            Status multiStatus = new Status(4, this.getPluginId(), 0, err.getLocalizedMessage(), null);
            this.logMessage((IStatus)multiStatus, true);
        } else {
            Status status = new Status(4, this.getPluginId(), 0, logEntry.toString(), null);
            this.logMessage((IStatus)status, true);
        }
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public IWorkbenchPage getActivePage() {
        IWorkbenchPage page;
        block6: {
            IWorkbenchWindow window = this.getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            page = this.getActiveWorkbenchWindow().getActivePage();
            if (page != null && page.getPerspective().getId().equals("org.eclipse.hyades.logging.adapter.ui.perspective")) break block6;
            IWorkbenchWindow dwindow = this.getActiveWorkbenchWindow();
            page = null;
            try {
                IWorkbenchPage[] persps = dwindow.getPages();
                int idx = 0;
                while (idx < persps.length) {
                    if (persps[idx].getPerspective().getId().equals("org.eclipse.hyades.logging.adapter.ui.perspective")) {
                        page = persps[idx];
                        dwindow.setActivePage(page);
                        break;
                    }
                    ++idx;
                }
                if (page != null) break block6;
                IWorkspaceRoot element = ResourcesPlugin.getWorkspace().getRoot();
                IWorkbench workBench = dwindow.getWorkbench();
                if (workBench != null && element != null) {
                    page = workBench.showPerspective("org.eclipse.hyades.logging.adapter.ui.perspective", this.getActiveWorkbenchWindow(), (IAdaptable)element);
                }
            }
            catch (Exception exc) {}
        }
        return page;
    }

    public String getPluginId() {
        if (this.identifier == null) {
            this.identifier = plugin.getDescriptor().getUniqueIdentifier();
        }
        return this.identifier;
    }

    public void createRequiredAttributes(RuleElementType element, XSDTypeDefinition type) {
        if (type instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
            EList attrs = complexType.getAttributeUses();
            int idx = 0;
            while (idx < attrs.size()) {
                XSDAttributeUse attr = (XSDAttributeUse)attrs.get(idx);
                if (attr.isRequired()) {
                    RuleAttributeType ruleAtribute = ParserFactory.eINSTANCE.createRuleAttributeType();
                    ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(true);
                    ruleAtribute.setUsePreviousMatchSubstitutionAsDefault(false);
                    ruleAtribute.setName(attr.getAttributeDeclaration().getName());
                    ruleAtribute.setIsRequiredByParent(false);
                    element.getRuleAttribute().add((Object)ruleAtribute);
                    SubstitutionRuleType subs = ParserFactory.eINSTANCE.createSubstitutionRuleType();
                    subs.setMatch("^(.*)");
                    subs.setSubstitute("replace with our message text");
                    subs.setUseBuiltInFunction(true);
                    subs.setUseBuiltInFunction(false);
                    ruleAtribute.getSubstitutionRule().add((Object)subs);
                }
                ++idx;
            }
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation(IPluginDescriptor descriptor) {
            super(descriptor);
            plugin = this;
            plugin.getPluginPreferences().setDefault("buffer_size", AcadEditorPreferencePage.DEFAULT_SIZE);
        }
    }
}

