/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class AdaptorActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected Collection createChildActions;
    protected IMenuManager createChildMenuManager;

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("adaptor-settings"));
        toolBarManager.add((IContributionItem)new Separator("adaptor-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditor_menu"), "org.eclipse.hyades.acad.model.internal.adaptorMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(AcadEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        Collection newChildDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
    }

    protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
        LinkedList<CreateChildAction> actions = new LinkedList<CreateChildAction>();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            block0: while (i.hasNext()) {
                Object value;
                CommandParameter command = (CommandParameter)i.next();
                CreateChildAction action = new CreateChildAction(this.activeEditorPart, selection, (Object)command);
                actions.add(action);
                if (object instanceof ParserConfigType) {
                    value = command.getValue();
                    action.setText(((RuleElementType)value).getName());
                    EList rules = ((ParserConfigType)object).getRuleElement();
                    int idx = 0;
                    while (idx < rules.size()) {
                        RuleElementType elem = (RuleElementType)rules.get(idx);
                        if (elem.getName() != null && elem.getName().equals(action.getText())) {
                            action.setEnabled(false);
                            continue block0;
                        }
                        ++idx;
                    }
                    continue;
                }
                if (!(object instanceof RuleElementType)) continue;
                value = command.getValue();
                if (value != null && value instanceof RuleAttributeType) {
                    action.setText(((RuleAttributeType)value).getName());
                    this.enableAttributeAction((Action)action, (RuleElementType)object);
                }
                if (value == null || !(value instanceof RuleElementType)) continue;
                action.setText(((RuleElementType)value).getName());
                this.enableElementAction((Action)action, (RuleElementType)object);
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            Iterator i = actions.iterator();
            while (i.hasNext()) {
                IAction action = (IAction)i.next();
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(AcadEditorPlugin.INSTANCE.getString("STR_ADD"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("additions", (IContributionItem)submenuManager);
    }

    protected void enableAttributeAction(Action action, RuleElementType object) {
        String name = action.getText();
        if (name == null) {
            return;
        }
        Object cbeObject = AcadEditorPlugin.INSTANCE.getElementDefinitionForType(object);
        if (cbeObject == null) {
            return;
        }
        XSDTypeDefinition def = null;
        if (cbeObject instanceof XSDTypeDefinition) {
            def = (XSDTypeDefinition)cbeObject;
        } else if (cbeObject instanceof XSDElementDeclaration) {
            def = ((XSDElementDeclaration)cbeObject).getTypeDefinition();
        }
        if (def == null || def instanceof XSDSimpleTypeDefinition) {
            return;
        }
        EList attributes = object.getRuleAttribute();
        int idx = 0;
        while (idx < attributes.size()) {
            if (name.equals(((RuleAttributeType)attributes.get(idx)).getName())) {
                action.setEnabled(false);
                return;
            }
            ++idx;
        }
        action.setEnabled(true);
    }

    protected void enableElementAction(Action action, RuleElementType object) {
        block14: {
            String name;
            block13: {
                name = action.getText();
                Object cbeObject = AcadEditorPlugin.INSTANCE.getElementDefinitionForType(object);
                if (cbeObject == null || !(cbeObject instanceof XSDElementDeclaration)) break block13;
                Object decl = AcadEditorPlugin.INSTANCE.getElementDefinitionFromType(((XSDElementDeclaration)cbeObject).getType(), name);
                if (decl == null || !(decl instanceof XSDElementDeclaration)) {
                    EList elements = object.getRuleElement();
                    int idx = 0;
                    while (idx < elements.size()) {
                        RuleElementType relem = (RuleElementType)elements.get(idx);
                        if (name.equals(relem.getName())) {
                            action.setEnabled(false);
                        }
                        ++idx;
                    }
                    return;
                }
                if (name.equals("values")) {
                    EList elements = object.getRuleElement();
                    int idx = 0;
                    while (idx < elements.size()) {
                        RuleElementType relem = (RuleElementType)elements.get(idx);
                        if (relem.getName().equals("hexValue")) {
                            action.setEnabled(false);
                            break;
                        }
                        ++idx;
                    }
                    return;
                }
                if (name.equals("hexValue")) {
                    EList elements = object.getRuleElement();
                    int idx = 0;
                    while (idx < elements.size()) {
                        RuleElementType relem = (RuleElementType)elements.get(idx);
                        if (relem.getName().equals("values") || relem.getName().equals("hexValue")) {
                            action.setEnabled(false);
                            break;
                        }
                        ++idx;
                    }
                    return;
                }
                String value = ((XSDElementDeclaration)decl).getElement().getAttribute("maxOccurs");
                if (value == null || !value.equals("1")) break block14;
                EList elements = object.getRuleElement();
                int idx = 0;
                while (idx < elements.size()) {
                    RuleElementType relem = (RuleElementType)elements.get(idx);
                    if (name.equals(relem.getName())) {
                        action.setEnabled(false);
                    }
                    ++idx;
                }
                break block14;
            }
            EList elements = object.getRuleElement();
            int idx = 0;
            while (idx < elements.size()) {
                RuleElementType relem = (RuleElementType)elements.get(idx);
                if (name.equals(relem.getName())) {
                    action.setEnabled(false);
                }
                ++idx;
            }
        }
    }

    protected void enableComplexType(Action action, XSDComplexTypeDefinition tdef, RuleElementType object) {
        String name = action.getText();
        String value = tdef.getElement().getAttribute("maxOccurs");
        if (value != null && value.equals("1")) {
            EList elements = object.getRuleElement();
            int i = 0;
            while (i < elements.size()) {
                RuleElementType relem = (RuleElementType)elements.get(i);
                if (name.equals(relem.getName())) {
                    action.setEnabled(false);
                    return;
                }
                ++i;
            }
        }
        action.setEnabled(true);
    }
}

