/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.RuleElementTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RuleElementSection
extends Composite
implements IDetails,
INotifyChangedListener,
SelectionListener {
    protected Label nameText;
    protected Label uniqueId;
    protected Label indexText;
    protected Button requireByParentBtn;
    protected Button isChildChoicBtn;
    protected boolean isDisplaying;
    protected RuleElementType currentSelection;
    protected RuleElementTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();

    public RuleElementSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ELEM_NAME"), 0);
        this.nameText = factory.createLabel(this, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ELEM_ID"), 0);
        this.uniqueId = factory.createLabel(this, "unspecified");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ELEM_INDEX"), 0);
        this.indexText = factory.createLabel(this, "");
        this.indexText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.requireByParentBtn = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_REQUIRE_BY_PARENT"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.requireByParentBtn.setLayoutData((Object)data);
        this.isChildChoicBtn = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_CHILD_CHOICE"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.isChildChoicBtn.setLayoutData((Object)data);
        this.isChildChoicBtn.addSelectionListener((SelectionListener)this);
        this.requireByParentBtn.addSelectionListener((SelectionListener)this);
        this.itemProvider = (RuleElementTypeItemProvider)this.itemFactory.createRuleElementTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject object) {
        if (this.currentSelection == object) {
            return;
        }
        if (this.nameText.isFocusControl()) {
            return;
        }
        this.currentSelection = (RuleElementType)object;
        this.isDisplaying = true;
        this.nameText.setText(this.currentSelection.getName() == null ? "" : this.currentSelection.getName());
        this.uniqueId.setText(this.currentSelection.getId() == null ? "unspecified" : this.currentSelection.getId().toString());
        this.indexText.setText(this.currentSelection.getIndex() == null ? "" : this.currentSelection.getIndex());
        this.requireByParentBtn.setSelection(this.currentSelection.isIsRequiredByParent());
        this.isChildChoicBtn.setSelection(this.currentSelection.isIsChildChoice());
        this.showCheckBoxs(!(this.currentSelection.eContainer() instanceof ParserConfigType));
        this.isDisplaying = false;
    }

    private void showCheckBoxs(boolean enable) {
        this.requireByParentBtn.setVisible(enable);
        this.isChildChoicBtn.setVisible(enable);
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (RuleElementType)currentSelection;
        this.currentSelection.setIsChildChoice(this.isChildChoicBtn.getSelection());
        this.currentSelection.setIsRequiredByParent(this.requireByParentBtn.getSelection());
        return false;
    }

    public void setFocusToText() {
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent e) {
        boolean value;
        if (e.getSource() == this.requireByParentBtn) {
            boolean value2 = this.requireByParentBtn.getSelection();
            if (value2 != this.currentSelection.isIsRequiredByParent()) {
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, RuleElementTypeItemProvider.REQUIRED_BY_PARENT);
                this.currentSelection.setIsRequiredByParent(value2);
                Boolean oldValue = this.currentSelection.isIsRequiredByParent();
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
                }
            }
        } else if (e.getSource() == this.isChildChoicBtn && (value = this.isChildChoicBtn.getSelection()) != this.currentSelection.isIsChildChoice()) {
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, RuleElementTypeItemProvider.CHILD_CHOICE);
            this.currentSelection.setIsChildChoice(value);
            Boolean oldValue = this.currentSelection.isIsChildChoice();
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

