/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.AdaptorEditor;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class ContentView
extends ViewPart
implements IPartListener {
    private final String CONTENT_TITLE = AcadEditorPlugin.getPlugin().getString("LOG_CONTENT");
    TextViewer contentViewer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.enableEditActions();
    }

    public void createPartControl(Composite parent) {
        this.contentViewer = new TextViewer(parent, 2882);
        this.contentViewer.setEditable(false);
        this.set_Title();
        WorkbenchHelp.setHelp((Control)parent, (String)ContextIds.ACAD_EDITOR_CONTENT_VIEW);
    }

    public void showLog() {
        if (AcadGuiModelManager.getCurrentModel() != null) {
            this.setContent(AcadGuiModelManager.getCurrentModel().getLogContent());
        }
    }

    public void setFocus() {
        if (this.contentViewer != null && this.contentViewer.getControl().isDisposed()) {
            this.contentViewer.getControl().setFocus();
        }
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/elcl16/";
        try {
            URL installURL = AcadEditorPlugin.getPlugin().getBaseURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private void hookGlobalActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
    }

    private void updateActionEnablement() {
    }

    public void set_Title() {
        AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
        StringBuffer title = new StringBuffer(this.CONTENT_TITLE).append(" ");
        if (model != null) {
            long currentEvent = model.getCurrentCount();
            currentEvent = currentEvent >= 0L ? ++currentEvent : 0L;
            long l = currentEvent = currentEvent > model.getEventCount() ? currentEvent - 1L : currentEvent;
            if (model.getContextInstance() == null || model.getContextInstance().eContainer() == null) {
                title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
            } else {
                SensorConfigType sensor = AcadGuiModelManager.getLogForConfiguration(model);
                if (sensor != null) {
                    if (model.getEventCount() > 0L) {
                        String msg = AcadEditorPlugin.getPlugin().getString("STR_CONTENT_TITLE", new Object[]{"0", String.valueOf(model.getEventCount())});
                        title.append(" ").append(msg);
                    }
                } else {
                    title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                }
            }
        }
        super.setTitle(title.toString());
    }

    public void dispose() {
        super.dispose();
    }

    public String getText() {
        return ((StyledText)this.contentViewer.getControl()).getText();
    }

    public static final ContentView getContentView(boolean show) {
        try {
            IWorkbenchPage page = AcadEditorPlugin.getDefault().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return null;
            }
            IViewPart view = null;
            if (show) {
                page = AcadEditorPlugin.getDefault().getActivePage();
                if (page == null) {
                    return null;
                }
                view = page.showView("org.eclipse.hyades.logging.adapter.ui.views.contentview");
                if (view != null && view instanceof ContentView) {
                    page.addPartListener((IPartListener)((ContentView)view));
                    return (ContentView)view;
                }
            }
            if ((view = page.findView("org.eclipse.hyades.logging.adapter.ui.views.contentview")) != null && view instanceof ContentView) {
                page.addPartListener((IPartListener)((ContentView)view));
                return (ContentView)view;
            }
        }
        catch (Exception exc) {
            return null;
        }
        return null;
    }

    public void reset() {
        this.setContent("");
    }

    public void setContent(String text) {
        if (this.contentViewer != null && text != null) {
            this.contentViewer.setDocument((IDocument)new Document(text));
        }
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        boolean rc;
        if (part instanceof AdaptorEditor && (rc = AcadGuiModelManager.isCurrentModel(((AdaptorEditor)part).getFile()))) {
            super.setTitle(this.CONTENT_TITLE);
            this.setContent("");
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }
}

