/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.preferences;

import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AcadEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static int MAX_SIZE = 100;
    public static int DEFAULT_SIZE = 10;
    public static final String BUFFER_SIZE = "buffer_size";
    private Text sizeText;
    protected static PreferencePage INSTANCE;

    public AcadEditorPreferencePage() {
        INSTANCE = this;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        Label prefDesc = new Label(composite, 64);
        prefDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_MESSAGE", new Object[]{String.valueOf(MAX_SIZE)}));
        GridData data = GridDataUtil.createHorizontalFill();
        data.widthHint = 400;
        prefDesc.setLayoutData((Object)data);
        Composite content = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.makeColumnsEqualWidth = false;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label textDesc = new Label(content, 0);
        textDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_BUFFER_SIZE"));
        this.sizeText = new Text(content, 2048);
        data = GridDataUtil.createFill();
        data.widthHint = 50;
        data.horizontalAlignment = 1;
        this.sizeText.setLayoutData((Object)data);
        this.sizeText.setFocus();
        this.sizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = AcadEditorPreferencePage.this.sizeText.getText();
                String errorMessage = null;
                try {
                    int size = Integer.parseInt(value);
                    if (size > MAX_SIZE) {
                        errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_TOO_LARGE", new Object[]{String.valueOf(MAX_SIZE)});
                    } else if (size < 0) {
                        errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NEGATIVE");
                    } else if (size == 0) {
                        errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
                    }
                }
                catch (Exception exp) {
                    errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
                }
                INSTANCE.setErrorMessage(errorMessage);
                INSTANCE.setValid(errorMessage == null);
            }
        });
        this.initializeValues();
        return composite;
    }

    public void initializeValues() {
        int size = AcadEditorPlugin.getPlugin().getPluginPreferences().getInt(BUFFER_SIZE);
        this.sizeText.setText(Integer.toString(size));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        AcadEditorPlugin.getPlugin().getPluginPreferences().setToDefault(BUFFER_SIZE);
        this.sizeText.setText("" + AcadEditorPlugin.getPlugin().getPluginPreferences().getDefaultInt(BUFFER_SIZE));
    }

    private void storeValues() {
        int size = -1;
        try {
            size = Integer.parseInt(this.sizeText.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        AcadEditorPlugin.getPlugin().getPluginPreferences().setValue(BUFFER_SIZE, size);
        AcadEditorPlugin.getPlugin().savePluginPreferences();
    }
}

