/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBESortUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class SortDialog
extends Dialog
implements SelectionListener {
    private CBESortUI _options;
    private static final int _restoreDefaultsButtonId = 1025;
    private String _title;
    private boolean sortHasChanged = false;

    public SortDialog(Shell shell, String windowTitle, Image windowImage) {
        super(shell);
        this._title = windowTitle;
        Window.setDefaultImage((Image)windowImage);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 400;
        data.widthHint = 450;
        composite.setLayoutData((Object)data);
        this._options = new CBESortUI();
        this._options.createControl(composite);
        this._options.initializeValues(false);
        this._options.addListener(this);
        WorkbenchHelp.setHelp((Control)composite, (String)ContextIds.ACTLOG_VIEW_DIALOG_SORT);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this._options.initializeValues(true);
        } else {
            this._options.removeListener(this);
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this._options.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
        this._options.removeListener(this);
        if (this.sortHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(4, (Object)this));
        }
        super.okPressed();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.data != null && e.data instanceof Integer && (Integer)e.data == 4) {
            this.sortHasChanged = true;
        }
    }
}

