/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;

public class ExtensionPointHandler {
    private static ExtensionPointHandler inst;
    private Hashtable analyzerList = new Hashtable();
    static /* synthetic */ Class class$org$eclipse$hyades$models$cbe$CBECommonBaseEvent;
    static /* synthetic */ Class class$org$eclipse$hyades$models$cbe$CBEDefaultEvent;

    public ExtensionPointHandler() {
        inst = this;
        this.populateAnalyzerList();
    }

    public static ExtensionPointHandler getExtensionPointHandler() {
        if (inst == null) {
            inst = new ExtensionPointHandler();
        }
        return inst;
    }

    public boolean analyzerDefinedFor(Object record) {
        List list = null;
        if (record instanceof CBECommonBaseEvent) {
            list = (List)this.analyzerList.get("CommonBaseEvent");
            if (list != null) {
                return true;
            }
            list = (List)this.analyzerList.get("DefaultEvent");
            if (list != null) {
                return true;
            }
        } else if (record instanceof CBEDefaultEvent) {
            return this.analyzerList.get("DefaultEvent") != null;
        }
        return false;
    }

    public List getLogAnalyzer(Object record) {
        ArrayList list = null;
        if (record instanceof CBECommonBaseEvent) {
            List cbeList = (List)this.analyzerList.get("CommonBaseEvent");
            List deList = (List)this.analyzerList.get("DefaultEvent");
            if (cbeList == null) {
                list = deList;
            } else if (deList != null) {
                list = new ArrayList();
                list.addAll(deList);
                list.addAll(cbeList);
            }
        } else if (record instanceof CBEDefaultEvent) {
            list = (ArrayList)this.analyzerList.get("DefaultEvent");
        }
        return list;
    }

    public List getLogAnalyzers() {
        ArrayList list = null;
        List cbeList = (List)this.analyzerList.get("CommonBaseEvent");
        ArrayList deList = (ArrayList)this.analyzerList.get("DefaultEvent");
        if (cbeList == null) {
            list = deList;
        } else if (deList != null) {
            list = new ArrayList();
            list.addAll(deList);
            list.addAll(cbeList);
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public void populateAnalyzerList() {
        try {
            ILogAnalyzer aLogAnalyzer = null;
            String type = null;
            String name = null;
            IPluginRegistry reg = Platform.getPluginRegistry();
            IConfigurationElement[] extensionList = reg.getConfigurationElementsFor("org.eclipse.hyades.analysis.engine", "logAnalyzer");
            ArrayList<ConfigurationElement> list = null;
            int i = 0;
            while (i < extensionList.length) {
                type = extensionList[i].getAttribute("type");
                if (type != null) {
                    Class<?> clsType = Class.forName(type);
                    aLogAnalyzer = (ILogAnalyzer)extensionList[i].createExecutableExtension("class");
                    if (aLogAnalyzer != null) {
                        name = extensionList[i].getAttribute("name");
                        if (name == null) {
                            name = LogUIPlugin.getResourceBundle().getString("UNKNOWN_LABEL");
                        }
                        if ((list = this.getList(clsType)) == null) {
                            list = new ArrayList<ConfigurationElement>();
                            list.add(new ConfigurationElement(name, aLogAnalyzer));
                            this.casheList(clsType, list);
                        } else {
                            list.add(new ConfigurationElement(name, aLogAnalyzer));
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LogUIPlugin.log(e);
            e.printStackTrace();
        }
    }

    private void casheList(Class clsType, List list) {
        if (clsType == (class$org$eclipse$hyades$models$cbe$CBECommonBaseEvent == null ? (class$org$eclipse$hyades$models$cbe$CBECommonBaseEvent = ExtensionPointHandler.class$("org.eclipse.hyades.models.cbe.CBECommonBaseEvent")) : class$org$eclipse$hyades$models$cbe$CBECommonBaseEvent)) {
            this.analyzerList.put("CommonBaseEvent", list);
        } else if (clsType == (class$org$eclipse$hyades$models$cbe$CBEDefaultEvent == null ? (class$org$eclipse$hyades$models$cbe$CBEDefaultEvent = ExtensionPointHandler.class$("org.eclipse.hyades.models.cbe.CBEDefaultEvent")) : class$org$eclipse$hyades$models$cbe$CBEDefaultEvent)) {
            this.analyzerList.put("DefaultEvent", list);
        }
    }

    private List getList(Class clsType) {
        List list = null;
        if (clsType == (class$org$eclipse$hyades$models$cbe$CBECommonBaseEvent == null ? (class$org$eclipse$hyades$models$cbe$CBECommonBaseEvent = ExtensionPointHandler.class$("org.eclipse.hyades.models.cbe.CBECommonBaseEvent")) : class$org$eclipse$hyades$models$cbe$CBECommonBaseEvent)) {
            list = (List)this.analyzerList.get("CommonBaseEvent");
        } else if (clsType == (class$org$eclipse$hyades$models$cbe$CBEDefaultEvent == null ? (class$org$eclipse$hyades$models$cbe$CBEDefaultEvent = ExtensionPointHandler.class$("org.eclipse.hyades.models.cbe.CBEDefaultEvent")) : class$org$eclipse$hyades$models$cbe$CBEDefaultEvent)) {
            list = (List)this.analyzerList.get("DefaultEvent");
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ConfigurationElement {
        private String name;
        private ILogAnalyzer analyzer;

        public ConfigurationElement(String name, ILogAnalyzer analyzer) {
            this.name = name;
            this.analyzer = analyzer;
        }

        public ILogAnalyzer getAnalyzer() {
            return this.analyzer;
        }

        public String getName() {
            return this.name;
        }
    }
}

