/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogDestinationUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogHostUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogLocationUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;

public class LogFileDetailsUI
extends Dialog
implements SelectionListener {
    private ImportLogWizardPage page;
    private Table logsTable;
    private TabFolder details;
    private TabItem hostTab;
    private TabItem logLocationTab;
    private TabItem destinationTab;
    private LogParserUI parserUI;
    private LogHostUI hostUI;
    private LogLocationUI locationUI;
    private LogDestinationUI destinationUI;
    private ArrayList logs = new ArrayList();
    private Button addBtn;
    private Button removeBtn;
    private LogParserItem parser;
    private String title = "";
    private int type;

    public LogFileDetailsUI(Shell shell, ImportLogWizardPage page, int type) {
        super(shell);
        this.page = page;
        this.type = type;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite result = new Composite(parent, 0);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        result.setLayout((Layout)new GridLayout());
        this.parserUI = new LogParserUI(this);
        this.parserUI.createControl(result);
        this.createSpace(result);
        Label lblProp = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        lblProp.setLayoutData((Object)data);
        lblProp.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_PROPERTIES"));
        this.details = new TabFolder(result, 0);
        data = GridUtil.createFill();
        data.widthHint = 400;
        data.heightHint = 300;
        this.details.setLayoutData((Object)data);
        this.details.addSelectionListener((SelectionListener)this);
        this.hostTab = new TabItem(this.details, 0);
        this.hostTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_HOST_TAB"));
        this.hostUI = new LogHostUI(this.page);
        this.hostTab.setControl((Control)this.hostUI.createControl((Composite)this.details));
        this.logLocationTab = new TabItem(this.details, 0);
        this.logLocationTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_DETAILS_TAB"));
        this.locationUI = new LogLocationUI(this.page, this);
        this.logLocationTab.setControl((Control)this.locationUI.createControl((Composite)this.details));
        this.destinationTab = new TabItem(this.details, 0);
        this.destinationTab.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_DEST_TAB"));
        this.destinationUI = new LogDestinationUI(this.page);
        this.destinationTab.setControl((Control)this.destinationUI.createControl((Composite)this.details));
        if (this.type == 4) {
            this.initializeUI();
        } else if (this.type == 5) {
            this.initializeUIFromLogElement();
        }
        return result;
    }

    private void createSpace(Composite parent) {
        Label space = new Label(parent, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    public String getHostName() {
        return this.hostUI.getHost();
    }

    public boolean isLocalHost() {
        String host = this.hostUI.getHost();
        if (host == null) {
            return false;
        }
        return this.hostUI.isLocalHost(host);
    }

    public int getParserCount() {
        return this.parserUI.getParserCount();
    }

    public int getPort() {
        return this.hostUI.getPort();
    }

    public Hashtable getUserInput(LogParserItem item) {
        return this.locationUI.getUserInput(item);
    }

    public int indexOf(LogParserItem item) {
        return this.parserUI.indexOf(item);
    }

    public void initializeUI() {
        this.hostUI.initialize(this.page.getSelectedElement());
        this.initializeLocation();
        this.destinationUI.initialize();
        this.setOKButtonEnabled(this.isTabFolderComplete());
    }

    public void initializeLocation() {
        Composite composite = this.locationUI.getCompositeFor(this.parser);
        if (composite == null) {
            composite = this.locationUI.createControl((Composite)this.details, this.parser);
            this.parser.setWidgets(this.locationUI.getWidgets());
            this.parser.setListenersServed(this.locationUI.getListenersServed());
        } else if (this.parser.getListenersServed() != null) {
            this.locationUI.setListenersServed(this.parser.getListenersServed());
        }
        this.locationUI.initialize(composite, this.page.getSelectedElement());
        this.logLocationTab.setControl((Control)composite);
        this.setOKButtonEnabled(this.isTabFolderComplete());
    }

    public void initializeUIFromLogElement() {
        LogParserItem parser = this.page.getSelectedElement().getParser();
        this.hostUI.initialize(this.page.getSelectedElement());
        Composite composite = this.locationUI.getCompositeFor(parser);
        if (composite == null) {
            composite = this.locationUI.createControl((Composite)this.details, parser);
            parser.setWidgets(this.locationUI.getWidgets());
            parser.setListenersServed(this.locationUI.getListenersServed());
        } else if (parser.getListenersServed() != null) {
            this.locationUI.setListenersServed(parser.getListenersServed());
        }
        this.locationUI.initializeUIFromLogElement(composite, this.page.getSelectedElement());
        this.logLocationTab.setControl((Control)composite);
        this.locationUI.notifyListeners(composite);
        this.destinationUI.initializeUIFromLogElement(this.page.getSelectedElement());
    }

    public boolean isTabFolderComplete() {
        return this.parser != null && this.hostUI.isTabItemComplete() && this.locationUI.isTabItemComplete() && this.destinationUI.isTabItemComplete();
    }

    public void setOKButtonEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public LogParserItem getSelectedParser() {
        return this.parser;
    }

    public Map getParserRegistry() {
        return this.page.getLogSetManager().getParserRegistry();
    }

    public void setSelectedParser(LogParserItem newParser) {
        if (this.parser != newParser && this.parser != null) {
            this.parser = newParser;
            this.initializeLocation();
        }
        this.parser = newParser;
    }

    public void setWindowTitle(String title) {
        this.title = title;
    }

    public boolean finish() {
        this.getLogFileElement().setParser(this.parser);
        return this.hostUI.finish() && this.locationUI.finish() && this.destinationUI.finish();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.item == this.logLocationTab) {
            this.locationUI.enableButtons(this.locationUI.getCompositeFor(this.parser));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void okPressed() {
        if (!this.finish()) {
            return;
        }
        this.parserUI.dispose();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.parserUI.dispose();
        super.cancelPressed();
    }

    public void updateListenersServed(Vector listenersServed) {
        if (this.parser != null) {
            this.parser.setListenersServed(listenersServed);
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        LogFileElement logElem = this.page.getSelectedElement();
        this.setOKButtonEnabled(this.isTabFolderComplete());
        return control;
    }

    public LogFileElement getLogFileElement() {
        return this.page.getSelectedElement();
    }
}

