/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.LogSetDialog;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LogSetUI
implements Listener,
SelectionListener {
    private Text txtLogSetName;
    private LogSetDialog dialog;
    private org.eclipse.swt.widgets.List lstLogSets;
    private Button btnRename;
    private Button btnRemove;
    private Label lblError;

    public LogSetUI(LogSetDialog dialog) {
        this.dialog = dialog;
    }

    public void createContent(Composite parent, int type) {
        Composite result = new Composite(parent, 0);
        GridData data = GridUtil.createFill();
        data.widthHint = 400;
        result.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        this.createWidgets(result, type);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.txtLogSetName) {
            if (this.txtLogSetName.getText().length() == 0 || this.dialog.getLogSets().get(this.txtLogSetName.getText()) != null) {
                this.dialog.setOKButtonEnabled(false);
            } else {
                this.dialog.setOKButtonEnabled(true);
            }
            if (this.dialog.getLogSets().get(this.txtLogSetName.getText()) != null) {
                this.lblError.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOGSET_ERR"));
            } else {
                this.lblError.setText("");
            }
            this.dialog.setDefaultLogSet(this.txtLogSetName.getText());
        } else if (event.widget == this.lstLogSets) {
            if (!this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()).equals(this.dialog.getDefaultLogSet())) {
                this.dialog.setLogSetSelectionChanged(true);
            }
            this.dialog.setDefaultLogSet(this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()));
        } else if (event.widget == this.btnRename) {
            LogSetDialog dlg = new LogSetDialog(this.dialog.getShell(), 3);
            dlg.setLogSets(this.dialog.getLogSets());
            dlg.setLogSetName(this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()));
            int i = this.lstLogSets.getSelectionIndex();
            if (dlg.open() == 0) {
                this.renameLogSet(i, this.lstLogSets.getItem(i), dlg.getDefaultLogSet());
            }
        } else if (event.widget == this.btnRemove) {
            Map logSets = this.dialog.getLogSets();
            String logSet = this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex());
            logSets.remove(logSet);
            this.lstLogSets.remove(this.lstLogSets.getSelectionIndex());
            if (logSet.equals(this.dialog.getDefaultLogSet())) {
                if (this.lstLogSets.getItemCount() > 0) {
                    this.dialog.setDefaultLogSet(this.lstLogSets.getItem(0));
                } else {
                    this.dialog.setDefaultLogSet(null);
                }
                this.dialog.setLogSetSelectionChanged(true);
            }
            if (logSet.equals(this.dialog.getCurrentLogSet())) {
                this.dialog.setCurrentLogSetChanged(true);
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.btnRemove != null && this.btnRename != null) {
            if (this.lstLogSets.getSelectionIndex() < 0) {
                this.btnRemove.setEnabled(false);
                this.btnRename.setEnabled(false);
            } else if (this.lstLogSets.getItemCount() == 1) {
                this.btnRemove.setEnabled(false);
                if (this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()).equals(LogUIPlugin.getResourceString("STR_IMPORT_DEFAULT_LOGSET"))) {
                    this.btnRename.setEnabled(false);
                } else {
                    this.btnRename.setEnabled(true);
                }
            } else if (this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()).equals(LogUIPlugin.getResourceString("STR_IMPORT_DEFAULT_LOGSET"))) {
                this.btnRemove.setEnabled(false);
                this.btnRename.setEnabled(false);
            } else {
                this.btnRemove.setEnabled(true);
                this.btnRename.setEnabled(true);
            }
        }
    }

    private void createWidgets(Composite result, int type) {
        switch (type) {
            case 0: {
                this.createNewLogSetUI(result);
                break;
            }
            case 1: {
                this.createOpenLogSetUI(result);
                break;
            }
            case 2: {
                this.createEditLogSetUI(result);
                break;
            }
            case 3: {
                this.createRenameLogSetUI(result);
            }
        }
    }

    private void createNewLogSetUI(Composite result) {
        Label desc = new Label(result, 64);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        data.heightHint = this.computeLabelMinHeight(desc);
        desc.setLayoutData((Object)data);
        desc.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_MSG"));
        this.createSpace(result);
        Label log_set = new Label(result, 0);
        data = new GridData(1);
        log_set.setLayoutData((Object)data);
        log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_LBL"));
        this.txtLogSetName = new Text(result, 2048);
        data = GridUtil.createHorizontalFill();
        this.txtLogSetName.setLayoutData((Object)data);
        this.lblError = new Label(result, 64);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this.lblError.setLayoutData((Object)data);
        this.lblError.setForeground(JFaceColors.getErrorText((Display)this.dialog.getShell().getDisplay()));
        this.txtLogSetName.addListener(24, (Listener)this);
    }

    private void createRenameLogSetUI(Composite result) {
        Label log_set = new Label(result, 0);
        GridData data = new GridData(1);
        log_set.setLayoutData((Object)data);
        log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_LBL"));
        this.txtLogSetName = new Text(result, 2048);
        data = GridUtil.createHorizontalFill();
        this.txtLogSetName.setLayoutData((Object)data);
        this.txtLogSetName.setText(this.dialog.getLogSetName() != null ? this.dialog.getLogSetName() : "");
        this.txtLogSetName.selectAll();
        this.lblError = new Label(result, 64);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this.lblError.setLayoutData((Object)data);
        this.lblError.setForeground(JFaceColors.getErrorText((Display)this.dialog.getShell().getDisplay()));
        this.txtLogSetName.addListener(24, (Listener)this);
    }

    private void createOpenLogSetUI(Composite result) {
        Label desc = new Label(result, 64);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        data.heightHint = this.computeLabelMinHeight(desc);
        desc.setLayoutData((Object)data);
        desc.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_MSG"));
        this.createSpace(result);
        Label log_set = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        log_set.setLayoutData((Object)data);
        log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SETS"));
        this.lstLogSets = new org.eclipse.swt.widgets.List(result, 2816);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this.lstLogSets.setLayoutData((Object)data);
        this.loadLogSetsList();
        this.selectDefaultLogSet();
        this.lstLogSets.addListener(13, (Listener)this);
        this.lstLogSets.addSelectionListener((SelectionListener)this);
    }

    private void createEditLogSetUI(Composite result) {
        Label desc = new Label(result, 64);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        desc.setLayoutData((Object)data);
        desc.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_MSG"));
        this.createSpace(result);
        Label log_set = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        log_set.setLayoutData((Object)data);
        log_set.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SETS"));
        this.lstLogSets = new org.eclipse.swt.widgets.List(result, 2816);
        data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        this.lstLogSets.setLayoutData((Object)data);
        Composite buttons = new Composite(result, 0);
        result.setLayoutData((Object)GridUtil.createFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        buttons.setLayout((Layout)layout);
        this.btnRename = new Button(buttons, 8);
        int len = this.computeButtonsMinWidth((Control)this.btnRename);
        this.btnRename.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_RENAME_SET"));
        GridData btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.btnRename.setLayoutData((Object)btnData);
        this.btnRemove = new Button(buttons, 8);
        this.btnRemove.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE_SET"));
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.btnRemove.setLayoutData((Object)btnData);
        this.loadLogSetsList();
        this.selectDefaultLogSet();
        this.lstLogSets.addListener(13, (Listener)this);
        this.btnRename.addListener(13, (Listener)this);
        this.btnRemove.addListener(13, (Listener)this);
        this.updateButtons();
    }

    private void loadLogSetsList() {
        Set logSets = this.dialog.getLogSets().keySet();
        Iterator iter = logSets.iterator();
        while (iter.hasNext()) {
            this.lstLogSets.add((String)iter.next());
        }
    }

    private void createSpace(Composite parent) {
        Label space = new Label(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        space.setLayoutData((Object)data);
    }

    private void renameLogSet(int i, String oldName, String newName) {
        Map logSets = this.dialog.getLogSets();
        List logList = (List)logSets.get(oldName);
        logSets.remove(oldName);
        logSets.put(newName, logList);
        this.lstLogSets.remove(i);
        this.lstLogSets.add(newName, i);
        if (oldName.equals(this.dialog.getDefaultLogSet())) {
            this.dialog.setDefaultLogSet(newName);
        }
        if (oldName.equals(this.dialog.getCurrentLogSet())) {
            this.dialog.setCurrentLogSetChanged(true);
        }
    }

    private void selectDefaultLogSet() {
        String defaultLogSet = this.dialog.getDefaultLogSet();
        if (defaultLogSet != null) {
            this.lstLogSets.setSelection(new String[]{defaultLogSet});
        }
    }

    private int computeButtonsMinWidth(Control control) {
        String sRename = LogUIPlugin.getResourceString("STR_IMPORT_LOG_RENAME_SET");
        String sRemove = LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE_SET");
        int maxLen = Math.max(sRename.length(), sRemove.length());
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fm = gc.getFontMetrics();
        return Math.max(Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)(maxLen + 4)), 90);
    }

    private int computeLabelMinHeight(Label label) {
        GC gc = new GC((Drawable)label);
        gc.setFont(label.getFont());
        FontMetrics fm = gc.getFontMetrics();
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fm, (int)2) + 5;
    }

    public String getLogSetName() {
        if (this.txtLogSetName != null) {
            return this.txtLogSetName.getText();
        }
        if (this.lstLogSets != null) {
            return this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex());
        }
        return null;
    }

    public String[] getLogSets() {
        if (this.lstLogSets != null) {
            return this.lstLogSets.getItems();
        }
        return null;
    }

    public void setTextSelection() {
        this.txtLogSetName.selectAll();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        int i = this.lstLogSets.getSelectionIndex();
        if (i > -1 && !this.lstLogSets.getItem(i).equals(this.dialog.getDefaultLogSet())) {
            this.dialog.setLogSetSelectionChanged(true);
        }
        this.dialog.setDefaultLogSet(this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()));
        this.dialog.close();
    }
}

