/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.SecurityImages;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.SecurityUI;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class ImportSecurityCertificatePage
extends WizardPage
implements Listener {
    private SecurityUI _securityUI;

    public ImportSecurityCertificatePage(IWorkbench workbench, IStructuredSelection selection) {
        super(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PTITLE"));
        this.setTitle(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PTITLE"));
        this.setDescription(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PDESC"));
        this.setImageDescriptor(SecurityImages.getImageDescriptor("import_cert_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
        Shell shell = this.getShell();
        this._securityUI = new SecurityUI(shell);
        this._securityUI.createContents(composite);
        this._securityUI.registerListener(this);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    protected boolean determinePageCompletion() {
        boolean complete = this._securityUI.validateDialog();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    public boolean finish() {
        KeyStore ks;
        String path = this._securityUI.getPath();
        String storePath = SecurityPlugin.getKeyStoreLocation();
        String passw = SecurityPlugin.getWorkspaceName();
        String exc_msg = "";
        try {
            ks = this.getKeyStore();
            this._securityUI.loadCertificate(ks);
        }
        catch (FileNotFoundException e) {
            String text = SecurityPlugin.getResourceString("STR_KEY_IO_ERROR_");
            text = TString.change(text, "%1", this._securityUI.getPath());
            String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (IOException e) {
            String text = SecurityPlugin.getResourceString("STR_LOAD_IO_EXC_");
            text = TString.change(text, "%1", this._securityUI.getPath());
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (CertificateException exc) {
            String text = SecurityPlugin.getResourceString("STR_CERTIFICATE_EXC_");
            text = TString.change(text, "%1", this._securityUI.getPath());
            String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (KeyStoreException exc) {
            String text = SecurityPlugin.getResourceString("STR_KEY_STORE_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (NoSuchProviderException exc2) {
            String text = SecurityPlugin.getResourceString("STR_SECURITY_PROVIDER_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("STR_INITIALIZE_ERROR_");
            msg = TString.change(msg, "%1", SecurityPlugin.getKeyStoreLocation());
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc2);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (NoSuchAlgorithmException exc2) {
            String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc2);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        try {
            KeystoreHelper.persistKeyStore((KeyStore)ks, (String)storePath, (String)passw);
        }
        catch (IOException e) {
            String text = SecurityPlugin.getResourceString("STR_IO_SAVE_ERROR_");
            text = TString.change(text, "%1", storePath);
            String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (CertificateException exc) {
            String text = SecurityPlugin.getResourceString("STR_CERTIFICATE_STORE_ERROR_");
            text = TString.change(text, "%1", storePath);
            String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (KeyStoreException exc) {
            String text = SecurityPlugin.getResourceString("STR_UNINIT_KEYSTORE_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        catch (NoSuchAlgorithmException exc2) {
            String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc2);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            return false;
        }
        return true;
    }

    public void handleEvent(Event e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    private KeyStore getKeyStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        return KeystoreHelper.createKeyStore((String)SecurityPlugin.getKeyStoreLocation(), (String)SecurityPlugin.getWorkspaceName());
    }
}

