/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.models.internal.sdb.loader.SDBLoader;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;

public class ImportSymptomDBPage2
extends WizardDataTransferPage
implements Listener,
ModifyListener,
SelectionListener,
IRunnableWithProgress {
    private Button _localHost;
    private Button _remoteHost;
    private Label _localLabel;
    private Text _localFileText;
    private Button _sourceBrowse;
    private Button _browseLocation;
    private Label _urlLabel;
    private Combo _urlText;
    private Text _location;
    private Text _targetFileName;
    private Button _overwriteCheckbox;
    private Button _createFolderCheckbox;
    private Button _loadDBCheckbox;
    private Button _openEditorCheckbox;
    private String fError;
    private IStructuredSelection fSelection;
    private final String _dbname = "symptomdb.trcdbxmi";
    private String _xmiFile;
    private String _xmlFile;
    private String _urlFile;
    private boolean _isLocalHost;
    private ArrayList _urlList = new ArrayList();

    public ImportSymptomDBPage2(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("xmlTraceFileImportPage1");
        this.setTitle(SDbPlugin.getResourceString("IMPORT_SYMPTOM_DB_PTITLE"));
        this.setDescription(SDbPlugin.getResourceString("IMPORT_SYMPTOM_DB_PDESC"));
        this.setImageDescriptor(SDbPluginImages.getImageDescriptor("import_symptomdb_wiz.gif"));
        this.fSelection = selection;
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData data = new GridData(256);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        data.widthHint = this.convertHorizontalDLUsToPixels(63);
        button.setLayoutData((Object)data);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        return button;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, SDbPlugin.getResourceString("STR_IMPORT_SYMPTOMDB_PSOURCEQ"));
        Composite result = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        result.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        result.setLayoutData((Object)data);
        Label locationLabel = new Label(result, 0);
        locationLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_LOCATION"));
        this._location = new Text(result, 2048);
        this._location.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._browseLocation = new Button(result, 0);
        this._browseLocation.setText(SDbPlugin.getResourceString("STR_IMPORT_XMLLOG_BROWSE"));
        locationLabel = new Label(result, 0);
        locationLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_FILE_LOCATION"));
        this._targetFileName = new Text(result, 2048);
        this._targetFileName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.createSpacer(composite);
        this.createPlainLabel(composite, SDbPlugin.getResourceString("ImportDBWizardPage.options"));
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
        this._location.addModifyListener((ModifyListener)this);
        this._localFileText.addModifyListener((ModifyListener)this);
        this._targetFileName.addModifyListener((ModifyListener)this);
        this._browseLocation.addSelectionListener((SelectionListener)this);
        this.initData();
        WorkbenchHelp.setHelp((Control)this._location, (String)ContextIds.IMPORT_SYMDB_LOCATION);
        WorkbenchHelp.setHelp((Control)this._targetFileName, (String)ContextIds.IMPORT_SYMDB_FILE);
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        optionsGroup.setLayout((Layout)layout);
        this._overwriteCheckbox = new Button(optionsGroup, 16416);
        this._overwriteCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.override.text"));
        this._createFolderCheckbox = new Button(optionsGroup, 16416);
        this._createFolderCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.create.folder.str"));
        this._createFolderCheckbox.setSelection(true);
        this._loadDBCheckbox = new Button(optionsGroup, 16416);
        this._loadDBCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.options.load"));
        this._loadDBCheckbox.setSelection(true);
        this._openEditorCheckbox = new Button(optionsGroup, 16416);
        this._openEditorCheckbox.setText(SDbPlugin.getResourceString("ImportDBWizardPage.options.openEditor"));
        this._openEditorCheckbox.setSelection(true);
        WorkbenchHelp.setHelp((Control)this._overwriteCheckbox, (String)ContextIds.IMPORT_SYMDB_OVERRIDE_RESOURCE);
        WorkbenchHelp.setHelp((Control)this._createFolderCheckbox, (String)ContextIds.IMPORT_SYMDB_CREATE_FOLDER);
    }

    private String createModel() {
        this._isLocalHost = this._localHost.getSelection();
        this._xmlFile = this._localFileText.getText().trim();
        this._xmiFile = this._location.getText().trim() + File.separator + this._targetFileName.getText().trim();
        this._urlFile = "";
        int i = this._urlText.getSelectionIndex();
        if (i >= 0 && i < this._urlList.size()) {
            this._urlFile = ((ColumnData)this._urlList.get(i)).url();
        }
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
        return this.fError;
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceGrp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        GridData data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        sourceGrp.setLayout((Layout)layout);
        sourceGrp.setLayoutData((Object)data);
        this._remoteHost = new Button(sourceGrp, 16);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        this._remoteHost.setLayoutData((Object)data);
        this._remoteHost.setText(SDbPlugin.getResourceString("STR_IMPORT_REMOTEHOST"));
        this._remoteHost.setSelection(true);
        this._urlLabel = new Label(sourceGrp, 0);
        data = new GridData();
        data.horizontalIndent = 20;
        this._urlLabel.setLayoutData((Object)data);
        this._urlLabel.setText(SDbPlugin.getResourceString("STR_IMPORT_URL"));
        this._urlText = new Combo(sourceGrp, 2056);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._urlText.setLayoutData((Object)data);
        this._urlText.addModifyListener((ModifyListener)this);
        Label label = new Label(sourceGrp, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this._localHost = new Button(sourceGrp, 16);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        this._localHost.setLayoutData((Object)data);
        this._localHost.setText(SDbPlugin.getResourceString("STR_IMPORT_LOCALHOST"));
        Composite localComp = new Composite(sourceGrp, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        data.widthHint = 300;
        localComp.setLayout((Layout)layout);
        localComp.setLayoutData((Object)data);
        this._localLabel = new Label(localComp, 0);
        data = new GridData();
        data.horizontalIndent = 15;
        this._localLabel.setLayoutData((Object)data);
        this._localLabel.setText(SDbPlugin.getResourceString("STR_IMPORT_SYMPTOM_DB_SOURCE"));
        this._localFileText = new Text(localComp, 2048);
        data = GridUtil.createHorizontalFill();
        this._localFileText.setLayoutData((Object)data);
        this._sourceBrowse = new Button(localComp, 8);
        this._sourceBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));
        this._sourceBrowse.addListener(13, (Listener)this);
        this._localHost.addSelectionListener((SelectionListener)this);
        this.enableSourceGroup();
        this._localFileText.setFocus();
        IPreferenceStore store = SDbPlugin.getDefault().getPreferenceStore();
        String SymDBFileName = store.getString("SymDBFileName");
        if (SymDBFileName != null && !SymDBFileName.equals("")) {
            this._localFileText.setText(SymDBFileName);
        }
        WorkbenchHelp.setHelp((Control)this._localHost, (String)ContextIds.IMPORT_SYMDB_HOST_LOCAL);
        WorkbenchHelp.setHelp((Control)this._localFileText, (String)ContextIds.IMPORT_SYMDB_HOST_LOCAL);
        WorkbenchHelp.setHelp((Control)this._remoteHost, (String)ContextIds.IMPORT_SYMDB_HOST_REMOTE);
        WorkbenchHelp.setHelp((Control)this._urlText, (String)ContextIds.IMPORT_SYMDB_HOST_REMOTE);
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    public boolean finish() {
        block11: {
            int idx;
            Path targetFileName;
            String ext;
            if (this._localFileText.getText().trim().length() > 0) {
                IPreferenceStore store = SDbPlugin.getDefault().getPreferenceStore();
                store.setValue("SymDBFileName", this._localFileText.getText().trim());
            }
            if ((ext = (targetFileName = new Path(this._targetFileName.getText().trim())).getFileExtension()) == null || !ext.equals("trcdbxmi")) {
                String errMsg = SDbPlugin.getResourceString("STR_FINISH_IMPORT_ERROR_");
                String err = SDbPlugin.getResourceString("STR_DB_EXT_REASON_");
                Status err1 = new Status(1, "org.eclipse.core.resources", 566, err, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg, (IStatus)err1);
                this._targetFileName.setFocus();
                this._targetFileName.selectAll();
                return false;
            }
            this.fError = "";
            IWorkspace workbench = ResourcesPlugin.getWorkspace();
            Object container = null;
            Path path = new Path(this._location.getText().trim());
            container = this._createFolderCheckbox.getSelection() ? this.createContainer((IPath)path) : ((idx = path.segmentCount()) == 1 ? workbench.getRoot().getProject(path.toString()) : workbench.getRoot().getFolder((IPath)path));
            if (container == null || !container.exists()) {
                String errMsg = SDbPlugin.getResourceString("STR_FINISH_IMPORT_ERROR_");
                String err = SDbPlugin.getResourceString("STR_PATH_NOT_FOUND_REASON_");
                Status err1 = new Status(1, "org.eclipse.core.resources", 566, err, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg, (IStatus)err1);
                return false;
            }
            if (!this._overwriteCheckbox.getSelection() && container.exists((IPath)targetFileName)) {
                String msg = SDbPlugin.getResourceString("STR_FILE_EXISTS");
                msg = TString.change(msg, "%1", this._location.getText().trim() + File.separator + this._targetFileName.getText());
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)msg)) {
                    return false;
                }
            }
            this.fError = this.createModel();
            if (this.fError != null && !this.fError.equals("")) {
                String errMsg = SDbPlugin.getResourceString("STR_LOAD_XML_ERROR_");
                Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg, (IStatus)err1);
                return false;
            }
            if (this.fError == null || this.fError != null && this.fError.length() == 0) {
                this.savePreference(this._loadDBCheckbox.getSelection());
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            boolean shouldSwitch = false;
            shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", SDbPlugin.getResourceString("CONFIRM_PERSP_SWITCH_MSG"));
            if (shouldSwitch) {
                UIPlugin.getActivePage();
            }
            if (!"org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) break block11;
            try {
                TreeNavigator nav = (TreeNavigator)UIPlugin.getActivePage().showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
                nav.getViewer().refresh();
                if (this._openEditorCheckbox.getSelection()) {
                    IFile file = (IFile)container.findMember((IPath)targetFileName);
                    IDE.openEditor((IWorkbenchPage)UIPlugin.getActivePage(), (IFile)file, (boolean)true);
                }
            }
            catch (Exception e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }
        return true;
    }

    public void handleEvent(Event event) {
        if (event.widget == this._sourceBrowse) {
            this.handle_sourceBrowsePressed();
        }
    }

    protected void handle_sourceBrowsePressed() {
        String currentSource = this._localFileText.getText();
        FileDialog dlg = new FileDialog(this._localFileText.getShell());
        dlg.setFilterPath(currentSource);
        dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dlg.open();
        String fileName = dlg.getFileName();
        if (fileName != null && !fileName.equals("")) {
            this._localFileText.setText(dlg.getFilterPath() + File.separator + fileName);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    public void run(IProgressMonitor mon) {
        block10: {
            String destination = "";
            if (this._xmiFile.startsWith("\\") || this._xmiFile.startsWith("/")) {
                this._xmiFile = this._xmiFile.substring(1);
            }
            this._xmiFile = new Path(this._xmiFile).toString();
            destination = "platform:/resource/" + this._xmiFile;
            if (this._isLocalHost) {
                try {
                    SDBLoader l = new SDBLoader();
                    l.loadDatabase(this._xmlFile, destination, mon);
                    this.fError = l.getErrorMessage();
                }
                catch (Exception exc) {
                    if (this.fError != null && (this.fError == null || this.fError.length() != 0)) break block10;
                    this.fError = SDbPlugin.getResourceString("STR_EXC_REASON_");
                }
            } else {
                try {
                    URL url = new URL(this._urlFile);
                    InputStream is = url.openStream();
                    if (is != null) {
                        SDBLoader l = new SDBLoader();
                        l.loadDatabase(is, this._urlFile, destination, mon);
                        this.fError = l.getErrorMessage();
                    }
                }
                catch (MalformedURLException exc) {
                    this.fError = SDbPlugin.getResourceString("STR_MALFORMEDURLEXC_REASON_");
                }
                catch (IOException exc1) {
                    this.fError = SDbPlugin.getResourceString("STR_IOEXC_REASON_");
                }
                catch (Exception e) {
                    this.fError = SDbPlugin.getResourceString("STR_EXC_REASON_");
                }
            }
        }
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateOptionsGroup() {
        return !this._location.getText().trim().equals("") && !this._targetFileName.getText().trim().equals("");
    }

    protected boolean validateSourceGroup() {
        return this._localHost.getSelection() && !this._localFileText.getText().trim().equals("") || !this._localHost.getSelection() && !this._urlText.getText().trim().equals("");
    }

    private void showResourceDialog() {
        Object[] result;
        ContainerSelectionDialog dialog;
        Path path = new Path(this._location.getText().trim());
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        IContainer cont = null;
        if (res != null && res.exists() && res instanceof IContainer) {
            cont = (IContainer)res;
        }
        if ((dialog = new ContainerSelectionDialog(this.getShell(), cont, true, SDbPlugin.getResourceString("STR_RES_DLG_MSG"))).open() == 0 && (result = dialog.getResult()) != null && result.length == 1 && result[0] != null) {
            this._location.setText(((IPath)result[0]).toOSString());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._browseLocation) {
            this.showResourceDialog();
        } else if (e.widget == this._localHost) {
            this.enableSourceGroup();
            this.setPageComplete(this.determinePageCompletion());
        }
    }

    private void initData() {
        if (this.fSelection != null && !this.fSelection.isEmpty()) {
            Object elem = this.fSelection.getFirstElement();
            if (elem == null) {
                return;
            }
            if (elem instanceof IProject || elem instanceof IFolder) {
                this._location.setText(((IResource)elem).getFullPath().toOSString());
            } else if (elem instanceof IFile) {
                this._location.setText(((IResource)elem).getFullPath().removeLastSegments(1).toOSString());
            }
        }
        if (this._location.getText().equals("")) {
            this._location.setText("LogAnalyzerProject");
        }
        this._localHost.setSelection(false);
        this._remoteHost.setSelection(true);
        this.enableSourceGroup();
        String urls = SDbPlugin.getDefault().getPreferenceStore().getString("symptom_db_url");
        if (urls != null && !urls.equals("")) {
            int idx = urls.indexOf("\n");
            while (idx != -1) {
                String value = urls.substring(0, idx);
                int i = value.indexOf("\t");
                if (i != -1) {
                    ColumnData data = new ColumnData(value.substring(0, i), value.substring(i + 1));
                    this._urlList.add(data);
                }
                urls = urls.substring(idx + 1);
                idx = urls.indexOf("\n");
            }
            int i = urls.indexOf("\t");
            if (i != -1) {
                ColumnData data = new ColumnData(urls.substring(0, i), urls.substring(i + 1));
                this._urlList.add(data);
            }
        }
        int i = 0;
        while (i < this._urlList.size()) {
            this._urlText.add(((ColumnData)this._urlList.get(i)).name() + " [ " + ((ColumnData)this._urlList.get(i)).url() + " ] ");
            ++i;
        }
        if (this._urlText.getItemCount() > 0) {
            this._urlText.setText(this._urlText.getItem(0));
        }
        this._targetFileName.setText("symptomdb.trcdbxmi");
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            String seg = path.segment(idx);
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                        project.open(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
        return container;
    }

    private void enableSourceGroup() {
        this._localFileText.setEnabled(this._localHost.getSelection());
        this._localLabel.setEnabled(this._localHost.getSelection());
        this._sourceBrowse.setEnabled(this._localHost.getSelection());
        this._urlText.setEnabled(!this._localHost.getSelection());
        this._urlLabel.setEnabled(!this._localHost.getSelection());
    }

    private void savePreference(boolean check) {
        IPreferenceStore store = SDbPlugin.getDefault().getPreferenceStore();
        String prefPath = store.getString("symptom_db_path");
        int i = prefPath.indexOf(this._xmiFile);
        StringBuffer sdbPath = new StringBuffer();
        if (i > -1) {
            sdbPath.append(prefPath);
            sdbPath.replace(i + this._xmiFile.length() + 1, i + this._xmiFile.length() + 2, check ? "1" : "0");
        } else {
            if (prefPath.length() > 0) {
                sdbPath.append(prefPath);
                sdbPath.append(";");
            }
            sdbPath.append("/");
            sdbPath.append(this._xmiFile);
            sdbPath.append(",");
            sdbPath.append(check ? 1 : 0);
        }
        store.setValue("symptom_db_path", sdbPath.toString());
    }

    public void set_isLocalHost(boolean localHost) {
        this._isLocalHost = localHost;
    }

    public void set_localFileText(Text fileText) {
        this._localFileText = fileText;
    }

    class ColumnData {
        private String _name;
        private String _url;

        public ColumnData(String name, String url) {
            this._name = name;
            this._url = url;
        }

        public String name() {
            return this._name;
        }

        public String url() {
            return this._url;
        }

        public void name(String name) {
            this._name = name;
        }

        public void url(String url) {
            this._url = url;
        }
    }
}

