/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Hyades Test UI plugin.
 *  
 * @author marcelop
 * @since 0.0.1
 */
public class TestUIImages
extends ImageManager
{
	/**
	 * HyadesUIImages' singleton.
	 */
	public static final TestUIImages INSTANCE = new TestUIImages();
	
	/*
	 * Available cached Images in the Java plugin image registry.
	 */
	public static final String IMG_WIZBAN_NEWTESTSUITE 		= "newtestsuite_wiz.gif";
	public static final String IMG_WIZBAN_NEWDEPLOYMENT		= "newdeployment_wiz.gif";
	public static final String IMG_WIZBAN_RUN		        = "run_wiz.gif";

	public static final String IMG_FORM_BANNER	            = "form_banner.gif";
	
	public static final String IMG_TEST_SUITE 				= "testsuite_obj.gif";
	public static final String IMG_TEST_CASE 				= "testcase_obj.gif";
	public static final String IMG_TEST_COMPONENT			= "testcomponent_obj.gif";
	public static final String IMG_ARBITER   				= "arbiter_obj.gif";
	public static final String IMG_DEPLOYMENT 				= "deployment_obj.gif";
	public static final String IMG_DEPLOYMENT_SPEC			= "deployspec_obj.gif";
	public static final String IMG_LOCATION      			= "location_obj.gif";	
	public static final String IMG_REPORT 				    = "report_obj.gif";
	public static final String IMG_BEHAVIOR				    = "behavior_obj.gif";
	public static final String IMG_SUT   				    = "sut_obj.gif";
	public static final String IMG_EXECUTION			    = "execution_obj.gif";

	public static final String IMG_EVENT_EXECUTION		    = "eveexecution_obj.gif";
	public static final String IMG_EVENT_INVOCATION		    = "eveinvocation_obj.gif";
	public static final String IMG_EVENT_MESSAGE		    = "evemessage_obj.gif";
	public static final String IMG_EVENT_TYPED			    = "evetyped_obj.gif";
	public static final String IMG_EVENT_VERDICT		    = "eveverdict_obj.gif";

	public static final String IMG_UNCHECKED 				= "unchecked_obj.gif";
	public static final String IMG_ERROR		 		    = "error_obj.gif";
		
	public static final String ACT_SHOW_FOLDER			    = "showfolders_co.gif";
	public static final String ACT_SHOW_EOBJECT_CHILDREN    = "showchild_co.gif";
	public static final String ACT_NEW_TEST_SUITE 		    = "newtestsuite_wiz.gif";
	public static final String ACT_NEW_DEPLOYMENT		    = "newdeployment_wiz.gif";
	public static final String ACT_DOWN					    = "down_nav.gif";
	public static final String ACT_UP					    = "up_nav.gif";
	
	public static final String IMG_DEFAULT 					= IMG_UNCHECKED;

	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_NEWTESTSUITE);
		add(T_WIZBAN, IMG_WIZBAN_RUN);		
		add(T_WIZBAN, IMG_WIZBAN_NEWDEPLOYMENT);
		add(T_WIZBAN, IMG_FORM_BANNER);

		add(T_OBJ, IMG_TEST_SUITE);
		add(T_OBJ, IMG_TEST_CASE);
		add(T_OBJ, IMG_TEST_COMPONENT);
		add(T_OBJ, IMG_ARBITER);
		add(T_OBJ, IMG_DEPLOYMENT);
		add(T_OBJ, IMG_DEPLOYMENT_SPEC);
		add(T_OBJ, IMG_LOCATION);		
		add(T_OBJ, IMG_REPORT);
		add(T_OBJ, IMG_BEHAVIOR);
		add(T_OBJ, IMG_SUT);
		add(T_OBJ, IMG_EXECUTION);

		add(T_OBJ, IMG_EVENT_EXECUTION);
		add(T_OBJ, IMG_EVENT_INVOCATION);		
		add(T_OBJ, IMG_EVENT_MESSAGE);
		add(T_OBJ, IMG_EVENT_TYPED);
		add(T_OBJ, IMG_EVENT_VERDICT);

		add(T_OBJ, IMG_UNCHECKED);
		add(T_OBJ, IMG_ERROR);

		add("c", T_LCL, ACT_SHOW_FOLDER);
		add("d", T_LCL, ACT_SHOW_FOLDER);
		add("e", T_LCL, ACT_SHOW_FOLDER);

		add("c", T_LCL, ACT_SHOW_EOBJECT_CHILDREN);
		add("d", T_LCL, ACT_SHOW_EOBJECT_CHILDREN);
		add("e", T_LCL, ACT_SHOW_EOBJECT_CHILDREN);

		add("c", T_TOOL, ACT_NEW_TEST_SUITE);
		add("e", T_TOOL, ACT_NEW_TEST_SUITE);
		add("c", T_TOOL, ACT_NEW_DEPLOYMENT);
		add("e", T_TOOL, ACT_NEW_DEPLOYMENT);

		add("c", T_LCL, ACT_DOWN);
		add("d", T_LCL, ACT_DOWN);
		add("e", T_LCL, ACT_DOWN);		

		add("c", T_LCL, ACT_UP);
		add("d", T_LCL, ACT_UP);
		add("e", T_LCL, ACT_UP);		
	}	
}
