/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.jface.viewers.IStructuredSelection;

import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtil;
import org.eclipse.hyades.ui.HyadesUIImages;

/**
 * We are creating only machines at this moment.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class AddLocationAction 
extends AddDeploymentChildAction
{
	/**
	 * Constructor for AddLocationAction
	 */
	public AddLocationAction()
	{
		super(TestUIPlugin.getString("BTN_ADD"));
		
		setToolTipText(TestUIPlugin.getString("ACT_LOC_ADD_TIP"));
		setImageDescriptor(HyadesUIImages.INSTANCE.getImageDescriptor(HyadesUIImages.IMG_UI_NODE));
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getDeployment(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		TPFDeployment deployment = getDeployment(getStructuredSelection());
		
		CFGMachine machine = Common_ConfigurationFactory.eINSTANCE.createCFGMachine();
		machine.setName(TestUIUtil.getUniqueName(TestUIPlugin.getString("W_LOC"), deployment.getLocations()));
		String hostName = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.DEFAULT_HOST_NAME);
		if(hostName != null)
			machine.setHostName(hostName);
		machine.getArtifacts().add(Common_ConfigurationFactory.eINSTANCE.createCFGArtifact());
			
		deployment.getLocations().add(machine);
	}	
}
