/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class InvocationEventDetailPage 
extends DetailSection.DetailPage
{
	private StyledText statusText;
	private StyledText reasonText;

	private TPFInvocationEvent invocationEvent;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		invocationEvent = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_VERD"));
		statusText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		statusText.setLayoutData(GridDataUtil.createHorizontalFill());
		statusText.setEditable(false);

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_REASON"));
		reasonText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		reasonText.setLayoutData(GridDataUtil.createHorizontalFill());
		reasonText.setEditable(false);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		invocationEvent = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean objectIsSet = false;
		if(object instanceof TPFInvocationEvent)
		{
			invocationEvent = (TPFInvocationEvent)object;
			if(invocationEvent != null)
			{		
				objectIsSet = true;
				
				if(invocationEvent.getStatus() != null)
					statusText.setText(invocationEvent.getStatus().getLabel());
				else
					statusText.setText("");

				if(invocationEvent.getReason() != null)
					reasonText.setText(invocationEvent.getReason().getLabel());
				else
					reasonText.setText("");
			}						
		}
		
		if(!objectIsSet)
		{
			statusText.setText("");
			reasonText.setText("");
			statusText.setEditable(false);
			reasonText.setEditable(false);
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return invocationEvent;
	}
}
