package org.eclipse.hyades.test.collection.framework;

import java.awt.event.*;
import java.awt.*;
/*
 * Licensed Materials - Property of IBM,
 * WebSphere Studio Workbench
 * (c) Copyright IBM Corp 2000
 */
	
public class PerformanceExample extends Frame
{
  private final static String kCBIBMCopyright="(c) Copyright IBM Corporation 2001";

	Panel panel = new Panel();
	Button buttons[] = new Button[20];
	int numButtons = 0;

	public PerformanceExample()
	{
	    super("Performance Example");
	    	    	    	
	    panel.setLayout(new FlowLayout() );
	    add("Center", panel);        
	
	    Panel btnPanel = new Panel();
	
	    Button addBtn = new Button("Add");
	    
	    addBtn.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e)
	            {
	                addButton();
	            }
	    });
	    
	    btnPanel.add(addBtn);
	    Button removeBtn = new Button("Remove");
	    
	    removeBtn.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e)
	            {
	                removeButton();
	            }
	    });
	    
	    btnPanel.add(removeBtn);
	    add("North", btnPanel);        
	    
	    addWindowListener(new WindowAdapter() {
	        public void windowClosing(WindowEvent e)
	            {
	                System.exit(0);
	            }
	    });
	    
	}
	public void addButton() {
	    if ( numButtons < buttons.length ) {
	        
	        Button btn = new Button(String.valueOf( numButtons ) );
	        System.out.println("add button : " + btn);
	        buttons[numButtons++] = btn;
	        panel.add(btn);
	        panel.validate();
	        panel.repaint();
	    }
	    
	}
	static public void main(String args[])
	{
	    Frame frame = new PerformanceExample();
	    frame.setSize(300, 300);
	    frame.setVisible(true);
	}
	public void removeButton() {
	    if ( numButtons > 0 ) {
	        panel.remove(buttons[--numButtons]);
	        System.out.println("remove button : " + numButtons);
	         
	        panel.validate();
	        panel.repaint();
	        System.gc();
	    }
	    
	}
}
