/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;


public class ForwardReference {
    //~ Instance fields ----------------------------------------------------------------------------

    private EObject object;
    private EStructuralFeature feature;
    private String refId;

    //~ Constructors -------------------------------------------------------------------------------

    /**
     * @param currentChild
     * @param feature
     * @param value
     */
    public ForwardReference(EObject object, EStructuralFeature feature, String value) {
        super();
        this.object = object;
        this.feature = feature;
        this.refId = value;
    }

    //~ Methods ------------------------------------------------------------------------------------

    /**
     * @return EStructuralFeature
     */
    public EStructuralFeature getFeature() {
        return feature;
    }

    /**
     * @return EObject
     */
    public EObject getObject() {
        return object;
    }

    /**
     * @return String
     */
    public String getRefId() {
        return refId;
    }
}
