/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.hyades.loaders.util.*;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;


public class XMLagentCreateLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private String agentId;
    private String agentName;
    private String agentParameters;
    private String agentType;
    private String processIdRef;
    private String version;
    private double time;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (name.equals("agentId")) {
            agentId = value;
        } else if (name.equals("processIdRef")) {
            processIdRef = value;
        } else if (name.equals("agentName")) {
            agentName = value;
        } else if (name.equals("agentType")) {
            agentType = value;
        } else if (name.equals("time")) {
            time = Double.valueOf(value).doubleValue();
        } else if (name.equals("agentParameters")) {
            agentParameters = value;
        } else if (name.equals("version")) {
            version = value;
        }
    }

    public void addYourselfInContext() {
        /* This agent may be being added in context of itself, if this is the case, return */
        TRCAgent agent = context.getAgent();
        TRCAgentProxy agentProxy = context.getAgentProxy();

        if (agent != null) {
            String rId = agent.getRuntimeId();

            if ((agentId != null) && (rId != null) && rId.equals(agentId)) {
            	if(!agent.eIsSet(HierarchyPackage.eINSTANCE.getTRCAgent_StartTime()))
            	{
					agent.setStartTime(time);
            	}
				if(agentProxy!=null && !agentProxy.eIsSet(HierarchyPackage.eINSTANCE.getTRCAgentProxy_StartTime()))
				{
					agentProxy.setStartTime(time);
				}
                return;
            }

            agent = null;
        }

        /* We need at least an agentName, id and a processIdRef to find the process and create the agent */
        if ((agentName == null) || (agentId == null)) {
            return;
        }

        LoadersUtils.setDefaultContext(context);

        /* If we don't have a process association, find it based upon our monitor */
        TRCProcessProxy process = context.getProcessProxy();
        TRCMonitor monitor = context.getMonitor();
        TRCNode node = context.getNode();

        if (agent == null) {
            agent = LoadersUtils.locateAgentFromProcess(process, agentName, agentId);
        }

        if (agent != null) {
            if (agentId != null) {
                agent.setRuntimeId(agentId);
            } else {
                agent.setRuntimeId("0");
            }

            agent.setCollectionMode(context.getCollectionMode());

            if (agent.eResource() != null) {
				registerAgent(agent);
                if(context.getAgent()==null)
                {
                	context.setAgent(agent);
                	context.setContextURI(agent.eResource().getURI().toString());
					LookupServiceExtensions.getInstance().register(null, context);
                }
				if(context.getAgentProxy()==null)
				{
					agentProxy = agent.getAgentProxy();
					if(agentProxy!=null)
					{
						context.setAgentProxy(agentProxy);
						agentProxy.setCollectionMode(context.getCollectionMode());
					}
					
				}
                return;
            }
        }

        String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
        Resource agDoc = null;

        if (monitorFolder != null) {
            String aName = StringUtil.change(monitor.getName().trim(), " ", "") + "_" + node.getName().trim() + "_" + process.getPid() + "_" + process.getRuntimeId() + "_" + StringUtil.change(agentName.trim(), " ", "");

            String pFileName = monitorFolder + aName;

            agDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(pFileName + ".trcaxmi")).createResource(SaveUtil.createURI(pFileName + ".trcaxmi"));

            HierarchyResourceSetImpl.getInstance().getResources().add(agDoc);
            SaveUtil.addDocument(agDoc);
        }

		if (agent == null) {
			agent = HierarchyFactory.eINSTANCE.createTRCAgent();
			agent.setCollectionMode(context.getCollectionMode());
			agentProxy=null;
		}

		if(agent.getAgentProxy()!=null)
			agentProxy = agent.getAgentProxy();

		if (agentProxy == null) {
			agentProxy = HierarchyFactory.eINSTANCE.createTRCAgentProxy();
			agentProxy.setName(agentName);
			agentProxy.setStartTime(time);
			agentProxy.setType(agentType);
			agentProxy.setProcessProxy(process);
			agentProxy.setCollectionMode(context.getCollectionMode());
		}

        agent.setName(agentName);

        agent.setStartTime(time);
		agentProxy.setStartTime(time);

        if (agentType != null) {
            agent.setType(agentType);
        }

        agent.setRuntimeId(agentId);
        agentProxy.setRuntimeId(agentId);

        agent.setAgentProxy(agentProxy);

        agentProxy.setProcessProxy(context.getProcessProxy());

        context.setAgent(agent);
        context.setAgentProxy(agentProxy);
        context.setContextURI(agDoc.getURI().toString());

        LookupServiceExtensions.getInstance().register(null, context);
		registerAgent(agent);

        if (agDoc != null) {
            agDoc.getContents().add(agent);
        }
    }

	private void registerAgent(TRCAgent agent) {
		AgentsContext agentsContext = (AgentsContext )LookupServiceExtensions.getInstance().locate(null,AgentsContext.class,LoadersUtils.getLookUpKey(agent.getRuntimeId()));
		if(agentsContext==null)
		{
			agentsContext = new AgentsContext(agent.getRuntimeId());
			LookupServiceExtensions.getInstance().register(null, agentsContext);
		}
		agentsContext.registerAgent(agent);
	}

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        agentId = null;
        agentName = null;
        agentType = null;
        processIdRef = null;
        time = 0;
        version = null;
    }
}
