/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Represents all forward invocations for an agent, it is used to recover the
 * caller-callee link when the callee comes before the caller.
 *
 * @author slavescu
 */
public class ForwardInvocations {
    //~ Instance fields ----------------------------------------------------------------------------

    /**
     * a map with all forward invocations in an agent, the key is threadID+"-"+token of the invoker and the value is an array list with all
     * the invocation contexts of directly invoked methods
     */
    protected Map targets = new HashMap();

    //~ Constructors -------------------------------------------------------------------------------

    public ForwardInvocations() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    /**
     * @return the list of InvocationContext's for all the target invocations (invoked by invoker)
     */
    public List getInvokes(String invocationId, boolean create) {
        List list = (List) targets.get(invocationId);

        if ((list == null) && create) {
            list = new ArrayList();
            targets.put(invocationId,list);
        }

        return list;
    }

    public Map getTargets() {
        return targets;
    }
}
