/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;


public class HierarchyContext extends AgentProxyContext{
    //~ Instance fields ----------------------------------------------------------------------------

    private List globalForwardReferences;
	private String contextURI;
    private TRCAgent agent;
    private TRCMonitor monitor;
    private TRCNode node;
    private TRCProcessProxy processProxy;
    private Map customData;
	/**
	 *
	 */

	public HierarchyContext() {
		super();
	}

    //~ Methods ------------------------------------------------------------------------------------

    /**
     * Sets the agent.
     * @param agent The agent to set
     */
    public void setAgent(TRCAgent agent) {
        this.agent = agent;
    }

    /**
     * @return TRCAgent
     */
    public TRCAgent getAgent() {
        return agent;
    }

    /**
     * Sets the globalForwardReferences.
     * @param globalForwardReferences The globalForwardReferences to set
     */
    public void setGlobalForwardReferences(List globalForwardReferences) {
        this.globalForwardReferences = globalForwardReferences;
    }

    /**
     * @return List
     */
    public List getGlobalForwardReferences() {
    	if(globalForwardReferences==null)
			globalForwardReferences = new ArrayList();
        return globalForwardReferences;
    }

    /**
     * Sets the monitor.
     * @param monitor The monitor to set
     */
    public void setMonitor(TRCMonitor monitor) {
        this.monitor = monitor;
    }

    /**
     * @return TRCMonitor
     */
    public TRCMonitor getMonitor() {
        return monitor;
    }

    /**
     * Sets the node.
     * @param node The node to set
     */
    public void setNode(TRCNode node) {
        this.node = node;
    }

    /**
     * @return TRCNode
     */
    public TRCNode getNode() {
        return node;
    }

    /**
     * Sets the processProxy.
     * @param processProxy The processProxy to set
     */
    public void setProcessProxy(TRCProcessProxy processProxy) {
        this.processProxy = processProxy;
    }

    /**
     * @return TRCProcessProxy
     */
    public TRCProcessProxy getProcessProxy() {
        return processProxy;
    }
	/**
	 * @return
	 */
	public String getContextURI() {
		return contextURI;
	}

	/**
	 * @param string
	 */
	public void setContextURI(String string) {
		contextURI = string;
	}

	/**
	 * Map for storing custom data, each loader can add it's own key/value pairs.
	 * @return
	 */
	public Map getCustomData()
	{
		if(customData==null)
			customData = new HashMap();
		return customData;
	}

	/**
	 * @param map
	 */
	public void setCustomData(Map map)
	{
		customData = map;
	}

}
