/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.HashMap;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;


public class XMLFragmentHandlerExtensions extends HashMap {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static XMLFragmentHandlerExtensions instance;

    //~ Constructors -------------------------------------------------------------------------------

    /**
     *
     */
    private XMLFragmentHandlerExtensions() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    /**
     *
     */
    public static XMLFragmentHandlerExtensions getInstance() {
        if (instance == null) {
            instance = new XMLFragmentHandlerExtensions();
            new XMLFragmentHandlerRegistryReader().readRegistry();
        }

        return instance;
    }



}

/**
 * A plugin extension reader that populates the
 * loaders registry.
 * Clients are not expected to use this class directly.
 */
class XMLFragmentHandlerRegistryReader extends RegistryReader {
	//~ Static fields/initializers -----------------------------------------------------------------

	static final String TAG_HANDLER = "handler";
	static final String ATT_CLASS = "class";

	//~ Constructors -------------------------------------------------------------------------------

	public XMLFragmentHandlerRegistryReader() {
		super(Platform.getPluginRegistry(), HierarchyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), HierarchyPlugin.HANDLER_PPID);
	}

	//~ Methods ------------------------------------------------------------------------------------

	protected boolean readElement(IConfigurationElement element) {
		if (element.getName().equals(TAG_HANDLER)) {
			if (element.getAttribute(ATT_CLASS) == null) {
				logMissingAttribute(element, ATT_CLASS);
			} else {
				if (XMLFragmentHandlerExtensions.getInstance().size()>0) {
					logError(element, "Another handler has been already registered. Only the first registered XML handler would be active.");
				} else {
					try {
						PluginClassDescriptor classDescriptor = new PluginClassDescriptor(element, ATT_CLASS);

						XMLFragmentHandlerExtensions.getInstance().put(TAG_HANDLER, (XMLFragmentHandler) classDescriptor.createInstance());
					} catch (Exception e) {
						logError(element, e.getLocalizedMessage());
					}

					return true;
				}
			}
		}

		return false;
	}
}
