/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.model;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestCase
extends Test
{
	private TestSuite testSuite;
	
	/**
	 * @see org.eclipse.hyades.test.manual.runner.model.NamedElement#dispose()
	 */
	public void dispose()
	{
		testSuite = null;
		super.dispose();
	}

	
	public TestSuite getTestSuite()
	{
		return testSuite;
	}

	public void setTestSuite(TestSuite newTestSuite)
	{
		if(testSuite == newTestSuite)
			return;
		
		if(testSuite != null)
			testSuite.getTestCases().remove(this);
			
		this.testSuite = newTestSuite;
		
		if(!testSuite.getTestCases().contains(this))
			testSuite.getTestCases().add(this);
	}
}