/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.local;


import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.MessageDeliveryException;
import org.eclipse.hyades.execution.core.MessageProcessingException;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * This is the parent of the hierarchy of <code>IExecutionComponent<code> stubs
 * -- objects that handle remote invocation semantics for their delegates, which
 * are <code>IExecutionComponent</code> instances.
 */
public abstract class ExecutionComponentStub
	extends RemoteObjectStub
	implements IExecutionComponent {
	
	public ExecutionComponentStub() {}

	public ExecutionComponentStub(IExecutionComponent delegate) {
		this.delegate=delegate;
	}

	public void init() {
		((IExecutionComponent)delegate).init();
	}

	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getName()
	 */
	public String getName() {
		return ((IExecutionComponent)delegate).getName();
	}

	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getId()
	 */
	public String getId() {
		return ((IExecutionComponent)delegate).getId();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getType()
	 */
	public String getType() {
		return ((IExecutionComponent)delegate).getType();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getVersion()
	 */
	public String getVersion() {
		return ((IExecutionComponent)delegate).getVersion();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getParent()
	 */
	public IExecutionComponent getParent() {
		return ((IExecutionComponent)delegate).getParent();
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#setParent(org.eclipse.hyades.execution.core.IExecutionComponent)
	 */
	public void setParent(IExecutionComponent parent) {
		((IExecutionComponent)delegate).setParent(parent);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getChildren()
	 */
	public IExecutionComponent[] getChildren() {
		return ((IExecutionComponent)delegate).getChildren();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getChildById(java.lang.String)
	 */
	public IExecutionComponent getChildById(String id) {
		return ((IExecutionComponent)delegate).getChildById(id);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getChildByName(java.lang.String)
	 */
	public IExecutionComponent getChildByName(String name) {
		return ((IExecutionComponent)delegate).getChildByName(name);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#addChild(org.eclipse.hyades.execution.core.IExecutionComponnet)
	 */
	public void addChild(IExecutionComponent child) {
		((IExecutionComponent)delegate).addChild(child);
		if(child instanceof IRemoteObject) {
			ReturnData invokeRtn = delegateRemoteCall(new Class[]{IExecutionComponent.class}, new Object[]{child}, "addChild");
			Object rtnValue = invokeRtn.getReturnValue();
			if(invokeRtn.isError()) {
				throw new RemoteInvocationException((Throwable)rtnValue);
			}
		}	
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getNode()
	 */
	public INode getNode() {
		return ((IExecutionComponent)delegate).getNode();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#getState()
	 */
	public int getState() {
		return ((IExecutionComponent)delegate).getState();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#addExecutionComponentStateChangeListener(org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener)
	 */
	public void addExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener listener) {
		((IExecutionComponent)delegate).addExecutionComponentStateChangeListener(listener);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#removeExecutionComponentStateChangeListener(org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener)
	 */
	public void removeExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener listener) {
		((IExecutionComponent)delegate).removeExecutionComponentStateChangeListener(listener);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#fireStateChangeEvent(org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent)
	 */
	public void fireStateChangeEvent(ExecutionComponentStateChangeEvent event) {
		((IExecutionComponent)delegate).fireStateChangeEvent(event);
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#handleMessage(org.eclipse.hyades.execution.core.IControlMessage)
	 */
	public void handleMessage(IControlMessage message) throws MessageProcessingException {
		((IExecutionComponent)delegate).handleMessage(message);
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#sendMessage(org.eclipse.hyades.execution.core.IControlMessage)
	 */
	public void sendMessage(IControlMessage message) throws MessageDeliveryException {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{IControlMessage.class}, new Object[]{message}, "sendMessage");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
	}
	

}
