/*
 * Created on Jun 20, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.execution.local;

import java.util.Enumeration;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class JavaProcessExecutorStub extends ExecutorStub {
	
	
	public String getPid() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "getPid");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		return (String)rtnValue;
	}
	
	public void launch() throws ExecutionComponentStateException {
		/* Launch the process */
		super.launch();
		
		int trialCount=60;
		
		/* Get the process ID of the new process */
		String pid=getPid();
		
		/* Create a process model and agent for the other side */
		try {
/**/			boolean found=false;
			Node node=((SessionStub)getSessionContext()).getAgent().getProcess().getNode();
			
/**/			while(!found && trialCount>0) {
				Enumeration processes=node.listProcesses();
				
				while(processes.hasMoreElements()) {
					Process proc=(Process)processes.nextElement();
					if(proc.getProcessId().equals(pid)) {
						//System.out.println("Found process "+pid);
/**/						found=true;
						synchronized(proc) {
							Enumeration agents=proc.getAgentsByType("tester");
							while(agents.hasMoreElements()) {
								Agent agent=(Agent)agents.nextElement();
								//System.out.println("Found agent "+agent.getName());
								try {
									
									agent.addAgentListener(new AgentListener() {

										public void error(Agent agent, String errorId, String errorMessage) {
								//			System.out.println("recieving error: "+errorMessage);
										}

										public void handleCommand(Agent agent, CommandElement command) {
											if(command instanceof CustomCommand) {
												String errorMessage=((CustomCommand)command).getData();
												System.out.println("recieving message: "+errorMessage);
											}
										}

										public void agentActive(Agent agent) {
										}

										public void agentInactive(Agent agent) {	
										}									
									});
									
									agent.attach();
									
									/* Find our RemoteHyadesComponent and set the agent */
									IExecutionComponent[] children=getChildren();
									for (int i=0; i<children.length;i++) {
										if(children[i] instanceof IRemoteHyadesComponent) {
											((JavaTaskRemoteHyadesComponentStub)children[i]).setAgent(agent);
										}
									}

									
									try
									{
										IExecutableObject executableObject = getExecutableObject();
										if(executableObject instanceof JavaProcessExecutableObjectStub)
										{
											String script = ((JavaProcessExecutableObjectStub)executableObject).getAgentData();
											if(script != null)
											{
												CustomCommand agentData = new CustomCommand();
												agentData.setData(script.getBytes("UTF-8"));
												agent.invokeCustomCommand(agentData);
											}
										}
									}
									catch(Exception e1)
									{
										e1.printStackTrace();
									}
									
									CustomCommand resumeCommand=new CustomCommand();
									resumeCommand.setData(IControlMessage.START);
									agent.invokeCustomCommand(resumeCommand);
								}
								catch(InactiveAgentException e) {
									
								}
								
							}
						}
					}
					try {
						Thread.sleep(1000);	
					}
					catch(InterruptedException e) {
					}
					trialCount--;
/**/				}
			}
			
			
	
/*	
			final Object agentLock=new Object();
 
			synchronized(agentLock) {
				agent.addAgentListener(new AgentListener() {
					public void agentActive(Agent agent) {
						synchronized(agentLock) {
							agentLock.notify();
						}
						fireStateChangeEvent(new ExecutionComponentStateChangeEvent(
							JavaProcessExecutorStub.this, READY));
					}
	
					public void agentInactive(Agent agent) {
						
						fireStateChangeEvent(new ExecutionComponentStateChangeEvent(
							JavaProcessExecutorStub.this, DEAD));
					}
	
					public void error(Agent agent, String errorId, String errorMessage) {
						StringBuffer buf = new StringBuffer();
						buf.append("ERROR: Agent \"");
						buf.append(agent.getName());
						buf.append("\"\nERROR ID: \"");
						buf.append(errorId);
						buf.append("\"\nERROR MESSAGE: \"");
						buf.append(errorMessage);
						buf.append("\"\n");
						System.err.println(buf.toString());
					}
	
					public void handleCommand(Agent agent, CommandElement command) {
						System.out.println(agent.getName() + " handleCommand() called");
					}
				});
				agent.setAutoAttach(true);
				
				
				/* return when we are good to go 
				try {
					agentLock.wait();
				}
				catch(InterruptedException e) {
				}	
			}
			*/
			
		}
		catch(InactiveProcessException e) {
			/* We can ignore this as our process is running */
		}
		catch(NotConnectedException e) {
			/* Wecan ignore this as we are connected */
		}
		
		
		
		
	}

}
