/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (6/2/00 1:15:33 PM)
 * @author: Administrator
 */
public interface Constants {

	/* Various Message types currently available */
	public static final byte RA_ACKNOWLEDGEMENT_MESSAGE			=0x00000000;
	public static final byte RA_CONTROL_MESSAGE					=0x00000001;




	public final static long RA_MAGIC						=0x82656780;
	public final static long RA_VERSION						=0x00000100;

	/* The various COMMAND_ID's types from the client (server targeted flows) */
	public final static long RA_AUTHENTICATE					=0x00000001;
	public final static long RA_LAUNCH_PROCESS					=0x00000010;
	public final static long RA_KILL_PROCESS					=0x0000001B;
	public final static long RA_QUERY_PROCESS_LIST				=0x00000011;
	public final static long RA_QUERY_AGENT_LIST				=0x00000012;
	public final static long RA_QUERY_AGENT_DETAILS				=0x0000001C;
	public final static long RA_REGISTER_AGENT_NOTIFICATION		=0x00000013;
	public final static long RA_ATTACH_TO_AGENT					=0x00000014;
	public final static long RA_DETACH_FROM_AGENT				=0x00000015;
	public final static long RA_START_MONITORING_AGENT_REMOTE	=0x00000016;
	public final static long RA_START_MONITORING_AGENT_LOCAL	=0x00000017;
	public final static long RA_STOP_MONITORING_AGENT			=0x00000018;
	public final static long RA_SET_NAME_VALUE_PAIR				=0x00000019;

	/* The extension point for custom protocol piggy-backing */
	public final static long RA_CUSTOM_COMMAND					=0x0000001A;

	/* The various COMMAND_ID's from the Remoteable Agent Controller (client targeted flows) */
	public final static long RA_AUTHENTICATION_FAILED			=0x00000002;
	public final static long RA_AUTHENTICATION_SUCCESSFUL		=0x00000003;
	public final static long RA_SERVER_SECURITY_REQUIREMENTS		=0x00000004;
	public final static long RA_PROCESS_LAUNCHED				=0x00000020;
	public final static long RA_PROCESS_EXITED					=0x00000029;
	public final static long RA_PROCESS_LIST					=0x00000021;
	public final static long RA_AGENT_LIST						=0x00000022;
	public final static long RA_AGENT_ACTIVE					=0x00000023;
	public final static long RA_AGENT_INACTIVE					=0x00000024;
	public final static long RA_AGENT_DETAILS					=0x00000028;
	public final static long RA_ERROR_STRING					=0x00000025;
	public final static long RA_CONTROLLER_REQUEST_MONITOR				=0x00000062;
	

	/**
 	  * Various constants that both the client and server must adhere to.
 	  */
	public final static int CTL_PORT_NUM_SERVER			=10002; /* hardcoded to start with */
	public final static int CTL_PORT_NUM_CLIENT			=10003; /* hardcoded to start with */
	public final static int MESSAGE_HEADER_LENGTH		=10;		/* 10 byte header to start with */
	public final static int MAX_MESSAGE_LENGTH			=8096;	/* The maximum size of a message */
	public final static int MAX_COMMAND_LINE_LENGTH		=512;	/* Maximum length of a command line string */
	public final static int DATA_PORT_NUM_CLIENT		=10004;
	public final static int MAX_DATA_LENGTH				=4096;	/* The size of the data buffer for sockets */

	/* This package is ported from C, so to facilitate sizeof code for primitives
	   the following constants are provided */

	public final static int sizeofByte					=1;
	public static final int sizeofChar					=2;
	public static final int sizeofShort					=2;
	public static final int	sizeofLong					=4;


	
	
}
