/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.net.DatagramSocket;
import java.net.DatagramPacket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.InetAddress;
import java.net.SocketException;
import java.io.IOException;

/**
 * Insert the type's description here.
 * Creation date: (9/15/00 12:42:56 PM)
 * @author:
 */
public final class ControlServerDaemon implements Constants {

	private DatagramServer _server=null;
	private DatagramSocket _sock=null;
	private AcknowledgementHandler	_ackHandler=null;
	private CommandHandler 			_cmdHandler=null;

class DatagramServer extends Thread implements Constants{
	DatagramSocket _socket=null;


	public void setSocket(DatagramSocket sock) {
		_socket=sock;
	}

	public void run() {

		/* Run forever */
		while(true) {
			byte[] buffer=new byte[MAX_MESSAGE_LENGTH];
			DatagramPacket data=new DatagramPacket(buffer, MAX_MESSAGE_LENGTH);
			try {
				_socket.receive(data);
				
				/* Is this a valid message type */
				Message incommingMessage=new Message();
				incommingMessage.readFromBuffer(data.getData(), data.getLength());

				/* Send an acknowledgement to the message originator */
				if(incommingMessage.getType()!=RA_ACKNOWLEDGEMENT_MESSAGE) {
					byte[] responseBuffer = new byte[16];
					AcknowledgementMessage ack=new AcknowledgementMessage();
					ack.setTicket(incommingMessage.getTicket());
					ack.writeToBuffer(responseBuffer, 0);
					DatagramPacket response=new DatagramPacket(responseBuffer, 12, data.getAddress(), data.getPort());
					_socket.send(response);
				}
				processMessage(data.getData(), data.getLength(), data.getAddress());
			}
			catch(IOException e) {
				/* TO_DO: Must provide proper handler */
			}
		}
	}

	protected void processMessage(byte[] buffer, int bufferSize, InetAddress server) {
		long type=Message.readRALongFromBuffer(buffer, 8);
		switch((int)type) {
		case RA_ACKNOWLEDGEMENT_MESSAGE:
			processAcknowledgementMessage(buffer, bufferSize, server);
			break;
		case RA_CONTROL_MESSAGE:
			processControlMessage(buffer, bufferSize, server);
			break;
		default:
		     break;
		}
	}

	protected void processAcknowledgementMessage(byte[] buffer, int bufferSize, InetAddress server) {
		if(_ackHandler != null) {
			AcknowledgementMessage msg=new AcknowledgementMessage();
			msg.readFromBuffer(buffer, bufferSize);
			_ackHandler.incommingAcknowledgement(server, msg.getTicket());
		}
	}

	protected void processControlMessage(byte[] buffer, int bufferSize, InetAddress server) {
		if(_cmdHandler != null) {
			ControlMessage msg=new ControlMessage();
			msg.readFromBuffer(buffer, bufferSize);

			/* Valid pass on each command */
			int count=msg.getCommandCount();
			for(int i=0; i<count; i++) {
				_cmdHandler.incommingCommand(server, msg.getCommand(i));
			}
		}
	}
} // end class ControlDatagramServer


/**
 * ControlServer constructor comment.
 */
public ControlServerDaemon() {
	super();
}
public void sendMessage(byte[] buffer, int length, InetAddress addr) throws IOException {
	DatagramPacket message=new DatagramPacket(buffer, length, addr, CTL_PORT_NUM_SERVER);
	_sock.send(message);
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 3:16:00 PM)
 * @param handler com.ibm.jvmpi.client.AcknowledgementHandler
 */
public void setAcknowledgementHandler(AcknowledgementHandler handler) {
	_ackHandler=handler;
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 3:15:10 PM)
 * @param handler com.ibm.jvmpi.client.CommandHandler
 */
public void setCommandHandler(CommandHandler handler) {
	_cmdHandler=handler;
}
public void startServer() throws SocketException {
	/* Is the server already started? */
	if(_server!=null)
		return;
	_sock=new DatagramSocket();
	_server=new DatagramServer();
	_server.setSocket(_sock);
	/* Don't block exit of the VM */
	_server.setDaemon(true);
	_server.start();
}
}
